/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.update;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.LocalizeUtils;
import java.io.Serializable;

public abstract class ValueUpdate
implements Localizable,
Serializable {
    private static final long serialVersionUID = -4059275656078639103L;
    private Frame frame;
    private transient RemoteSession client;
    private boolean transactionScope = false;

    public ValueUpdate(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RemoteSession getClient() {
        return this.client;
    }

    public void setClient(RemoteSession remoteSession) {
        this.client = remoteSession;
    }

    public void localize(KnowledgeBase knowledgeBase) {
        LocalizeUtils.localize(this.frame, knowledgeBase);
    }

    public boolean isTransactionScope() {
        return this.transactionScope;
    }

    public void setTransactionScope(boolean bl) {
        this.transactionScope = bl;
    }

    public abstract ValueUpdate getInvalidatingVariant();

    public String toString() {
        return "ValueUpdate[" + this.frame.getFrameID() + ", Client = " + this.client + ", Transaction(" + this.transactionScope + ")]";
    }
}

