/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.update;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.update.InvalidateCacheUpdate;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.util.LocalizeUtils;

public class SftUpdate
extends ValueUpdate
implements Localizable {
    private static final long serialVersionUID = 8969314633657333324L;
    private Slot slot;
    private Facet facet;
    private boolean isTemplate;

    public SftUpdate(Frame frame, Slot slot, Facet facet, boolean bl) {
        super(frame);
        this.slot = slot;
        this.facet = facet;
        this.isTemplate = bl;
    }

    public Facet getFacet() {
        return this.facet;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public void localize(KnowledgeBase knowledgeBase) {
        super.localize(knowledgeBase);
        LocalizeUtils.localize(this.slot, knowledgeBase);
        LocalizeUtils.localize(this.facet, knowledgeBase);
    }

    public ValueUpdate getInvalidatingVariant() {
        return new InvalidateCacheUpdate(this.getFrame(), this.slot, this.facet, this.isTemplate);
    }

    public String toString() {
        return "[" + super.toString() + ", " + this.slot.getFrameID() + ", " + (this.facet == null ? "null" : "" + this.facet.getFrameID()) + ", " + this.isTemplate + "]";
    }
}

