/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.narrowframestore;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.narrowframestore.RemoteServerNarrowFrameStore;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNarrowFrameStore
extends UnicastRemoteObject
implements RemoteServerNarrowFrameStore {
    private static final long serialVersionUID = 1996943880174792714L;
    private static transient Logger log = Log.getLogger(ServerNarrowFrameStore.class);
    private NarrowFrameStore delegate;
    private NarrowFrameStore fixedDelegate;
    private KnowledgeBase kb;

    public ServerNarrowFrameStore(NarrowFrameStore narrowFrameStore, KnowledgeBase knowledgeBase) throws RemoteException {
        this.delegate = narrowFrameStore;
        this.kb = knowledgeBase;
        this.fixedDelegate = (NarrowFrameStore)Proxy.newProxyInstance(knowledgeBase.getClass().getClassLoader(), new Class[]{NarrowFrameStore.class}, (InvocationHandler)new ServerInvocationHandler());
    }

    private void localize(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                LocalizeUtils.localize(object, this.kb);
            }
        }
    }

    @Override
    public String getName(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getName();
    }

    @Override
    public void setName(String string, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        this.fixedDelegate.setName(string);
    }

    @Override
    public NarrowFrameStore getDelegate(RemoteSession remoteSession) throws RemoteException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public FrameID generateFrameID(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.generateFrameID();
    }

    @Override
    public int getFrameCount(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getFrameCount();
    }

    @Override
    public int getClsCount(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getClsCount();
    }

    @Override
    public int getSlotCount(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getSlotCount();
    }

    @Override
    public int getFacetCount(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getFacetCount();
    }

    @Override
    public int getSimpleInstanceCount(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getSimpleInstanceCount();
    }

    @Override
    public Set<Frame> getFrames(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getFrames();
    }

    @Override
    public Frame getFrame(FrameID frameID, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getFrame(frameID);
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getValues(frame, slot, facet, bl);
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getValuesCount(frame, slot, facet, bl);
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        this.fixedDelegate.addValues(frame, slot, facet, bl, collection);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        this.fixedDelegate.moveValue(frame, slot, facet, bl, n, n2);
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        this.fixedDelegate.removeValue(frame, slot, facet, bl, object);
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        this.fixedDelegate.setValues(frame, slot, facet, bl, collection);
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean bl, Object object, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getFrames(slot, facet, bl, object);
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean bl, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getFramesWithAnyValue(slot, facet, bl);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getMatchingFrames(slot, facet, bl, string, n);
    }

    @Override
    public Set<Reference> getReferences(Object object, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getReferences(object);
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getMatchingReferences(string, n);
    }

    @Override
    public Set<Frame> executeQuery(Query query, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        SynchronizeQueryCallback synchronizeQueryCallback = new SynchronizeQueryCallback(this.kb);
        this.fixedDelegate.executeQuery(query, synchronizeQueryCallback);
        return synchronizeQueryCallback.waitForResults();
    }

    @Override
    public void deleteFrame(Frame frame, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        this.fixedDelegate.deleteFrame(frame);
    }

    @Override
    public void close(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        this.fixedDelegate.close();
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getClosure(frame, slot, facet, bl);
    }

    @Override
    public void replaceFrame(Frame frame, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        this.fixedDelegate.replaceFrame(frame);
    }

    @Override
    public boolean beginTransaction(String string, RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.beginTransaction(string);
    }

    @Override
    public boolean commitTransaction(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.commitTransaction();
    }

    @Override
    public boolean rollbackTransaction(RemoteSession remoteSession) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor(RemoteSession remoteSession) throws TransactionException, RemoteException {
        ServerFrameStore.recordCallNoCheck(remoteSession);
        return this.fixedDelegate.getTransactionStatusMonitor();
    }

    private class ServerInvocationHandler
    implements InvocationHandler {
        private ServerInvocationHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            ClassLoader classLoader;
            Object[] objectArray2;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Server invoking client requested method " + method + " on " + object.getClass());
                if (objectArray != null) {
                    objectArray2 = objectArray;
                    int n = objectArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Object object2 = objectArray2[i];
                        log.fine("\tArgument = " + object2);
                    }
                } else {
                    log.fine("No args");
                }
            }
            if ((objectArray2 = Thread.currentThread().getContextClassLoader()) != (classLoader = ServerNarrowFrameStore.this.kb.getClass().getClassLoader())) {
                if (log.isLoggable(Level.FINE)) {
                    Log.getLogger().fine("Changing loader from " + objectArray2 + " to " + classLoader);
                }
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            ServerNarrowFrameStore.this.localize(objectArray);
            try {
                KnowledgeBase knowledgeBase = ServerNarrowFrameStore.this.kb;
                synchronized (knowledgeBase) {
                    return method.invoke((Object)ServerNarrowFrameStore.this.delegate, objectArray);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }
}

