/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject;

import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.Policy_Test;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;

public class MetaProject_Test
extends SimpleTestCase {
    public static final String METAPROJECT = "junit/pprj/policy/metaproject.pprj";
    public static final String NATASHA = "Natasha Noy";
    public static final String NEWSPAPER = "Newspaper";
    public final String NEW_USER_NAME = "MyUser";
    public final String NEW_USER_PASS = "MyPassword";
    public final String NEW_PROJECT_NAME = "MyProject";
    public final String NEW_PROJECT_LOCATION = "in_same_directory.pprj";
    public final String NEW_OPERATION_NAME = "MyOperation";
    public final String NEW_GROUP_NAME = "MyGroup";

    public void test_createUser() {
        MetaProjectImpl mp = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        MetaProject_Test.assertNotNull((Object)mp.getUser(NATASHA));
        User user = mp.createUser("MyUser", "MyPassword");
        MetaProject_Test.assertTrue((boolean)mp.getUsers().contains(user));
        User sameUser = mp.getUser("MyUser");
        MetaProject_Test.assertTrue((boolean)sameUser.equals(user));
    }

    public void test_createProject() {
        MetaProjectImpl mp = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        ProjectInstance project = mp.createProject("MyProject");
        MetaProject_Test.assertTrue((boolean)mp.getProjects().contains(project));
        MetaProject_Test.assertEquals((String)project.getName(), (String)"MyProject");
        ProjectInstance sameProject = mp.getProject("MyProject");
        MetaProject_Test.assertTrue((boolean)sameProject.equals(project));
        project.setLocation("in_same_directory.pprj");
        MetaProject_Test.assertEquals((String)"in_same_directory.pprj", (String)project.getLocation());
        Log.getLogger().info("Create project: " + project.getName() + " in location: " + project.getLocation());
    }

    public void test_createOperation() {
        MetaProjectImpl mp = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        Operation op = mp.createOperation("MyOperation");
        MetaProject_Test.assertTrue((boolean)mp.getOperations().contains(op));
        Operation sameOp = mp.getOperation("MyOperation");
        MetaProject_Test.assertTrue((boolean)sameOp.equals(op));
    }

    public void test_createGroup() {
        MetaProjectImpl mp = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        Group g = mp.createGroup("MyGroup");
        MetaProject_Test.assertTrue((boolean)mp.getGroups().contains(g));
        Group sameG = mp.getGroup("MyGroup");
        MetaProject_Test.assertTrue((boolean)sameG.equals(g));
        MetaProject_Test.assertTrue((boolean)mp.getGroups().contains(g));
        User user = mp.createUser("MyUser", "MyPassword");
        User natasha = mp.getUser(NATASHA);
        g.addMember(user);
        g.addMember(natasha);
        MetaProject_Test.assertEquals((int)g.getMembers().size(), (int)2);
    }

    public void test_createPolicies() {
        MetaProjectImpl mp = new MetaProjectImpl(URIUtilities.createURI(METAPROJECT));
        ProjectInstance project = mp.createProject("MyProject");
        ProjectInstance newspaper = mp.getProject(NEWSPAPER);
        newspaper.setAnnotationProject(project);
        MetaProject_Test.assertEquals((Object)project, (Object)newspaper.getAnnotationProject());
        User user = mp.createUser("MyUser", "MyPassword");
        User natasha = mp.getUser(NATASHA);
        Group g = mp.createGroup("MyGroup");
        g.addMember(user);
        g.addMember(natasha);
        Operation op = mp.createOperation("MyOperation");
        GroupOperation groupOp = mp.createGroupOperation();
        groupOp.setAllowedGroup(g);
        groupOp.addAllowedOperation(op);
        groupOp.addAllowedOperation(mp.getOperation(MetaProjectConstants.OPERATION_READ.getName()));
        MetaProject_Test.assertTrue((groupOp.getAllowedOperations().size() == 2 ? 1 : 0) != 0);
        project.addAllowedGroupOperations(groupOp);
        Policy policy = mp.getPolicy();
        Policy_Test.checkAuthorization(policy, natasha, op, project, true);
        Policy_Test.checkAuthorization(policy, user, op, project, true);
        Policy_Test.checkAuthorization(policy, user, MetaProjectConstants.OPERATION_WRITE, project, false);
    }
}

