/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore.background;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.Registration;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.ClientAndFrame;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.framestore.background.ServerCacheStateMachine;
import edu.stanford.smi.protege.server.framestore.background.ServerCachedState;
import edu.stanford.smi.protege.server.framestore.background.WorkInfo;
import edu.stanford.smi.protege.server.update.FrameEvaluationCompleted;
import edu.stanford.smi.protege.server.update.FrameEvaluationPartial;
import edu.stanford.smi.protege.server.update.FrameEvaluationStarted;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameCalculator {
    private static transient Logger log = Log.getLogger(FrameCalculator.class);
    private FrameStore fs;
    private final Object kbLock;
    private FifoWriter<ValueUpdate> updates;
    private ServerFrameStore server;
    private RemoteSession effectiveClient;
    FrameCalculatorThread innerThread;
    private Object requestLock = new Object();
    private SortedSet<WorkInfo> requests = new TreeSet<WorkInfo>();
    private Map<ClientAndFrame, WorkInfo> requestMap = new HashMap<ClientAndFrame, WorkInfo>();
    private ServerCacheStateMachine machine = null;
    private static boolean disabled = false;
    FrameCalculatorStatsImpl stats = new FrameCalculatorStatsImpl();

    public FrameCalculator(FrameStore frameStore, ServerCacheStateMachine serverCacheStateMachine, Object object, FifoWriter<ValueUpdate> fifoWriter, ServerFrameStore serverFrameStore, Map<RemoteSession, Registration> map) {
        this.fs = frameStore;
        this.machine = serverCacheStateMachine;
        this.kbLock = object;
        this.updates = fifoWriter;
        this.server = serverFrameStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateMachine(ServerCacheStateMachine serverCacheStateMachine) {
        Object object = this.requestLock;
        synchronized (object) {
            this.machine = serverCacheStateMachine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(WorkInfo workInfo) throws ServerSessionLost {
        Set set;
        Frame frame = workInfo.getFrame();
        this.effectiveClient = workInfo.getClient();
        ServerFrameStore.setCurrentSession(this.effectiveClient);
        if (log.isLoggable(Level.FINE)) {
            set = this.kbLock;
            synchronized (set) {
                log.fine("Precalculating " + this.fs.getFrameName(frame) + "/" + frame.getFrameID());
            }
        }
        try {
            this.stats.startWork();
            set = this.kbLock;
            synchronized (set) {
                if (this.server.inTransaction()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("\tbut transaction in progress");
                    }
                    workInfo.setTargetFullCache(false);
                } else {
                    this.insertValueUpdate(new FrameEvaluationStarted(frame));
                }
            }
            set = null;
            List list = null;
            Object object = this.kbLock;
            synchronized (object) {
                this.checkAbilityToGenerateFullCache(workInfo);
                set = this.fs.getOwnSlots(frame);
            }
            for (Iterator iterator : set) {
                Object object2 = this.kbLock;
                synchronized (object2) {
                    this.checkAbilityToGenerateFullCache(workInfo);
                    if (iterator.getFrameID().equals(Model.SlotID.DIRECT_INSTANCES) && workInfo.skipDirectInstances()) {
                        this.server.invalidateCacheForWriteToStore(frame, (Slot)((Object)iterator), null, false);
                    } else {
                        list = this.fs.getDirectOwnSlotValues(frame, (Slot)((Object)iterator));
                        if (list != null && !list.isEmpty()) {
                            this.server.cacheValuesReadFromStore(this.effectiveClient, frame, (Slot)((Object)iterator), null, false, list);
                        }
                    }
                    this.addFollowedExprs(frame, (Slot)((Object)iterator), list);
                }
            }
            if (frame instanceof Cls) {
                Iterator iterator;
                object = (Cls)frame;
                iterator = this.kbLock;
                synchronized (iterator) {
                    this.checkAbilityToGenerateFullCache(workInfo);
                    set = this.fs.getTemplateSlots((Cls)object);
                }
                for (Object object2 : set) {
                    Set<Facet> set2 = this.kbLock;
                    synchronized (set2) {
                        this.checkAbilityToGenerateFullCache(workInfo);
                        list = this.fs.getDirectTemplateSlotValues((Cls)object, (Slot)object2);
                        if (list != null && !list.isEmpty()) {
                            this.server.cacheValuesReadFromStore(this.effectiveClient, (Frame)object, (Slot)object2, null, true, list);
                        }
                    }
                    Iterator<Facet> iterator2 = this.kbLock;
                    synchronized (iterator2) {
                        this.checkAbilityToGenerateFullCache(workInfo);
                        set2 = this.fs.getTemplateFacets((Cls)object, (Slot)object2);
                    }
                    for (Facet facet : set2) {
                        Object object3 = this.kbLock;
                        synchronized (object3) {
                            this.checkAbilityToGenerateFullCache(workInfo);
                            list = this.fs.getDirectTemplateFacetValues((Cls)object, (Slot)object2, facet);
                            if (list != null && !list.isEmpty()) {
                                this.server.cacheValuesReadFromStore(this.effectiveClient, (Frame)object, (Slot)object2, facet, true, list);
                            }
                        }
                    }
                }
            }
            object = this.kbLock;
            synchronized (object) {
                if (workInfo.isTargetFullCache() && !this.server.inTransaction()) {
                    this.insertValueUpdate(new FrameEvaluationCompleted(frame));
                } else if (workInfo.isTargetFullCache()) {
                    this.insertValueUpdate(new FrameEvaluationPartial(workInfo.getFrame()));
                }
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.SEVERE, "Exception caught caching frame values", throwable);
            workInfo.setTargetFullCache(false);
            this.insertValueUpdate(new FrameEvaluationPartial(workInfo.getFrame()));
        }
        finally {
            this.stats.completeWork();
        }
    }

    private void checkAbilityToGenerateFullCache(WorkInfo workInfo) {
        if (this.server.inTransaction() && workInfo.isTargetFullCache()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Found transaction in progress - can't complete cache for frame " + workInfo.getFrame());
            }
            workInfo.setTargetFullCache(false);
            this.insertValueUpdate(new FrameEvaluationPartial(workInfo.getFrame()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFollowedExprs(Frame frame, Slot slot, List list) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.machine == null) {
                return;
            }
            WorkInfo workInfo = this.requestMap.get(new ClientAndFrame(this.effectiveClient, frame));
            if (workInfo == null) {
                return;
            }
            for (ServerCachedState serverCachedState : workInfo.getStates()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Following expr " + frame + " with slot " + slot + " in state " + serverCachedState);
                }
                for (Object e : list) {
                    Frame frame2;
                    ServerCachedState serverCachedState2;
                    if (!(e instanceof Frame) || (serverCachedState2 = this.machine.nextState(serverCachedState, frame, slot, frame2 = (Frame)e)) == null) continue;
                    WorkInfo workInfo2 = this.addRequest(frame2, serverCachedState2, CacheRequestReason.STATE_MACHINE);
                    if (workInfo2 != null) {
                        workInfo2.setClient(workInfo.getClient());
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Added cache request frame for state transition " + frame + " x " + serverCachedState + " -> " + frame2 + " x " + serverCachedState2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkInfo addRequest(Frame frame, RemoteSession remoteSession, CacheRequestReason cacheRequestReason) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.addRequest(frame, remoteSession, this.machine == null ? null : this.machine.getInitialState(), cacheRequestReason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkInfo addRequest(Frame frame, ServerCachedState serverCachedState, CacheRequestReason cacheRequestReason) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.addRequest(frame, this.effectiveClient, serverCachedState, cacheRequestReason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkInfo addRequest(Frame frame, RemoteSession remoteSession, ServerCachedState serverCachedState, CacheRequestReason cacheRequestReason) {
        if (disabled) {
            return null;
        }
        if (frame.getKnowledgeBase() == null) {
            log.log(Level.WARNING, "Non-localized frame being added to the FrameCalculator", new Exception());
        }
        Object object = this.requestLock;
        synchronized (object) {
            ClientAndFrame clientAndFrame = new ClientAndFrame(remoteSession, frame);
            WorkInfo workInfo = this.requestMap.get(clientAndFrame);
            if (workInfo == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Added " + frame.getFrameID() + " in state " + serverCachedState + " with reason " + (Object)((Object)cacheRequestReason) + " to head of frames to precalculate");
                }
                workInfo = new WorkInfo();
                workInfo.setClient(remoteSession);
                workInfo.setFrame(frame);
                this.requestMap.put(clientAndFrame, workInfo);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    Object object2 = this.kbLock;
                    synchronized (object2) {
                        log.fine("Updating state for " + frame.getFrameID() + " to include " + serverCachedState);
                    }
                }
                this.requests.remove(workInfo);
            }
            workInfo.addState(serverCachedState);
            workInfo.addReason(cacheRequestReason);
            workInfo.setNewest();
            this.requests.add(workInfo);
            if (this.innerThread == null || this.innerThread.getStatus() == RunStatus.SHUTDOWN) {
                this.innerThread = new FrameCalculatorThread();
                this.innerThread.start();
            }
            return workInfo;
        }
    }

    private void insertValueUpdate(ValueUpdate valueUpdate) {
        valueUpdate.setClient(this.effectiveClient);
        this.server.updateEvents(this.effectiveClient);
        this.updates.write(valueUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(RemoteSession remoteSession) {
        Object object = this.requestLock;
        synchronized (object) {
            ArrayList<WorkInfo> arrayList = new ArrayList<WorkInfo>();
            for (WorkInfo workInfo : this.requests) {
                if (!workInfo.getClient().equals(remoteSession)) continue;
                arrayList.add(workInfo);
            }
            for (WorkInfo workInfo : arrayList) {
                this.requests.remove(workInfo);
                this.requestMap.remove(workInfo.getClientAndFrame());
            }
        }
    }

    public static void setDisabled(boolean bl) {
        disabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameCalculatorStats getStats() {
        HashMap<RemoteSession, Integer> hashMap = new HashMap<RemoteSession, Integer>();
        Object object = this.requestLock;
        synchronized (object) {
            for (WorkInfo workInfo : this.requests) {
                RemoteSession remoteSession = workInfo.getClient();
                Integer n = (Integer)hashMap.get(remoteSession);
                if (n == null) {
                    hashMap.put(remoteSession, 1);
                    continue;
                }
                hashMap.put(remoteSession, n + 1);
            }
        }
        this.stats.setPreCacheBackLog(hashMap);
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRequests() {
        block19: {
            if (log.isLoggable(Level.FINE)) {
                try {
                    if (log.isLoggable(Level.FINER)) {
                        TreeSet<WorkInfo> treeSet;
                        Iterator iterator = this.requestLock;
                        synchronized (iterator) {
                            treeSet = new TreeSet<WorkInfo>(this.requests);
                        }
                        log.fine("Request queue has size " + treeSet.size());
                        for (WorkInfo workInfo : treeSet) {
                            log.finer("Request for frame" + workInfo.getFrame());
                            log.finer("\tClient = " + workInfo.getClient());
                            log.finer("\tStates = " + workInfo.getStates());
                            log.finer("\tReasons = " + workInfo.getReasons());
                        }
                        break block19;
                    }
                    EnumMap<CacheRequestReason, Integer> enumMap = new EnumMap<CacheRequestReason, Integer>(CacheRequestReason.class);
                    HashMap<ServerCachedState, Integer> hashMap = new HashMap<ServerCachedState, Integer>();
                    for (CacheRequestReason object3 : CacheRequestReason.values()) {
                        enumMap.put(object3, 0);
                    }
                    Object object = this.requestLock;
                    synchronized (object) {
                        log.fine("Request queue has size " + this.requests.size());
                        for (WorkInfo workInfo : this.requests) {
                            for (Object object2 : workInfo.getStates()) {
                                Integer n = (Integer)hashMap.get(object2);
                                if (n == null) {
                                    n = 0;
                                }
                                hashMap.put((ServerCachedState)object2, n + 1);
                            }
                        }
                        for (WorkInfo workInfo : this.requests) {
                            for (Object object2 : workInfo.getReasons()) {
                                enumMap.put((CacheRequestReason)((Object)object2), (Integer)enumMap.get(object2) + 1);
                            }
                        }
                    }
                    for (Object object4 : hashMap.keySet()) {
                        if (hashMap.get(object4) == null) continue;
                        log.fine("\tCount for state " + object4 + " = " + hashMap.get(object4));
                    }
                    for (CacheRequestReason cacheRequestReason : CacheRequestReason.values()) {
                        if ((Integer)enumMap.get((Object)cacheRequestReason) == 0) continue;
                        log.fine("\tCount for reason " + cacheRequestReason + " = " + enumMap.get((Object)cacheRequestReason));
                    }
                }
                catch (Throwable throwable) {
                    log.log(Level.FINE, "Could not log requests", throwable);
                }
            }
        }
    }

    public Object getRequestLock() {
        return this.requestLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inFrameCalculatorThread() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.innerThread == null) {
                return false;
            }
            return Thread.currentThread().equals(this.innerThread);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FrameCalculatorStatsImpl
    implements FrameCalculatorStats,
    Serializable {
        private static final long serialVersionUID = -573113660316027300L;
        private long startWorkTime;
        private long workUnits = 0L;
        private long totalWorkTime = 0L;
        private Map<RemoteSession, Integer> preCacheBacklog;

        private void startWork() {
            this.startWorkTime = System.currentTimeMillis();
        }

        private void completeWork() {
            this.totalWorkTime = this.totalWorkTime + System.currentTimeMillis() - this.startWorkTime;
            ++this.workUnits;
        }

        @Override
        public Map<RemoteSession, Integer> getPreCacheBacklog() {
            return this.preCacheBacklog;
        }

        public void setPreCacheBackLog(Map<RemoteSession, Integer> map) {
            this.preCacheBacklog = map;
        }

        @Override
        public long getPrecalculateTime() {
            return this.totalWorkTime / this.workUnits;
        }
    }

    private class FrameCalculatorThread
    extends Thread {
        private RunStatus status;

        public FrameCalculatorThread() {
            super("Frame Pre-Calculation Thread");
            this.status = RunStatus.IDLE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = FrameCalculator.this.requestLock;
            synchronized (object) {
                this.status = RunStatus.RUNNING;
            }
            try {
                while (true) {
                    WorkInfo workInfo;
                    object = FrameCalculator.this.requestLock;
                    synchronized (object) {
                        if (FrameCalculator.this.requests.isEmpty()) {
                            this.status = RunStatus.SHUTDOWN;
                            return;
                        }
                        workInfo = (WorkInfo)FrameCalculator.this.requests.first();
                    }
                    long l = System.currentTimeMillis();
                    FrameCalculator.this.doWork(workInfo);
                    Object object2 = FrameCalculator.this.requestLock;
                    synchronized (object2) {
                        FrameCalculator.this.requests.remove(workInfo);
                        FrameCalculator.this.requestMap.remove(new ClientAndFrame(workInfo.getClient(), workInfo.getFrame()));
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("work on frame " + workInfo.getFrame() + " took " + (System.currentTimeMillis() - l));
                    FrameCalculator.this.logRequests();
                }
            }
            catch (Throwable throwable) {
                Log.getLogger().log(Level.SEVERE, "Exception caught in background frame value evaluator", throwable);
                Log.getLogger().severe("Pre-caching of frames will fail.");
                return;
            }
        }

        public RunStatus getStatus() {
            return this.status;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RunStatus {
        IDLE,
        RUNNING,
        SHUTDOWN;

    }
}

