/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.FrameCalculatorFrameStore;
import edu.stanford.smi.protege.server.framestore.Registration;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.framestore.background.WorkInfo;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.impl.UserImpl;
import edu.stanford.smi.protege.server.update.FrameRead;
import edu.stanford.smi.protege.server.update.FrameWrite;
import edu.stanford.smi.protege.server.update.InvalidateCacheUpdate;
import edu.stanford.smi.protege.server.update.OntologyUpdate;
import edu.stanford.smi.protege.server.update.RemoteResponse;
import edu.stanford.smi.protege.server.update.RemoveFrameCache;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFrameStore
extends UnicastRemoteObject
implements RemoteServerFrameStore {
    private static final long serialVersionUID = 2965578539383364549L;
    private static transient Logger log = Log.getLogger(ServerFrameStore.class);
    public static final transient Logger cacheLog = Logger.getLogger("org.protege.client.cache");
    private FrameStore _delegate;
    private KnowledgeBase _kb;
    private TransactionMonitor transactionMonitor;
    private ProjectInstance projectInstance;
    private FifoWriter<AbstractEvent> _eventWriter = new FifoWriter();
    private FifoWriter<ValueUpdate> _updateWriter;
    private Map<RemoteSession, Registration> _sessionToRegistrationMap;
    private boolean _isDirty;
    private final Object _kbLock;
    private Facet valuesFacet;
    private static Map<Thread, RemoteSession> sessionMap = new HashMap<Thread, RemoteSession>();
    private FrameCalculator frameCalculator;
    private static Set<KnowledgeBase> requiresEventDispatch = new HashSet<KnowledgeBase>();
    private static int nDelayedCalls = 0;

    public ServerFrameStore(KnowledgeBase knowledgeBase) throws RemoteException {
        this._eventWriter.setLogger(cacheLog, "New Event");
        this._updateWriter = new FifoWriter();
        this._updateWriter.setLogger(cacheLog, "ValueUpdate");
        this._sessionToRegistrationMap = new HashMap<RemoteSession, Registration>();
        this._kb = knowledgeBase;
        this._kbLock = knowledgeBase;
        FrameStoreManager frameStoreManager = ((DefaultKnowledgeBase)knowledgeBase).getFrameStoreManager();
        if (!requiresEventDispatch.contains(knowledgeBase)) {
            knowledgeBase.setDispatchEventsEnabled(false);
        } else {
            EventDispatchFrameStore eventDispatchFrameStore = (EventDispatchFrameStore)frameStoreManager.getFrameStoreFromClass(EventDispatchFrameStore.class);
            eventDispatchFrameStore.setPassThrough(true);
            requiresEventDispatch.remove(knowledgeBase);
        }
        this.valuesFacet = this._kb.getSystemFrames().getValuesFacet();
        this.frameCalculator = new FrameCalculator(frameStoreManager.getHeadFrameStore(), ((DefaultKnowledgeBase)this._kb).getCacheMachine(), this._kbLock, this._updateWriter, this, this._sessionToRegistrationMap);
        frameStoreManager.insertFrameStore(new FrameCalculatorFrameStore(this.frameCalculator));
        this._delegate = frameStoreManager.getHeadFrameStore();
        this.transactionMonitor = this._delegate.getTransactionStatusMonitor();
        if (ServerProperties.delayInMilliseconds() != 0) {
            Log.getLogger().config("Simulated delay of " + ServerProperties.delayInMilliseconds() + " msec/call");
        }
        this.startHeartbeatThread(this._kb.toString());
    }

    public static void requestEventDispatch(KnowledgeBase knowledgeBase) {
        knowledgeBase.setDispatchEventsEnabled(true);
        requiresEventDispatch.add(knowledgeBase);
    }

    private void startHeartbeatThread(String string) {
        if (!ServerProperties.heartbeatDisabled()) {
            new Thread("Heartbeat checker [" + string + "]"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(3000L);
                            long l = System.currentTimeMillis();
                            Object object = ServerFrameStore.this._kbLock;
                            synchronized (object) {
                                for (Map.Entry entry : ServerFrameStore.this._sessionToRegistrationMap.entrySet()) {
                                    Registration registration = (Registration)entry.getValue();
                                    long l2 = registration.getLastHeartbeat();
                                    if (l2 == 0L || l2 > l - 24000L) continue;
                                    RemoteSession remoteSession = (RemoteSession)entry.getKey();
                                    Log.getLogger().info("Session disconnected because of timeout");
                                    ServerFrameStore.this.deregister(remoteSession);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        Log.getLogger().log(Level.WARNING, "Heartbeat thread died", exception);
                        return;
                    }
                }
            }.start();
        }
    }

    @Override
    public Map<RemoteSession, Boolean> getUserInfo() {
        HashMap<RemoteSession, Boolean> hashMap = new HashMap<RemoteSession, Boolean>();
        for (RemoteSession remoteSession : this._sessionToRegistrationMap.keySet()) {
            if (this.transactionMonitor != null) {
                hashMap.put(remoteSession, this.transactionMonitor.getNesting(remoteSession) > 0);
                continue;
            }
            hashMap.put(remoteSession, Boolean.FALSE);
        }
        return hashMap;
    }

    @Override
    public FrameCalculatorStats getStats() {
        ServerFrameStore.delay();
        return this.frameCalculator.getStats();
    }

    private FrameStore getDelegate() {
        return this._delegate;
    }

    private static void delay() {
        if (ServerProperties.delayInMilliseconds() != 0) {
            SystemUtilities.sleepMsec(ServerProperties.delayInMilliseconds());
            if (++nDelayedCalls % 10 == 0) {
                Log.getLogger().info(nDelayedCalls + " delayed calls");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCall(RemoteSession remoteSession) throws ServerSessionLost {
        Map<Thread, RemoteSession> map = sessionMap;
        synchronized (map) {
            if (!this._sessionToRegistrationMap.containsKey(remoteSession)) {
                throw new ServerSessionLost("Dropped connection due to timeout");
            }
        }
        ServerFrameStore.recordCallNoCheck(remoteSession);
    }

    public static void recordCallNoCheck(RemoteSession remoteSession) {
        ServerFrameStore.delay();
        ServerFrameStore.setCurrentSession(remoteSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentSession(RemoteSession remoteSession) {
        Map<Thread, RemoteSession> map = sessionMap;
        synchronized (map) {
            sessionMap.put(Thread.currentThread(), remoteSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteSession getCurrentSession() {
        Map<Thread, RemoteSession> map = sessionMap;
        synchronized (map) {
            return sessionMap.get(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClsCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getClsCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSlotCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getSlotCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFacetCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getFacetCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSimpleInstanceCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getSimpleInstanceCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getFrameCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectTemplateSlot(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().removeDirectTemplateSlot(cls, slot);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectTemplateSlot(Cls cls, Slot slot, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().moveDirectTemplateSlot(cls, slot, n);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectSuperclass(Cls cls, Cls cls2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().addDirectSuperclass(cls, cls2);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectSuperslot(Slot slot, Slot slot2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().removeDirectSuperslot(slot, slot2);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectSuperclass(Cls cls, Cls cls2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().removeDirectSuperclass(cls, cls2);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectSubclass(Cls cls, Cls cls2, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().moveDirectSubclass(cls, cls2, n);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectTemplateSlotValues(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        LocalizeUtils.localize(cls, this._kb);
        Object object = this._kbLock;
        synchronized (object) {
            List list = this.getDelegate().getDirectTemplateSlotValues(cls, slot);
            this.cacheValuesReadFromStore(remoteSession, cls, slot, null, true, list);
            return new RemoteResponse<List>(list, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set<Instance>> getInstances(Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            Set<Instance> set = this.getDelegate().getInstances(cls);
            return new RemoteResponse<Set<Instance>>(set, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getFramesWithDirectOwnSlotValue(Slot slot, Object object, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object2 = this._kbLock;
        synchronized (object2) {
            return this.getDelegate().getFramesWithDirectOwnSlotValue(slot, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object object, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object2 = this._kbLock;
        synchronized (object2) {
            return this.getDelegate().getClsesWithDirectTemplateSlotValue(slot, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object object, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object2 = this._kbLock;
        synchronized (object2) {
            return this.getDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String string, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String string, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        LocalizeUtils.localize(cls, this._kb);
        Object object = this._kbLock;
        synchronized (object) {
            List list = this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
            this.cacheValuesReadFromStore(remoteSession, cls, slot, facet, true, list);
            return new RemoteResponse<List>(list, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Cls> getClses(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getClses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getTemplateFacets(cls, slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Frame> getFrame(String string, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            Frame frame = this.getDelegate().getFrame(string);
            return new RemoteResponse<Frame>(frame, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame getFrame(FrameID frameID, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getFrame(frameID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        LocalizeUtils.localize(frame, this._kb);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectOwnSlotValues(Frame frame, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        if (log.isLoggable(Level.FINE)) {
            log.fine("getDirectOwnSlotValues for frame " + frame.getFrameID() + " slot " + slot.getFrameID());
        }
        LocalizeUtils.localize(frame, this._kb);
        LocalizeUtils.localize(slot, this._kb);
        Object object = this._kbLock;
        synchronized (object) {
            List list = this.getDelegate().getDirectOwnSlotValues(frame, slot);
            this.cacheValuesReadFromStore(remoteSession, frame, slot, null, false, list);
            return new RemoteResponse<List>(list, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection arrayList, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            if (!(arrayList instanceof List)) {
                arrayList = new ArrayList(arrayList);
            }
            this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, arrayList);
            this.markDirty();
            this.updateCacheForWriteToStore(remoteSession, cls, slot, facet, true, arrayList);
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Facet> createFacet(FrameID frameID, String string, Collection collection, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.markDirty();
            Facet facet = this.getDelegate().createFacet(frameID, string, collection, bl);
            return new RemoteResponse<Facet>(facet, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFrames(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getFrames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectTemplateSlotValues(Cls cls, Slot slot, Collection arrayList, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        if (!(arrayList instanceof List)) {
            arrayList = new ArrayList(arrayList);
        }
        Object object = this._kbLock;
        synchronized (object) {
            this.markDirty();
            this.getDelegate().setDirectTemplateSlotValues(cls, slot, arrayList);
            this.updateCacheForWriteToStore(remoteSession, cls, slot, null, true, arrayList);
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getTemplateFacetValues(cls, slot, facet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteCls(Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().deleteCls(cls);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteSlot(Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().deleteSlot(slot);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteFacet(Facet facet, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().deleteFacet(facet);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteSimpleInstance(SimpleInstance simpleInstance, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().deleteSimpleInstance(simpleInstance);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Slot> createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.markDirty();
            Slot slot = this.getDelegate().createSlot(frameID, string, collection, collection2, bl);
            return new RemoteResponse<Slot>(slot, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectSuperslot(Slot slot, Slot slot2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().addDirectSuperslot(slot, slot2);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectTemplateSlot(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().addDirectTemplateSlot(cls, slot);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().moveDirectOwnSlotValue(frame, slot, n, n2);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectOwnSlotValues(Frame frame, Slot slot, Collection arrayList, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        if (!(arrayList instanceof List)) {
            arrayList = new ArrayList(arrayList);
        }
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().setDirectOwnSlotValues(frame, slot, arrayList);
            this.markDirty();
            this.updateCacheForWriteToStore(remoteSession, frame, slot, null, false, arrayList);
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Cls> createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.markDirty();
            Cls cls = this.getDelegate().createCls(frameID, string, collection, collection2, bl);
            return new RemoteResponse<Cls>(cls, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Facet> getFacets(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getFacets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set<Frame>> executeQuery(Query query, RemoteSession remoteSession) throws ProtegeException, ServerSessionLost {
        this.recordCall(remoteSession);
        SynchronizeQueryCallback synchronizeQueryCallback = new SynchronizeQueryCallback(this._kbLock);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().executeQuery(query, synchronizeQueryCallback);
        }
        return new RemoteResponse<Set<Frame>>(synchronizeQueryCallback.waitForResults(), this.getValueUpdates(remoteSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectType(Instance instance, Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().removeDirectType(instance, cls);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getReferences(Object object, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object2 = this._kbLock;
        synchronized (object2) {
            return this.getDelegate().getReferences(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getMatchingReferences(String string, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getMatchingReferences(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithMatchingBrowserText(String string, Collection collection, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getClsesWithMatchingBrowserText(string, collection, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<SimpleInstance> createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.markDirty();
            SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(frameID, string, collection, bl);
            return new RemoteResponse<SimpleInstance>(simpleInstance, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectType(Instance instance, Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().addDirectType(instance, cls);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectType(Instance instance, Cls cls, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().moveDirectType(instance, cls, n);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFrameName(Frame frame, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getFrameName(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setFrameName(Frame frame, String string, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().setFrameName(frame, string);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getOverriddenTemplateSlots(Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getOverriddenTemplateSlots(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getDirectlyOverriddenTemplateSlots(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getOverriddenTemplateFacets(cls, slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getOverriddenTemplateFacets(cls, slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectTemplateFacetOverrides(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
            this.markDirty();
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    @Override
    public void close(RemoteSession remoteSession) throws ServerSessionLost {
        ServerFrameStore.recordCallNoCheck(remoteSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Object> executeProtegeJob(ProtegeJob protegeJob, RemoteSession remoteSession) throws ProtegeException, ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                protegeJob.localize(this._kb);
            }
            object = protegeJob.run();
            Object object2 = this._kbLock;
            synchronized (object2) {
                return new RemoteResponse<Object>(object, this.getValueUpdates(remoteSession));
            }
        }
        catch (ProtegeException protegeException) {
            Log.getLogger().log(Level.WARNING, "Exception on remote execution", protegeException);
            throw protegeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RemoteSession remoteSession) throws ServerSessionLost {
        Object object = this._kbLock;
        synchronized (object) {
            Registration registration = new Registration(this._eventWriter, this._updateWriter);
            this._sessionToRegistrationMap.put(remoteSession, registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            while (this.inTransaction()) {
                this.rollbackTransaction(remoteSession);
            }
            this._sessionToRegistrationMap.remove(remoteSession);
            this.frameCalculator.deregister(remoteSession);
        }
    }

    @Override
    public String toString() {
        return "ServerFrameStore[" + this._kb + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List<AbstractEvent>> getEvents(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.updateEvents(remoteSession);
            ArrayList<AbstractEvent> arrayList = new ArrayList<AbstractEvent>();
            Registration registration = this._sessionToRegistrationMap.get(remoteSession);
            if (registration == null) {
                throw new IllegalStateException("Not registered");
            }
            FifoReader<AbstractEvent> fifoReader = registration.getEvents();
            AbstractEvent abstractEvent = null;
            while ((abstractEvent = fifoReader.read()) != null) {
                arrayList.add(abstractEvent);
            }
            return new RemoteResponse<List<AbstractEvent>>(arrayList, this.getValueUpdates(remoteSession));
        }
    }

    public void updateEvents(RemoteSession remoteSession) {
        Registration registration = this._sessionToRegistrationMap.get(remoteSession);
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        for (AbstractEvent abstractEvent : this.getDelegate().getEvents()) {
            this.addEvent(remoteSession, registration, transactionIsolationLevel, abstractEvent);
        }
    }

    private void addEvent(RemoteSession remoteSession, Registration registration, TransactionIsolationLevel transactionIsolationLevel, AbstractEvent abstractEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Server Processing event " + abstractEvent);
        }
        this.processEvent(remoteSession, registration, transactionIsolationLevel, abstractEvent);
        this._eventWriter.write(abstractEvent);
    }

    private List<ValueUpdate> getValueUpdates(RemoteSession remoteSession) {
        this.updateEvents(remoteSession);
        FifoReader<ValueUpdate> fifoReader = this._sessionToRegistrationMap.get(remoteSession).getUpdates();
        ValueUpdate valueUpdate = null;
        ArrayList<ValueUpdate> arrayList = new ArrayList<ValueUpdate>();
        while ((valueUpdate = fifoReader.read()) != null) {
            RemoteSession remoteSession2 = valueUpdate.getClient();
            if (remoteSession2 != null && !remoteSession2.equals(remoteSession)) continue;
            arrayList.add(valueUpdate);
        }
        return arrayList;
    }

    private void processEvent(RemoteSession remoteSession, Registration registration, TransactionIsolationLevel transactionIsolationLevel, AbstractEvent abstractEvent) {
        if (abstractEvent instanceof FrameEvent) {
            this.handleFrameEvent(remoteSession, registration, transactionIsolationLevel, (FrameEvent)abstractEvent);
        } else if (abstractEvent instanceof ClsEvent) {
            this.handleClsEvent(remoteSession, registration, transactionIsolationLevel, (ClsEvent)abstractEvent);
        }
        if (abstractEvent instanceof KnowledgeBaseEvent) {
            this.handleKnowledgeBaseEvent(remoteSession, registration, transactionIsolationLevel, (KnowledgeBaseEvent)abstractEvent);
        }
    }

    private void handleFrameEvent(RemoteSession remoteSession, Registration registration, TransactionIsolationLevel transactionIsolationLevel, FrameEvent frameEvent) {
        Frame frame = frameEvent.getFrame();
        int n = frameEvent.getEventType();
        if (n == 106) {
            Slot slot = frameEvent.getSlot();
            this.invalidateCacheForWriteToStore(frame, slot, null, false);
        } else if (n == 110) {
            Slot slot = frameEvent.getSlot();
            this.invalidateCacheForWriteToStore(frame, slot, null, false);
        } else if (n == 107) {
            Slot slot = frameEvent.getSlot();
            this.updateCacheForWriteToStore(remoteSession, frame, slot, null, false, null);
        } else if (n == 102) {
            this.removeFrameCache(frame);
        }
    }

    private void handleClsEvent(RemoteSession remoteSession, Registration registration, TransactionIsolationLevel transactionIsolationLevel, ClsEvent clsEvent) {
        Cls cls = clsEvent.getCls();
        int n = clsEvent.getEventType();
        if (n == 310) {
            Slot slot = clsEvent.getSlot();
            this.invalidateCacheForWriteToStore(cls, slot, this.valuesFacet, true);
        } else if (n == 311) {
            Slot slot = clsEvent.getSlot();
            Facet facet = clsEvent.getFacet();
            this.invalidateCacheForWriteToStore(cls, slot, facet, true);
        } else if (n == 313) {
            Slot slot = clsEvent.getSlot();
            Facet facet = clsEvent.getFacet();
            this.invalidateCacheForWriteToStore(cls, slot, facet, true);
        }
    }

    private void handleKnowledgeBaseEvent(RemoteSession remoteSession, Registration registration, TransactionIsolationLevel transactionIsolationLevel, KnowledgeBaseEvent knowledgeBaseEvent) {
        int n = knowledgeBaseEvent.getEventType();
        if (n == 602 || n == 604 || n == 606 || n == 608) {
            Frame frame = knowledgeBaseEvent.getFrame();
            this.removeFrameCache(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> beginTransaction(String string, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Begin Transaction for session " + remoteSession);
        }
        Object object = this._kbLock;
        synchronized (object) {
            this.updateEvents(remoteSession);
            boolean bl = this.getDelegate().beginTransaction(string);
            return new RemoteResponse<Boolean>(bl, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> commitTransaction(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Commit Transaction for Session " + remoteSession);
        }
        Object object = this._kbLock;
        synchronized (object) {
            boolean bl = this.getDelegate().commitTransaction();
            this.updateEvents(remoteSession);
            if (!this.inTransaction()) {
                Registration registration = this._sessionToRegistrationMap.get(remoteSession);
                TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
                if (bl && transactionIsolationLevel != null && transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) >= 0) {
                    for (ValueUpdate valueUpdate : registration.getCommits()) {
                        this._updateWriter.write(valueUpdate);
                    }
                }
                registration.endTransaction();
            }
            if (!this.existsTransaction()) {
                this._kbLock.notifyAll();
            }
            return new RemoteResponse<Boolean>(bl, this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> rollbackTransaction(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Rollback Transaction for session " + remoteSession);
        }
        Object object = this._kbLock;
        synchronized (object) {
            this.updateEvents(remoteSession);
            boolean bl = this.getDelegate().rollbackTransaction();
            if (!this.inTransaction()) {
                Registration registration = this._sessionToRegistrationMap.get(remoteSession);
                TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
                if (bl && (transactionIsolationLevel != null || transactionIsolationLevel.compareTo(TransactionIsolationLevel.READ_COMMITTED) < 0)) {
                    for (ValueUpdate valueUpdate : registration.getCommits()) {
                        ValueUpdate valueUpdate2 = valueUpdate.getInvalidatingVariant();
                        if (valueUpdate2 == null) continue;
                        this._updateWriter.write(valueUpdate2);
                    }
                }
                registration.endTransaction();
            }
            if (!this.existsTransaction()) {
                this._kbLock.notifyAll();
            }
            return new RemoteResponse<Boolean>(bl, this.getValueUpdates(remoteSession));
        }
    }

    public void removeFrameCache(Frame frame) {
        RemoveFrameCache removeFrameCache;
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.updateEvents(remoteSession);
        Registration registration = this._sessionToRegistrationMap.get(remoteSession);
        if (transactionIsolationLevel == null) {
            this._updateWriter.write(new RemoveFrameCache(frame));
            if (this.inTransaction()) {
                registration.addCommittableUpdate(new RemoveFrameCache(frame));
            }
            removeFrameCache = new RemoveFrameCache(frame);
            removeFrameCache.setTransactionScope(true);
            this._updateWriter.write(removeFrameCache);
        }
        removeFrameCache = new RemoveFrameCache(frame);
        if (!TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel)) {
            removeFrameCache.setClient(remoteSession);
            removeFrameCache.setTransactionScope(true);
        }
        this._updateWriter.write(removeFrameCache);
        if (!TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel)) {
            registration.addCommittableUpdate(new RemoveFrameCache(frame));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionIsolationLevel getTransactionIsolationLevel() {
        try {
            Object object = this._kbLock;
            synchronized (object) {
                if (this.transactionMonitor == null) {
                    return TransactionIsolationLevel.NONE;
                }
                return this.transactionMonitor.getTransationIsolationLevel();
            }
        }
        catch (TransactionException transactionException) {
            Log.getLogger().log(Level.WARNING, "Exception caught finding transaction isolation level", transactionException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) throws TransactionException {
        Object object = this._kbLock;
        synchronized (object) {
            if (this.transactionMonitor == null) {
                return false;
            }
            this.transactionMonitor.setTransactionIsolationLevel(transactionIsolationLevel);
        }
        return true;
    }

    public boolean inTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.inTransaction();
    }

    public boolean existsTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.existsTransaction();
    }

    public boolean exclusiveTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.exclusiveTransaction();
    }

    public TransactionMonitor getTransactionStatusMonitor() {
        return this.transactionMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTransactionsToComplete() {
        Object object = this._kbLock;
        synchronized (object) {
            while (this.existsTransaction()) {
                try {
                    this._kbLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    log.log(Level.WARNING, "Interrupted waiting for transactions to complete", interruptedException);
                }
            }
        }
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    private void markDirty() {
        this._isDirty = true;
    }

    public void markClean() {
        this._isDirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectSubslot(Slot slot, Slot slot2, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            this.getDelegate().moveDirectSubslot(slot, slot2, n);
            return new OntologyUpdate(this.getValueUpdates(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getFramesWithAnyDirectOwnSlotValue(Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getFramesWithAnyDirectOwnSlotValue(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithAnyDirectTemplateSlotValue(Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            return this.getDelegate().getClsesWithAnyDirectTemplateSlotValue(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set> getDirectOwnSlotValuesClosure(Frame frame, Slot slot, Set<Frame> set, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Set set2 = null;
        Iterator<Frame> iterator = this._kbLock;
        synchronized (iterator) {
            set2 = this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
        }
        LocalizeUtils.localize(set, this._kb);
        for (Frame frame2 : set) {
            this.frameCalculator.addRequest(frame2, remoteSession, CacheRequestReason.USER_CLOSURE_REQUEST);
        }
        return new RemoteResponse<Set>(set2, this.getValueUpdates(remoteSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set> getDirectOwnSlotValuesClosure(Collection<Frame> collection, Slot slot, Set<Frame> set, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        HashSet hashSet = new HashSet();
        Iterator<Frame> iterator = this._kbLock;
        synchronized (iterator) {
            for (Frame frame : collection) {
                Set set2 = this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
                if (set2 == null) continue;
                hashSet.addAll(set2);
            }
        }
        LocalizeUtils.localize(set, this._kb);
        for (Frame frame : set) {
            this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_CLOSURE_REQUEST);
        }
        return new RemoteResponse<Set>(hashSet, this.getValueUpdates(remoteSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate preload(Set<String> set, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        int n = 0;
        Object object = this._kbLock;
        synchronized (object) {
            n = this.getDelegate().getFrameCount();
        }
        if (bl || n < ServerProperties.minimumPreloadedFrames()) {
            object = this._kbLock;
            synchronized (object) {
                for (Frame frame : this.getDelegate().getFrames()) {
                    this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.PRELOAD);
                }
            }
        } else {
            this.addUserFrames(remoteSession, set);
            this.addSystemClasses(remoteSession);
        }
        return new OntologyUpdate(this.getValueUpdates(remoteSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemClasses(RemoteSession remoteSession) {
        LinkedHashSet<Frame> linkedHashSet = new LinkedHashSet<Frame>();
        Cls cls = null;
        List<Cls> list = this._kbLock;
        synchronized (list) {
            cls = this._kb.getRootCls();
        }
        this.addSystemClasses(linkedHashSet, cls);
        list = null;
        Iterator<Cls> iterator = this._kbLock;
        synchronized (iterator) {
            list = this._delegate.getDirectSubclasses(cls);
        }
        for (Cls frame : list) {
            linkedHashSet.add(frame);
        }
        for (Frame frame : linkedHashSet) {
            this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.PRELOAD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemClasses(Set<Frame> set, Cls cls) {
        if (!cls.getFrameID().isSystem() || set.contains(cls)) {
            return;
        }
        List<Cls> list = null;
        Set<Slot> set2 = this._kbLock;
        synchronized (set2) {
            list = this._delegate.getDirectSubclasses(cls);
        }
        set2 = null;
        Iterator<Instance> iterator = this._kbLock;
        synchronized (iterator) {
            set2 = this._delegate.getOwnSlots(cls);
            set2.addAll(this._delegate.getTemplateSlots(cls));
        }
        for (Slot instance : set2) {
            if (!instance.isSystem()) continue;
            set.add(instance);
        }
        for (Cls cls2 : list) {
            this.addSystemClasses(set, cls2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserFrames(RemoteSession remoteSession, Set<String> set) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (String object : set) {
            Frame frame = null;
            Object object2 = this._kbLock;
            synchronized (object2) {
                frame = this._delegate.getFrame(object);
            }
            if (frame == null) continue;
            hashSet.add(frame);
            if (!(frame instanceof Cls)) continue;
            object2 = (Cls)frame;
            for (Object e : this._kb.getSuperclasses((Cls)object2)) {
                Cls cls = (Cls)e;
                hashSet.add(cls);
                hashSet.addAll(cls.getDirectSubclasses());
            }
            Object object3 = this._kbLock;
            synchronized (object3) {
                hashSet.addAll(this._kb.getSuperclasses((Cls)frame));
                hashSet.addAll(this._kb.getDirectSubclasses((Cls)frame));
            }
        }
        for (Frame frame : hashSet) {
            this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.IMMEDIATE_PRELOAD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestValueCache(Set<Frame> set, boolean bl, RemoteSession remoteSession) {
        Object object = this.frameCalculator.getRequestLock();
        synchronized (object) {
            for (Frame frame : set) {
                LocalizeUtils.localize(frame, this._kb);
                WorkInfo workInfo = this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_SPECIFIC_FRAMES);
                if (workInfo == null) continue;
                workInfo.setSkipDirectInstances(bl);
            }
        }
    }

    public FrameCalculator getFrameCalculator() {
        return this.frameCalculator;
    }

    public void setFrameCalculatorDisabled(boolean bl) {
        FrameCalculator.setDisabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartBeat(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        Object object = this._kbLock;
        synchronized (object) {
            Registration registration = this._sessionToRegistrationMap.get(remoteSession);
            registration.setLastHeartbeat(System.currentTimeMillis());
        }
    }

    public void cacheValuesReadFromStore(RemoteSession remoteSession, Frame frame, Slot slot, Facet facet, boolean bl, List list) {
        this.updateEvents(remoteSession);
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Cacheing read values for session " + remoteSession + " [" + this._kb + "]");
            cacheLog.fine("Read[" + frame + ", " + slot + ", " + facet + ", " + bl + " -> " + list);
        }
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Transaction Isolation Level = " + (Object)((Object)transactionIsolationLevel));
        }
        if (transactionIsolationLevel == null) {
            return;
        }
        FrameRead frameRead = new FrameRead(frame, slot, facet, bl, list);
        if (this.inTransaction() && transactionIsolationLevel.compareTo(TransactionIsolationLevel.REPEATABLE_READ) >= 0) {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Repeatable Read ==> session only");
            }
            frameRead.setClient(remoteSession);
            frameRead.setTransactionScope(true);
        }
        this._updateWriter.write(frameRead);
    }

    private void updateCacheForWriteToStore(RemoteSession remoteSession, Frame frame, Slot slot, Facet facet, boolean bl, List list) {
        this.updateEvents(remoteSession);
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Cacheing written values for session " + remoteSession + "[" + this._kb + "]");
            cacheLog.fine("Read[" + frame + ", " + slot + ", " + facet + ", " + bl + " -> " + list);
        }
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        Registration registration = this._sessionToRegistrationMap.get(remoteSession);
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Transaction Isolation Level = " + (Object)((Object)transactionIsolationLevel));
        }
        if (transactionIsolationLevel == null) {
            InvalidateCacheUpdate invalidateCacheUpdate = new InvalidateCacheUpdate(frame, slot, facet, bl);
            this._updateWriter.write(invalidateCacheUpdate);
            registration.addCommittableUpdate(invalidateCacheUpdate);
            invalidateCacheUpdate = new InvalidateCacheUpdate(frame, slot, facet, bl);
            invalidateCacheUpdate.setTransactionScope(true);
            this._updateWriter.write(invalidateCacheUpdate);
            return;
        }
        FrameWrite frameWrite = new FrameWrite(frame, slot, facet, bl, list);
        if (!TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel)) {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Update is transaction scope and specific to this client");
            }
            frameWrite.setClient(remoteSession);
            frameWrite.setTransactionScope(true);
        }
        this._updateWriter.write(frameWrite);
        if (!TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel)) {
            registration.addCommittableUpdate(new FrameWrite(frame, slot, facet, bl, list));
        }
    }

    public void invalidateCacheForWriteToStore(Frame frame, Slot slot, Facet facet, boolean bl) {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.updateEvents(remoteSession);
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Cacheing unknown values for session " + remoteSession + "[" + this._kb + "]");
            cacheLog.fine("Read[" + frame + ", " + slot + ", " + facet + ", " + bl + " -> ??");
        }
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        Registration registration = this._sessionToRegistrationMap.get(remoteSession);
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Transaction Isolation Level = " + (Object)((Object)transactionIsolationLevel));
        }
        if (transactionIsolationLevel == null) {
            this._updateWriter.write(new InvalidateCacheUpdate(frame, slot, facet, bl));
            if (this.inTransaction()) {
                registration.addCommittableUpdate(new InvalidateCacheUpdate(frame, slot, facet, bl));
            }
            InvalidateCacheUpdate invalidateCacheUpdate = new InvalidateCacheUpdate(frame, slot, facet, bl);
            invalidateCacheUpdate.setTransactionScope(true);
            this._updateWriter.write(invalidateCacheUpdate);
            return;
        }
        InvalidateCacheUpdate invalidateCacheUpdate = new InvalidateCacheUpdate(frame, slot, facet, bl);
        if (!TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel)) {
            if (cacheLog.isLoggable(Level.FINE)) {
                log.fine("Update is transaction scope and is only seen by the session");
            }
            invalidateCacheUpdate.setClient(remoteSession);
            invalidateCacheUpdate.setTransactionScope(true);
        }
        this._updateWriter.write(invalidateCacheUpdate);
        if (!TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel)) {
            registration.addCommittableUpdate(new InvalidateCacheUpdate(frame, slot, facet, bl));
        }
    }

    public void setMetaProjectInstance(ProjectInstance projectInstance) {
        this.projectInstance = projectInstance;
    }

    public ProjectInstance getMetaProjectInstance() {
        return this.projectInstance;
    }

    @Override
    public Set<Operation> getAllowedOperations(RemoteSession remoteSession) {
        Policy policy = Server.getPolicy();
        return policy.getAllowedOperations(new UserImpl(remoteSession.getUserName()), this.projectInstance);
    }

    @Override
    public Set<Operation> getKnownOperations(RemoteSession remoteSession) {
        return Server.getPolicy().getKnownOperations();
    }
}

