/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerProperties {
    public static final String SERVER_PORT = "protege.rmi.server.port";
    public static final String SERVER_LOCAL_PORT = "protege.rmi.server.local.port";
    public static final String REGISTRY_PORT = "protege.rmi.registry.port";
    public static final String REGISTRY_LOCAL_PORT = "protege.rmi.registry.local.port";
    public static final String USER_PRELOAD = "server.client.preload";
    public static final String SKIP_PRELOAD = "server.client.preload.skip";
    public static final String DELAY_MSEC = "server.delay";
    public static final String MIN_PRELOAD_FRAMES = "preload.frame.limit";
    public static final String DISABLE_HEARTBEAT = "server.disable.heartbeat";
    public static final String TX_LEVEL = "transaction.level";
    public static final String SERVER_ALLOW_CREATE_USERS = "server.allow.create.users";
    public static final String SERVER_NEW_PROJECTS_SAVE_DIRECTORY_PROTEGE_PROPERTY = "server.newproject.save.directory";

    public static boolean skipPreload() {
        return SystemUtilities.getSystemBooleanProperty(SKIP_PRELOAD, false);
    }

    public static Set<String> preloadUserFrames() {
        return ServerProperties.getStringSet(USER_PRELOAD);
    }

    private static Set<String> getStringSet(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        int n = 0;
        while (!bl) {
            String string2 = SystemUtilities.getSystemProperty(string + n);
            if (string2 == null) {
                bl = true;
            } else {
                hashSet.add(string2);
            }
            ++n;
        }
        return hashSet;
    }

    public static boolean heartbeatDisabled() {
        return true;
    }

    public static int delayInMilliseconds() {
        return SystemUtilities.getSystemIntegerProperty(DELAY_MSEC, 0);
    }

    public static int minimumPreloadedFrames() {
        return SystemUtilities.getSystemIntegerProperty(MIN_PRELOAD_FRAMES, 5000);
    }

    public static TransactionIsolationLevel getDefaultTransactionIsolationLevel() {
        String string = System.getProperty(TX_LEVEL);
        if (string == null) {
            return null;
        }
        for (TransactionIsolationLevel transactionIsolationLevel : TransactionIsolationLevel.values()) {
            if (!string.equals(transactionIsolationLevel.toString())) continue;
            return transactionIsolationLevel;
        }
        Log.getLogger().warning("transaction level " + string + " does not match any of the available levels");
        return null;
    }

    public static boolean getAllowsCreateUsers() {
        return ApplicationProperties.getBooleanProperty(SERVER_ALLOW_CREATE_USERS, false);
    }

    public static String getDefaultNewProjectSaveDirectory() {
        String string = ApplicationProperties.getApplicationDirectory().getAbsolutePath();
        return ApplicationProperties.getApplicationOrSystemProperty(SERVER_NEW_PROJECTS_SAVE_DIRECTORY_PROTEGE_PROPERTY, string);
    }
}

