/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.plugin.ProjectPluginManager;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.ProtegeRmiClassLoaderSpi;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.ServerRmiSocketFactory;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.LocalizeFrameStoreHandler;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends UnicastRemoteObject
implements RemoteServer {
    private static final long serialVersionUID = 1675054259604532947L;
    private static Server serverInstance;
    private Map<String, Project> _nameToOpenProjectMap = new HashMap<String, Project>();
    private Map<Project, ServerProject> _projectToServerProjectMap = new HashMap<Project, ServerProject>();
    private URI metaprojectURI;
    private MetaProject metaproject;
    private List<RemoteSession> _sessions = new ArrayList<RemoteSession>();
    private URI _baseURI;
    private Map<RemoteSession, Collection<ServerProject>> _sessionToProjectsMap = new HashMap<RemoteSession, Collection<ServerProject>>();
    private Thread _updateThread;
    private static final int NO_SAVE = -1;
    private int _saveIntervalMsec = -1;
    private static final String SAVE_INTERVAL_OPTION = "-saveIntervalSec=";
    private static final String NOPRELOAD_OPTION = "-nopreload";
    private static final String OPTION_CHAR = "-";
    private boolean preload = true;
    private ProjectPluginManager _projectPluginManager = new ProjectPluginManager();

    public static void main(String[] stringArray) {
        try {
            Server.startServer(stringArray);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "server startup failed", exception);
        }
    }

    public static void startServer(String[] stringArray) throws IOException {
        Server.startServer(stringArray, new ServerRmiSocketFactory());
    }

    public static void startServer(String[] stringArray, RMISocketFactory rMISocketFactory) throws IOException {
        System.setProperty("java.rmi.server.RMIClassLoaderSpi", ProtegeRmiClassLoaderSpi.class.getName());
        RMISocketFactory.setSocketFactory(rMISocketFactory);
        SystemUtilities.initialize();
        serverInstance = new Server(stringArray);
        for (Map.Entry<String, Project> entry : Server.serverInstance._nameToOpenProjectMap.entrySet()) {
            String string = entry.getKey();
            Project project = entry.getValue();
            Log.getLogger().info("Loading project plugins for project " + string);
            Server.serverInstance._projectPluginManager.afterLoad(project);
        }
        Log.getLogger().info("Protege server ready to accept connections...");
    }

    public static Server getInstance() {
        return serverInstance;
    }

    public static Policy getPolicy() {
        return Server.serverInstance.metaproject.getPolicy();
    }

    public static String getBoundName() {
        return Text.getProgramTextName();
    }

    protected static String getLocalBoundName() {
        return Server.getBoundName();
    }

    private static Registry getRegistry() throws RemoteException {
        int n = Integer.getInteger("protege.rmi.registry.port", 1099);
        return LocateRegistry.getRegistry(null, n, RMISocketFactory.getSocketFactory());
    }

    private void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseArg(stringArray[i]);
        }
    }

    protected void parseArg(String string) {
        if (string.startsWith(SAVE_INTERVAL_OPTION)) {
            this.extractSaveInterval(string);
        } else if (string.startsWith(NOPRELOAD_OPTION)) {
            this.preload = false;
        } else if (string.startsWith(OPTION_CHAR)) {
            this.printUsage();
        } else {
            this.extractMetaProjectLocation(string);
        }
    }

    private void extractSaveInterval(String string) {
        if (string.startsWith(SAVE_INTERVAL_OPTION)) {
            String string2 = string.substring(SAVE_INTERVAL_OPTION.length());
            int n = Integer.parseInt(string2);
            Log.getLogger().config("Save interval sec=" + n);
            if (n > 0) {
                this._saveIntervalMsec = n * 1000;
            }
        } else {
            this.printUsage();
        }
    }

    protected void extractMetaProjectLocation(String string) {
        this.metaprojectURI = URIUtilities.createURI(string);
    }

    protected void printUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("usage: java -cp protege.jar edu.stanford.smi.protege.server.Server [options] <metaproject>");
        stringBuffer.append("\n\tOptions:");
        stringBuffer.append("\n\t\t-saveIntervalSec=<nseconds>");
        stringBuffer.append("\n\t\t\tSave any dirty projects every n minutes (only needed for file based projects)");
        stringBuffer.append("\n\t\t-nopreload");
        stringBuffer.append("\n\t\t\tDon't preload projects.");
        System.err.println(stringBuffer.toString());
        System.exit(-1);
    }

    private Server(String[] stringArray) throws RemoteException, IOException {
        this.parseArgs(stringArray);
        this.initialize();
    }

    @Override
    public void reinitialize() throws RemoteException {
        Log.getLogger().info("Server reinitializing");
        this.clear();
        this.initialize();
    }

    private void clear() {
        this._nameToOpenProjectMap.clear();
        this._projectToServerProjectMap.clear();
        this._sessions.clear();
        this._sessionToProjectsMap.clear();
        this.stopProjectUpdateThread();
    }

    private void initialize() throws RemoteException {
        this.metaproject = new MetaProjectImpl(this.metaprojectURI);
        this.bindName();
        this.dumpProjects();
        this.startProjectUpdateThread();
    }

    private void dumpProjects() {
        for (String string : this.getAvailableProjectNames(null)) {
            if (this.preload) {
                try {
                    this.createProject(string);
                }
                catch (Exception exception) {
                    Log.getLogger().warning("Error at loading project: " + string + "Error message: " + exception.getMessage());
                }
                continue;
            }
            Log.getLogger().info("Found project " + string);
        }
    }

    protected void bindName() throws RemoteException {
        try {
            String string = Server.getLocalBoundName();
            Server.getRegistry().rebind(string, this);
            this._baseURI = new URI("rmi://" + Server.getMachineName() + "/" + string);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw new RemoteException(exception.getMessage());
        }
    }

    private static String getMachineName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            Log.getLogger().severe(Log.toString(unknownHostException));
            string = "localhost";
        }
        return string;
    }

    @Override
    public RemoteSession openSession(String string, String string2, String string3) {
        Session session = null;
        if (this.isValid(string, string3)) {
            session = new Session(string, string2);
            this._sessions.add(session);
        }
        return session;
    }

    @Override
    public RemoteSession cloneSession(RemoteSession remoteSession) {
        if (!this._sessions.contains(remoteSession)) {
            return null;
        }
        remoteSession = new Session(remoteSession.getUserName(), remoteSession.getUserIpAddress(), remoteSession.getSessionGroup());
        this._sessions.add(remoteSession);
        return remoteSession;
    }

    @Override
    public void closeSession(RemoteSession remoteSession) {
        this._sessions.remove(remoteSession);
    }

    public boolean isActive(RemoteSession remoteSession) {
        return this._sessions.contains(remoteSession);
    }

    @Override
    public RemoteServerProject openProject(String string, RemoteSession remoteSession) throws ServerSessionLost {
        if (!this._sessions.contains(remoteSession)) {
            return null;
        }
        ServerProject serverProject = null;
        Project project = this.getOrCreateProject(string);
        if (project != null) {
            serverProject = this.getServerProject(project);
            if (serverProject == null) {
                serverProject = this.createServerProject(string, project);
                this.addServerProject(project, serverProject);
            }
            if (this._sessionToProjectsMap.get(remoteSession) != null && this._sessionToProjectsMap.get(remoteSession).contains(serverProject)) {
                return null;
            }
            this.recordConnection(remoteSession, serverProject);
        }
        Log.getLogger().info("Server: Opened project " + string + " for " + remoteSession + " on " + new Date());
        return serverProject;
    }

    private void recordConnection(RemoteSession remoteSession, ServerProject serverProject) throws ServerSessionLost {
        Collection<ServerProject> collection = this._sessionToProjectsMap.get(remoteSession);
        if (collection == null) {
            collection = new ArrayList<ServerProject>();
            this._sessionToProjectsMap.put(remoteSession, collection);
        }
        collection.add(serverProject);
        serverProject.register(remoteSession);
        Log.getLogger().info("Adding session " + remoteSession);
    }

    private void recordDisconnection(RemoteSession remoteSession, RemoteServerProject remoteServerProject) throws ServerSessionLost {
        Collection<ServerProject> collection = this._sessionToProjectsMap.get(remoteSession);
        collection.remove(remoteServerProject);
        this._sessions.remove(remoteSession);
        if (remoteServerProject instanceof ServerProject) {
            ((ServerProject)remoteServerProject).deregister(remoteSession);
        }
        Log.getLogger().info("Removing session: " + remoteSession);
    }

    public ServerProject getServerProject(String string) {
        Project project = this.getProject(string);
        return project == null ? null : this.getServerProject(project);
    }

    private ServerProject createServerProject(String string, Project project) {
        ServerProject serverProject = null;
        try {
            serverProject = new ServerProject(this, this.getURI(string), this.metaproject.getProject(string), project);
        }
        catch (RemoteException remoteException) {
            Log.getLogger().severe(Log.toString(remoteException));
        }
        return serverProject;
    }

    private URI getURI(String string) {
        String string2 = FileUtilities.urlEncode(string);
        return this._baseURI.resolve(string2);
    }

    public void disconnectFromProject(RemoteServerProject remoteServerProject, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordDisconnection(remoteSession, remoteServerProject);
    }

    public ServerProject getServerProject(Project project) {
        return this._projectToServerProjectMap.get(project);
    }

    private void addServerProject(Project project, ServerProject serverProject) {
        this._projectToServerProjectMap.put(project, serverProject);
    }

    public Project getProject(String string) {
        return this._nameToOpenProjectMap.get(string);
    }

    private Project getOrCreateProject(String string) {
        Project project = this.getProject(string);
        if (project == null) {
            project = this.createProject(string);
        }
        return project;
    }

    private Project createProject(String string) {
        Project project = null;
        for (ProjectInstance projectInstance : this.metaproject.getProjects()) {
            String string2 = projectInstance.getName();
            if (!string2.equals(string)) continue;
            String string3 = projectInstance.getLocation();
            URI uRI = URIUtilities.createURI(string3);
            Log.getLogger().info("Loading project " + string + " from " + uRI);
            project = Project.loadProjectFromURI(uRI, new ArrayList(), true);
            if (serverInstance != null) {
                this._projectPluginManager.afterLoad(project);
            }
            Server.localizeProject(project);
            this._nameToOpenProjectMap.put(string, project);
            break;
        }
        return project;
    }

    @Override
    public RemoteServerProject createProject(String string, RemoteSession remoteSession, KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) throws RemoteException {
        Object object;
        Project project = null;
        for (ProjectInstance object22 : this.metaproject.getProjects()) {
            object = object22.getName();
            if (!((String)object).equals(string)) continue;
            Log.getLogger().warning("Server: Attempting to create server project with existing project name. No server project created.");
            return null;
        }
        String string2 = ServerProperties.getDefaultNewProjectSaveDirectory();
        URI uRI = URIUtilities.createURI((String)string2 + File.separator + string + ".pprj");
        if (uRI == null) {
            Log.getLogger().warning("Could not create new server project at location " + (String)string2 + File.separator + string + ".pprj");
            return null;
        }
        object = new ArrayList();
        project = Project.createNewProject(knowledgeBaseFactory, (Collection)object);
        Log.getLogger().info("Server: Created server project at: " + uRI);
        if (((ArrayList)object).size() > 0) {
            Log.getLogger().warning("Server: Errors at creating new project " + string);
            return null;
        }
        project.setProjectURI(uRI);
        if (knowledgeBaseFactory instanceof ClipsKnowledgeBaseFactory) {
            ClipsKnowledgeBaseFactory.setSourceFiles(project.getSources(), string + ".pont", string + ".pins");
        }
        project.save((Collection)object);
        if (((ArrayList)object).size() > 0) {
            Log.getLogger().warning("Server: Errors at saving new project " + string);
            return null;
        }
        project = Project.loadProjectFromURI(uRI, new ArrayList(), true);
        if (serverInstance != null) {
            this._projectPluginManager.afterLoad(project);
        }
        Server.localizeProject(project);
        this._nameToOpenProjectMap.put(string, project);
        if (bl) {
            ProjectInstance projectInstance = this.metaproject.createProject(string);
            projectInstance.setLocation((String)string2 + File.separator + string + ".pprj");
            this.metaproject.save((Collection)object);
        }
        return this.getServerProject(project);
    }

    private static void localizeProject(Project project) {
        Server.localizeKB(project.getKnowledgeBase());
        Server.localizeKB(project.getInternalProjectKnowledgeBase());
    }

    private static void localizeKB(KnowledgeBase knowledgeBase) {
        FrameStore frameStore = new LocalizeFrameStoreHandler(knowledgeBase).newFrameStore();
        knowledgeBase.insertFrameStore(frameStore);
    }

    @Override
    public Collection<String> getAvailableProjectNames(RemoteSession remoteSession) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ProjectInstance projectInstance : this.metaproject.getProjects()) {
            Object object;
            String string = projectInstance.getLocation();
            URI uRI = URIUtilities.createURI(string);
            String string2 = uRI.getScheme();
            if (string2 != null && string2.contains("http")) {
                object = URIUtilities.createBufferedReader(uRI);
                if (object != null) {
                    arrayList.add(projectInstance.getName());
                    FileUtilities.close((Reader)object);
                    continue;
                }
                Log.getLogger().warning("Missing project at " + string);
                continue;
            }
            object = new File(string);
            if (((File)object).exists() && ((File)object).isFile()) {
                arrayList.add(projectInstance.getName());
                continue;
            }
            Log.getLogger().warning("Missing project at " + string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public Collection<ServerProject> getCurrentProjects(RemoteSession remoteSession) {
        return this._sessionToProjectsMap.get(remoteSession);
    }

    public Collection<RemoteSession> getCurrentSessions() {
        return this._sessions;
    }

    @Override
    public Collection<RemoteSession> getCurrentSessions(String string, RemoteSession remoteSession) {
        ServerProject serverProject = this.getServerProject(string);
        Collection<Object> collection = serverProject == null ? Collections.EMPTY_LIST : this.getCurrentSessions(serverProject);
        return collection;
    }

    public Collection<RemoteSession> getCurrentSessions(RemoteServerProject remoteServerProject) {
        ArrayList<RemoteSession> arrayList = new ArrayList<RemoteSession>();
        for (Map.Entry<RemoteSession, Collection<ServerProject>> entry : this._sessionToProjectsMap.entrySet()) {
            Session session;
            Collection<ServerProject> collection = entry.getValue();
            if (!collection.contains(remoteServerProject) || !Server.isCurrent(session = (Session)entry.getKey())) continue;
            arrayList.add(session);
        }
        return arrayList;
    }

    private static boolean isCurrent(Session session) {
        return true;
    }

    @Override
    public boolean allowsCreateUsers() throws RemoteException {
        return ServerProperties.getAllowsCreateUsers();
    }

    @Override
    public boolean createUser(String string, String string2) {
        ArrayList arrayList2 = new ArrayList();
        for (User arrayList3 : this.metaproject.getUsers()) {
            String bl = arrayList3.getName();
            if (!bl.equals(string)) continue;
            Log.getLogger().warning("Server: Could not create user with name " + string + ". User name already exists.");
            return false;
        }
        User user = this.metaproject.createUser(string, string2);
        ArrayList arrayList = new ArrayList();
        boolean bl = this.metaproject.save(arrayList);
        return bl && arrayList.size() == 0;
    }

    private boolean isValid(String string, String string2) {
        boolean bl = false;
        for (User user : this.metaproject.getUsers()) {
            String string3;
            String string4 = user.getName();
            if (!string4.equals(string) || !(string3 = user.getPassword()).equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public String toString() {
        return "Server";
    }

    private void startProjectUpdateThread() {
        if (this._saveIntervalMsec != -1) {
            this._updateThread = new Thread("Save Projects"){

                public void run() {
                    try {
                        while (Server.this._updateThread == this) {
                            1.sleep(Server.this._saveIntervalMsec);
                            Server.this.saveAllProjects();
                        }
                    }
                    catch (Throwable throwable) {
                        Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                    }
                }
            };
            this._updateThread.setDaemon(true);
            this._updateThread.start();
        }
    }

    private void saveAllProjects() {
        for (Map.Entry<Project, ServerProject> entry : this._projectToServerProjectMap.entrySet()) {
            Project project = entry.getKey();
            ServerProject serverProject = entry.getValue();
            if (!serverProject.isDirty()) continue;
            Server.save(serverProject, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(ServerProject serverProject, Project project) {
        Log.getLogger().info("Saving " + project);
        ArrayList arrayList = new ArrayList();
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        synchronized (knowledgeBase) {
            KnowledgeBase knowledgeBase2 = project.getInternalProjectKnowledgeBase();
            synchronized (knowledgeBase2) {
                KnowledgeBase knowledgeBase3 = project.getKnowledgeBase();
                KnowledgeBaseFactory knowledgeBaseFactory = knowledgeBase3.getKnowledgeBaseFactory();
                knowledgeBaseFactory.saveKnowledgeBase(knowledgeBase3, project.getSources(), arrayList);
                Server.serverInstance._projectPluginManager.afterSave(project);
            }
        }
        serverProject.setClean();
        Server.dumpErrors(project, arrayList);
    }

    private static void dumpErrors(Project project, Collection collection) {
        if (!collection.isEmpty()) {
            Log.getLogger().warning("Unable to save project " + project);
            for (Object e : collection) {
                Log.getLogger().warning("\t" + e.toString());
            }
        }
    }

    @Override
    public void shutdown() {
        Log.getLogger().info("Received shutdown request.");
        this.saveAllProjects();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    SystemUtilities.sleepMsec(100);
                    Log.getLogger().info("Server exiting.");
                    Iterator iterator = Server.this._projectToServerProjectMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        Project project = (Project)iterator.next();
                        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
                        synchronized (knowledgeBase) {
                            KnowledgeBase knowledgeBase2 = project.getInternalProjectKnowledgeBase();
                            synchronized (knowledgeBase2) {
                                try {
                                    Server.this._projectPluginManager.beforeClose(project);
                                }
                                catch (Exception exception) {
                                    Log.getLogger().log(Level.INFO, "Exception caught cleaning up", exception);
                                }
                            }
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.INFO, "Exception caught", exception);
                    return;
                }
                finally {
                    System.exit(0);
                }
            }
        };
        thread.start();
    }

    private void stopProjectUpdateThread() {
        this._updateThread = null;
    }

    public void setFrameCalculatorDisabled(boolean bl) {
        for (ServerProject serverProject : this._projectToServerProjectMap.values()) {
            serverProject.setFrameCalculatorDisabled(bl);
        }
    }

    public KnowledgeBase getMetaProject() {
        return this.metaproject.getKnowledgeBase();
    }

    public Cls getProjectCls() {
        return this.metaproject.getCls(MetaProject.ClsEnum.Project);
    }

    public Slot getNameSlot() {
        return this.metaproject.getSlot(MetaProject.SlotEnum.name);
    }
}

