/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.resource;

import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.DirectoryClassLoader;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.io.File;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundleHelper {
    private ResourceBundle resourceBundle;
    private static boolean colorLookup;

    public BundleHelper(String string, Class clazz) {
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            classLoader = BundleHelper.fixLoader(classLoader);
            Locale locale = Locale.getDefault();
            this.resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            Log.getLogger().warning("missing bundle: " + string);
        }
    }

    private static ClassLoader fixLoader(ClassLoader classLoader) {
        File file;
        if (classLoader == BundleHelper.class.getClassLoader() && (file = ApplicationProperties.getApplicationDirectory()) != null) {
            classLoader = new DirectoryClassLoader(file, classLoader);
        }
        return classLoader;
    }

    public boolean hasText(ResourceKey resourceKey) {
        return this.internalGetText(resourceKey) != null;
    }

    public String getText(ResourceKey resourceKey) {
        String string = this.internalGetText(resourceKey);
        if (colorLookup) {
            string = string == null ? "<html><font color=ff0000>" + resourceKey + "</font></html>" : "<html><font color=0000ff>" + string + "</font></html>";
        }
        return string == null ? resourceKey.toString() : string;
    }

    private String internalGetText(ResourceKey resourceKey) {
        String string;
        if (this.resourceBundle == null) {
            Log.getLogger().warning("no resource bundle: " + resourceKey);
            string = "Missing resource bundle for " + resourceKey;
        } else {
            try {
                string = this.resourceBundle.getString(resourceKey.toString());
            }
            catch (MissingResourceException missingResourceException) {
                string = null;
            }
        }
        return string;
    }

    public String getText(ResourceKey resourceKey, String string) {
        String string2 = this.getText(resourceKey);
        string2 = StringUtilities.replace(string2, "{0}", string);
        return string2;
    }

    public String getText(ResourceKey resourceKey, String string, String string2) {
        String string3 = this.getText(resourceKey, string);
        string3 = StringUtilities.replace(string3, "{1}", string2);
        return string3;
    }

    public int getChar(ResourceKey resourceKey) {
        String string = this.internalGetText(resourceKey);
        return string == null || string.length() == 0 ? 0 : (int)string.charAt(0);
    }

    public boolean isValid() {
        return this.resourceBundle != null;
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    static {
        try {
            colorLookup = Boolean.getBoolean("protege.text.colorlookup");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

