/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.plugin.CreateProjectFromFilePlugin;
import edu.stanford.smi.protege.plugin.CreateProjectPlugin;
import edu.stanford.smi.protege.plugin.DefaultEntry;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.plugin.ExportProjectPlugin;
import edu.stanford.smi.protege.plugin.ImportPlugin;
import edu.stanford.smi.protege.plugin.ProjectPlugin;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.DirectoryClassLoader;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MultiplexingClassLoader;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.TabWidget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtilities {
    private static Logger log = Log.getLogger(PluginUtilities.class);
    private static final String TAB_WIDGET = "Tab-Widget";
    private static final String SLOT_WIDGET = "Slot-Widget";
    private static final String CLS_WIDGET = "Cls-Widget";
    private static final String IMPORT_PLUGIN = "Import-Plugin";
    private static final String CREATE_PROJECT_PLUGIN = "Create-Project-Plugin";
    private static final String EXPORT_PLUGIN = "Export-Plugin";
    private static final String EXPORT_PROJECT_PLUGIN = "Export-Project-Plugin";
    private static final String PROJECT_PLUGIN = "Project-Plugin";
    private static final String FACTORY_PLUGIN = "Storage-Factory";
    private static Collection<URL> _manifestURLs = new HashSet<URL>();
    private static Map pluginToNameMap = new HashMap();
    private static Map _pluginClassNameToClassLoaderMap = new HashMap();
    private static List _factories;
    private static Map _defaultSlotWidgetNames;
    private static Set _pluginComponentNames;
    private static Map _pluginComponentNameToAboutURLMap;
    private static Map _pluginComponentNameToDocURLMap;
    private static Map _pluginPackageToClassLoaderMap;
    private static String defaultFactoryClassName;
    private static Map<String, Collection<Class>> cachedClsesWithAttributeMap;
    private static File pluginsDir;
    private static final String PROPERTIES_FILE_NAME = "plugin.properties";
    private static final String PLUGIN_COUNT_PROPERTY = "plugin.component.count";
    private static final String PLUGIN_NAME_PROPERTY = "plugin.component.name";
    private static final String ABOUT_PROPERTY = "plugin.component.about";
    private static final String DOC_PROPERTY = "plugin.component.doc";
    private static final String DEPENDENCY_COUNT_PROPERTY = "plugin.dependency.count";
    private static final String DEPENDENCY_PROPERTY = "plugin.dependency";
    public static final String EXTRA_MANIFEST_PATH = "protege.plugin.manifest";
    private static Boolean isOWLAvailable;
    private static FilenameFilter _pluginPackageFilter;
    private static final char STANDARD_SEPARATOR_CHAR = '/';
    private static final String CREATE_PROJECT_FROM_FILE_PLUGIN = "Create-Project-From-File-Plugin";

    public static File getInstallationDirectory(String string) {
        File file = null;
        ClassLoader classLoader = (ClassLoader)_pluginClassNameToClassLoaderMap.get(string);
        if (classLoader instanceof DirectoryClassLoader) {
            file = ((DirectoryClassLoader)classLoader).getDirectory();
        }
        return file;
    }

    public static void initialize() {
    }

    private static String attributeNameToClassName(String string) {
        String string2 = string.endsWith(".class") ? string.substring(0, string.length() - 6) : string;
        string2 = string2.replace('/', '.');
        return string2;
    }

    private static ClassLoader createClassLoader(File file, ClassLoader classLoader) {
        return file == null ? classLoader : new DirectoryClassLoader(file, classLoader);
    }

    public static Class forName(String string) {
        return PluginUtilities.forName(string, false);
    }

    public static Class forName(String string, boolean bl) {
        Class clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader2 = PluginUtilities.getClassLoader(string);
            PluginUtilities.setContextClassLoader(classLoader2);
            clazz = Class.forName(string, true, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Standard Exception Ignored", classNotFoundException);
                log.finest("Promiscuous = " + bl);
            }
            if (bl) {
                clazz = PluginUtilities.promiscuousForName(string);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Promiscuous found = " + clazz);
                }
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().warning(throwable.getMessage());
        }
        PluginUtilities.setContextClassLoader(classLoader);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Class loader found " + clazz);
        }
        return clazz;
    }

    private static Class promiscuousForName(String string) {
        Class<?> clazz = null;
        Iterator iterator = PluginUtilities.getClassLoaders().iterator();
        while (iterator.hasNext() && clazz == null) {
            ClassLoader classLoader = (ClassLoader)iterator.next();
            PluginUtilities.setContextClassLoader(classLoader);
            try {
                clazz = Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Standard Exception Ignored by loader " + classLoader, classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Standard Exception Ignored by loader" + classLoader, noClassDefFoundError);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Promiscuous mode returned class = " + clazz);
        }
        return clazz;
    }

    private static Collection getClassLoaders() {
        return new HashSet(_pluginClassNameToClassLoaderMap.values());
    }

    private static ClassLoader getClassLoader(String string) {
        ClassLoader classLoader = (ClassLoader)_pluginClassNameToClassLoaderMap.get(string);
        if (classLoader == null) {
            classLoader = PluginUtilities.class.getClassLoader();
        }
        return classLoader;
    }

    public static Collection getAvailableFactories() {
        if (_factories == null) {
            _factories = new ArrayList();
            for (String string : PluginUtilities.getAvailableFactoryClassNames()) {
                if (string.equals(defaultFactoryClassName)) {
                    _factories.add(0, SystemUtilities.newInstance(string));
                    continue;
                }
                _factories.add(SystemUtilities.newInstance(string));
            }
        }
        return Collections.unmodifiableCollection(_factories);
    }

    private static Collection getPluginNames(String string) {
        Collection collection = (Collection)pluginToNameMap.get(string);
        return collection == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(collection);
    }

    public static Collection getAvailableFactoryClassNames() {
        return PluginUtilities.getPluginNames(FACTORY_PLUGIN);
    }

    public static Collection getAvailableSlotWidgetClassNames() {
        return PluginUtilities.getPluginNames(SLOT_WIDGET);
    }

    public static Collection getAvailableTabWidgetClassNames() {
        return PluginUtilities.getPluginNames(TAB_WIDGET);
    }

    public static Collection getAvailableImportPluginClassNames() {
        return PluginUtilities.getPluginNames(IMPORT_PLUGIN);
    }

    public static Collection getAvailableCreateProjectPluginClassNames() {
        return PluginUtilities.getPluginNames(CREATE_PROJECT_PLUGIN);
    }

    public static Collection getAvailableExportProjectPluginClassNames() {
        return PluginUtilities.getPluginNames(EXPORT_PROJECT_PLUGIN);
    }

    public static Collection getAvailableExportPluginClassNames() {
        return PluginUtilities.getPluginNames(EXPORT_PLUGIN);
    }

    public static Collection getAvailableProjectPluginClassNames() {
        return PluginUtilities.getPluginNames(PROJECT_PLUGIN);
    }

    public static Collection getPluginComponentNames() {
        ArrayList arrayList = new ArrayList(_pluginComponentNames);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static URL getPluginComponentAboutURL(String string) {
        return (URL)_pluginComponentNameToAboutURLMap.get(string);
    }

    public static URL getPluginComponentDocURL(String string) {
        return (URL)_pluginComponentNameToDocURLMap.get(string);
    }

    public static String getDefaultWidgetClassName(Slot slot) {
        DefaultEntry defaultEntry = new DefaultEntry(slot);
        return (String)_defaultSlotWidgetNames.get(defaultEntry);
    }

    public static String getDefaultWidgetClassName(boolean bl, ValueType valueType, Cls cls) {
        DefaultEntry defaultEntry = new DefaultEntry(bl, valueType, cls);
        String string = (String)_defaultSlotWidgetNames.get(defaultEntry);
        if (string == null && valueType.equals(ValueType.INSTANCE) && cls != null) {
            defaultEntry = new DefaultEntry(bl, valueType, null);
            string = (String)_defaultSlotWidgetNames.get(defaultEntry);
        }
        return string;
    }

    public static String getDefaultWidgetClassName(boolean bl, ValueType valueType, Cls cls, Slot slot) {
        String string = null;
        if (slot != null) {
            string = PluginUtilities.getDefaultWidgetClassName(slot);
        }
        if (string == null) {
            string = PluginUtilities.getDefaultWidgetClassName(bl, valueType, cls);
        }
        return string;
    }

    public static boolean isLoadableClass(String string) {
        return PluginUtilities.forName(string) != null;
    }

    private static boolean isLoadableClass(String string, ClassLoader classLoader, Class clazz) {
        boolean bl = false;
        try {
            Class<?> clazz2;
            if (classLoader == null) {
                classLoader = SystemUtilities.class.getClassLoader();
            }
            if ((clazz2 = Class.forName(string, true, classLoader)) != null && !(bl = clazz.isAssignableFrom(clazz2))) {
                Log.getLogger().warning(string + " does not implement " + clazz);
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().warning(throwable.toString());
        }
        return bl;
    }

    private static boolean isSet(Attributes attributes, String string) {
        boolean bl = false;
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            string2 = string2.trim();
            bl = string2.equalsIgnoreCase("true");
        }
        return bl;
    }

    private static void loadPluginsWithClassLoader(File file, ClassLoader classLoader) {
        Object object;
        PluginUtilities.logClassLoaderInformation(file, classLoader);
        Collection collection = PluginUtilities.getNewManifests(classLoader);
        if (file == null && (object = PluginUtilities.loadExtraManifest()) != null) {
            collection.add(object);
        }
        for (Manifest manifest : collection) {
            PluginUtilities.processManifest(manifest, classLoader);
        }
    }

    private static Collection getNewManifests(ClassLoader classLoader) {
        ArrayList arrayList = new ArrayList();
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                PluginUtilities.addNew(uRL, arrayList);
            }
        }
        catch (IOException iOException) {
            Log.getLogger().severe(Log.toString(iOException));
        }
        return arrayList;
    }

    private static void addNew(URL uRL, Collection collection) throws IOException {
        if (uRL != null && _manifestURLs.add(uRL)) {
            collection.add(new Manifest(uRL.openStream()));
        }
    }

    private static void logClassLoaderInformation(File file, ClassLoader classLoader) {
        if (file != null && !file.equals(pluginsDir)) {
            String string = "Loaded plugin " + file.getName() + PluginUtilities.getPluginsString(file);
            Log.getLogger().config(string);
        }
    }

    public static void processManifest(Manifest manifest, ClassLoader classLoader) {
        for (String string : manifest.getEntries().keySet()) {
            Attributes attributes = manifest.getAttributes(string);
            String string2 = PluginUtilities.attributeNameToClassName(string);
            PluginUtilities.checkPlugins(classLoader, attributes, string2);
        }
    }

    private static void checkPlugins(ClassLoader classLoader, Attributes attributes, String string) {
        PluginUtilities.checkPlugin(classLoader, attributes, string, TAB_WIDGET, TabWidget.class);
        PluginUtilities.checkPlugin(classLoader, attributes, string, CLS_WIDGET, ClsWidget.class);
        boolean bl = PluginUtilities.checkPlugin(classLoader, attributes, string, FACTORY_PLUGIN, KnowledgeBaseFactory.class);
        if (bl) {
            PluginUtilities.recordFactoryDefault(string, attributes);
        }
        PluginUtilities.checkPlugin(classLoader, attributes, string, IMPORT_PLUGIN, ImportPlugin.class);
        PluginUtilities.checkPlugin(classLoader, attributes, string, CREATE_PROJECT_PLUGIN, CreateProjectPlugin.class);
        PluginUtilities.checkPlugin(classLoader, attributes, string, EXPORT_PLUGIN, ExportPlugin.class);
        PluginUtilities.checkPlugin(classLoader, attributes, string, EXPORT_PROJECT_PLUGIN, ExportProjectPlugin.class);
        PluginUtilities.checkPlugin(classLoader, attributes, string, PROJECT_PLUGIN, ProjectPlugin.class);
        bl = PluginUtilities.checkPlugin(classLoader, attributes, string, SLOT_WIDGET, SlotWidget.class);
        if (bl) {
            PluginUtilities.recordSlotWidgetDefaults(string, attributes);
        }
    }

    private static Collection getOrCreatePluginNames(String string) {
        ArrayList arrayList = (ArrayList)pluginToNameMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            pluginToNameMap.put(string, arrayList);
        }
        return arrayList;
    }

    private static boolean checkPlugin(ClassLoader classLoader, Attributes attributes, String string, String string2, Class clazz) {
        boolean bl = false;
        if (PluginUtilities.isSet(attributes, string2) && PluginUtilities.isLoadableClass(string, classLoader, clazz)) {
            Collection collection = PluginUtilities.getOrCreatePluginNames(string2);
            collection.add(string);
            bl = true;
            ClassLoader classLoader2 = _pluginClassNameToClassLoaderMap.put(string, classLoader);
            if (classLoader2 != null && classLoader2 != classLoader) {
                Log.getLogger().warning("Duplicate plugin: " + string);
            }
        }
        return bl;
    }

    private static void recordFactoryDefault(String string, Attributes attributes) {
        if (PluginUtilities.isSet(attributes, "Default-Factory")) {
            defaultFactoryClassName = string;
        }
    }

    private static void recordSlotWidgetDefaults(String string, Attributes attributes) {
        if (PluginUtilities.isSet(attributes, "Default-Widget")) {
            String string2 = attributes.getValue("Default-Widget-For-Cardinality");
            String string3 = attributes.getValue("Default-Widget-For-Type");
            String string4 = attributes.getValue("Default-Widget-For-Allowed-Class");
            String string5 = attributes.getValue("Default-Widget-For-Slot");
            DefaultEntry defaultEntry = new DefaultEntry(string2, string3, string4, string5);
            _defaultSlotWidgetNames.put(defaultEntry, string);
        }
    }

    public static void findPluginsDirectory() {
        File file = ApplicationProperties.getApplicationDirectory();
        if (file == null) {
            Log.getLogger().warning("Application directory not specified");
        } else {
            File file2 = new File(file, "plugins");
            if (file2.exists()) {
                pluginsDir = file2;
            } else {
                Log.getLogger().warning("Plugins directory not found: " + file2);
            }
        }
    }

    private static void init() {
        try {
            PluginUtilities.loadPlugins();
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
    }

    private static void setContextClassLoader(ClassLoader classLoader) {
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void loadPlugins() {
        PluginUtilities.findPluginsDirectory();
        PluginUtilities.loadSystemPlugins();
        if (pluginsDir != null) {
            PluginUtilities.loadLegacyPlugins();
            PluginUtilities.loadPluginPackages();
        }
    }

    private static void loadSystemPlugins() {
        PluginUtilities.loadPlugins(null);
    }

    private static void loadPlugins(File file) {
        PluginUtilities.createClassLoaderAndLoadPlugins(file, PluginUtilities.class.getClassLoader());
    }

    private static void createClassLoaderAndLoadPlugins(File file, ClassLoader classLoader) {
        ClassLoader classLoader2 = PluginUtilities.createClassLoader(file, classLoader);
        _pluginPackageToClassLoaderMap.put(file, classLoader2);
        PluginUtilities.loadPluginsWithClassLoader(file, classLoader2);
    }

    private static void loadLegacyPlugins() {
        PluginUtilities.loadPlugins(pluginsDir);
    }

    private static ClassLoader getParentLoader(File file) {
        ClassLoader classLoader;
        Collection collection = PluginUtilities.getDependentLoaders(file);
        int n = collection.size();
        switch (n) {
            case 0: {
                classLoader = PluginUtilities.class.getClassLoader();
                break;
            }
            case 1: {
                classLoader = (ClassLoader)CollectionUtilities.getFirstItem(collection);
                break;
            }
            default: {
                classLoader = new MultiplexingClassLoader(collection);
            }
        }
        return classLoader;
    }

    private static Collection getDependentLoaders(File file) {
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        Properties properties = PluginUtilities.getProperties(file);
        int n = PluginUtilities.getInt(properties, DEPENDENCY_COUNT_PROPERTY);
        for (int i = 0; i < n; ++i) {
            ClassLoader classLoader;
            File file2 = PluginUtilities.getDependentPackage(properties, i);
            if (file2 == null || (classLoader = PluginUtilities.getClassLoaderForPackage(file2)) == null) continue;
            arrayList.add(classLoader);
        }
        return arrayList;
    }

    private static ClassLoader getClassLoaderForPackage(File file) {
        ClassLoader classLoader = (ClassLoader)_pluginPackageToClassLoaderMap.get(file);
        if (classLoader == null) {
            PluginUtilities.loadPluginPackage(file);
            classLoader = (ClassLoader)_pluginPackageToClassLoaderMap.get(file);
        }
        return classLoader;
    }

    private static File getDependentPackage(Properties properties, int n) {
        File file;
        File file2 = null;
        String string = properties.getProperty("plugin.dependency." + n);
        if (string != null && (file = new File(pluginsDir, string)).isDirectory()) {
            file2 = file;
        }
        return file2;
    }

    private static void loadPluginPackages() {
        File[] fileArray = pluginsDir.listFiles(_pluginPackageFilter);
        Collection collection = PluginUtilities.orderPackages(fileArray);
        for (File file : collection) {
            if (PluginUtilities.isLoaded(file)) continue;
            PluginUtilities.loadPluginPackage(file);
        }
    }

    private static boolean isLoaded(File file) {
        return _pluginPackageToClassLoaderMap.get(file) != null;
    }

    private static Collection orderPackages(File[] fileArray) {
        return Arrays.asList(fileArray);
    }

    private static void loadPluginPackage(File file) {
        PluginUtilities.createClassLoaderAndLoadPlugins(file, PluginUtilities.getParentLoader(file));
        PluginUtilities.loadURLs(file);
    }

    private static Manifest loadExtraManifest() {
        Manifest manifest = null;
        String string = ApplicationProperties.getExtraManifestPath();
        if (string != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                manifest = new Manifest(fileInputStream);
                URL uRL = new File(string).toURL();
                _manifestURLs.add(uRL);
            }
            catch (IOException iOException) {
                Log.getLogger().warning(iOException.getMessage());
            }
        }
        return manifest;
    }

    private static int getInt(Properties properties, String string) {
        String string2;
        int n = 0;
        if (properties != null && (string2 = properties.getProperty(string)) != null) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    private static String getPluginName(Properties properties, int n, File file) {
        String string = "plugin.component.name." + n;
        return properties.getProperty(string, file.getName());
    }

    private static void loadURL(String string, Properties properties, String string2, int n, File file, Map map) {
        String string3 = string2 + "." + n;
        String string4 = properties.getProperty(string3);
        if (string4 != null) {
            URL uRL = PluginUtilities.getURL(file, string4);
            if (uRL == null) {
                Log.getLogger().warning("missing file: " + string4);
            } else {
                map.put(string, uRL);
            }
        }
    }

    private static String localizePath(String string) {
        char c = File.separatorChar;
        if (c != '/') {
            string = string.replace('/', c);
        }
        return string;
    }

    private static URL getURL(File file, String string) {
        URL uRL = null;
        URI uRI = PluginUtilities.getAbsoluteURI(string);
        if (uRI == null) {
            uRI = PluginUtilities.getAbsoluteURI(file, string);
        }
        if (uRI != null) {
            try {
                uRL = uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    private static URI getAbsoluteURI(File file, String string) {
        URI uRI = null;
        File file2 = new File(file, string = PluginUtilities.localizePath(string));
        if (file2.exists()) {
            uRI = file2.toURI();
        }
        return uRI;
    }

    private static URI getAbsoluteURI(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string);
            if (!uRI.isAbsolute()) {
                uRI = null;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uRI;
    }

    private static Properties getProperties(File file) {
        Properties properties = null;
        File file2 = new File(file, PROPERTIES_FILE_NAME);
        if (file2.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                properties = new Properties();
                properties.load(fileInputStream);
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                Log.getLogger().warning(iOException.toString());
            }
        }
        return properties;
    }

    private static void loadURLs(File file) {
        Properties properties = PluginUtilities.getProperties(file);
        if (properties != null) {
            int n = PluginUtilities.getInt(properties, PLUGIN_COUNT_PROPERTY);
            for (int i = 0; i < n; ++i) {
                String string = PluginUtilities.getPluginName(properties, i, file);
                _pluginComponentNames.add(string);
                PluginUtilities.loadURL(string, properties, ABOUT_PROPERTY, i, file, _pluginComponentNameToAboutURLMap);
                PluginUtilities.loadURL(string, properties, DOC_PROPERTY, i, file, _pluginComponentNameToDocURLMap);
            }
        }
    }

    private static String getPluginsString(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = PluginUtilities.getProperties(file);
        if (properties != null) {
            int n = PluginUtilities.getInt(properties, PLUGIN_COUNT_PROPERTY);
            for (int i = 0; i < n; ++i) {
                String string = PluginUtilities.getPluginName(properties, i, file);
                stringBuffer.append(i == 0 ? " - " : ", ");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static Collection<Class> getClassesWithAttribute(String string, String string2) {
        Collection<Class> collection = PluginUtilities.getCachedClsesWithAttribute(string, string2);
        if (collection == null) {
            collection = new HashSet<Class>();
            for (URL uRL : _manifestURLs) {
                try {
                    Manifest manifest = new Manifest(uRL.openStream());
                    collection.addAll(PluginUtilities.getManifestClasses(manifest, string, string2));
                }
                catch (IOException iOException) {
                    Log.getLogger().warning(iOException.getMessage());
                }
            }
            PluginUtilities.saveCachedClsesWithAttribute(string, string2, collection);
        }
        return new ArrayList<Class>(collection);
    }

    private static Collection<Class> getCachedClsesWithAttribute(String string, String string2) {
        return cachedClsesWithAttributeMap.get(PluginUtilities.getKey(string, string2));
    }

    private static String getKey(String string, String string2) {
        return string + "=" + string2;
    }

    private static void saveCachedClsesWithAttribute(String string, String string2, Collection collection) {
        cachedClsesWithAttributeMap.put(PluginUtilities.getKey(string, string2), collection);
    }

    private static Collection<Class> getManifestClasses(Manifest manifest, String string, String string2) {
        HashSet<Class> hashSet = new HashSet<Class>();
        for (String string3 : manifest.getEntries().keySet()) {
            String string4;
            Class clazz;
            Attributes attributes = manifest.getAttributes(string3);
            String string5 = attributes.getValue(string);
            if (!PluginUtilities.equalsAttributes(string5, string2) || (clazz = PluginUtilities.forName(string4 = PluginUtilities.attributeNameToClassName(string3), true)) == null) continue;
            hashSet.add(clazz);
        }
        return hashSet;
    }

    private static boolean equalsAttributes(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static File getPluginsDirectory() {
        return pluginsDir;
    }

    public static boolean isOWL(KnowledgeBase knowledgeBase) {
        return knowledgeBase.getClass().getName().indexOf("OWL") != -1;
    }

    public static boolean isOWLAvailable() {
        if (isOWLAvailable == null) {
            Class clazz = PluginUtilities.promiscuousForName("edu.stanford.smi.protegex.owl.model.OWLClass");
            isOWLAvailable = clazz != null;
        }
        return isOWLAvailable;
    }

    public static Collection getAvailableCreateProjectFromFilePluginClassNames() {
        return PluginUtilities.getClassesWithAttribute(CREATE_PROJECT_FROM_FILE_PLUGIN, "True");
    }

    public static boolean isSuitableCreateProjectFromFilePlugin(CreateProjectFromFilePlugin createProjectFromFilePlugin, String string) {
        String[] stringArray = createProjectFromFilePlugin.getSuffixes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPluginAvailable(String string) {
        boolean bl = false;
        try {
            Class clazz = PluginUtilities.forName(string, true);
            bl = clazz != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    static {
        _defaultSlotWidgetNames = new HashMap();
        _pluginComponentNames = new HashSet();
        _pluginComponentNameToAboutURLMap = new HashMap();
        _pluginComponentNameToDocURLMap = new HashMap();
        _pluginPackageToClassLoaderMap = new HashMap();
        cachedClsesWithAttributeMap = new HashMap<String, Collection<Class>>();
        isOWLAvailable = null;
        _pluginPackageFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return new File(file, string).isDirectory() && !string.equalsIgnoreCase("meta-inf") && !string.startsWith(".");
            }
        };
        PluginUtilities.init();
    }
}

