/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.SimpleCommand;
import java.util.ArrayList;
import java.util.Collection;

class DeleteSlotCommand
extends SimpleCommand {
    private Slot slot;
    private String name;
    private FrameID id;
    private Collection directTypes;
    private Collection directSuperslots;

    DeleteSlotCommand(FrameStore frameStore, Slot slot) {
        super(frameStore);
        this.slot = slot;
        this.name = slot.getName();
        this.id = slot.getFrameID();
        this.directTypes = new ArrayList(slot.getDirectTypes());
        this.directSuperslots = new ArrayList(slot.getDirectSuperslots());
        this.setDescription("Delete slot " + DeleteSlotCommand.getText(slot));
    }

    public Object doIt() {
        this.getDelegate().deleteSlot(this.slot);
        this.slot.markDeleted(true);
        return null;
    }

    public void undoIt() {
        this.getDelegate().createSlot(this.id, this.name, this.directTypes, this.directSuperslots, false);
        this.slot.markDeleted(false);
    }
}

