/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ClosureUtils;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Record;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryFrameDb
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(InMemoryFrameDb.class);
    private static final int INITIAL_MAP_SIZE = 32771;
    private Map<FrameID, Frame> idToFrameMap = new HashMap<FrameID, Frame>(32771);
    private Map<Record, Record> referenceToRecordMap = new HashMap<Record, Record>(32771);
    private Map<Frame, Set<Record>> frameToRecordsMap = new HashMap<Frame, Set<Record>>(32771);
    private Map<Slot, Set<Record>> slotToRecordsMap = new HashMap<Slot, Set<Record>>(32771);
    private Map<Facet, Set<Record>> facetToRecordsMap = new HashMap<Facet, Set<Record>>(32771);
    private Map<Object, Set<Record>> valueToRecordsMap = new LinkedHashMap<Object, Set<Record>>(32771);
    private Record lookupRecord = new Record();
    private static int counter = 10000;
    private int projectId = FrameID.allocateMemoryProjectPart();
    private String frameDBName;
    private Slot cachedNameSlot;

    public Collection<Record> getRecords() {
        return new ArrayList<Record>(this.referenceToRecordMap.keySet());
    }

    @Override
    public String getName() {
        return this.frameDBName;
    }

    @Override
    public void setName(String string) {
        this.frameDBName = string;
    }

    public InMemoryFrameDb(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Constructing InMemoryFrameDb with name " + string + " No delegate...");
        }
        this.frameDBName = string;
    }

    @Override
    public FrameID generateFrameID() {
        return FrameID.createLocal(this.projectId, counter++);
    }

    @Override
    public void close() {
        this.referenceToRecordMap = null;
        this.frameToRecordsMap = null;
        this.slotToRecordsMap = null;
        this.facetToRecordsMap = null;
        this.valueToRecordsMap = null;
        this.lookupRecord = null;
    }

    private Record lookup(Frame frame, Slot slot, Facet facet, boolean bl) {
        this.lookupRecord.set(frame, slot, facet, bl);
        return this.referenceToRecordMap.get(this.lookupRecord);
    }

    private static <X> void addRecord(Map<X, Set<Record>> map, X x, Record record) {
        if (x != null) {
            Set<Record> set = map.get(x);
            if (set == null) {
                set = new HashSet<Record>();
                map.put(x, set);
            }
            set.add(record);
        }
    }

    public static <X> void removeRecord(Map<X, Set<Record>> map, Object object, Record record) {
        Set<Record> set;
        if (object != null && (set = map.get(object)) != null) {
            set.remove(record);
        }
    }

    private void createRecord(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        Record record = new Record(frame, slot, facet, bl, collection);
        this.addRecord(record);
    }

    private void addRecord(Record record) {
        this.referenceToRecordMap.put(record, record);
        this.idToFrameMap.put(record.getFrame().getFrameID(), record.getFrame());
        InMemoryFrameDb.addRecord(this.frameToRecordsMap, record.getFrame(), record);
        InMemoryFrameDb.addRecord(this.slotToRecordsMap, record.getSlot(), record);
        InMemoryFrameDb.addRecord(this.facetToRecordsMap, record.getFacet(), record);
        for (Object e : record.getValues()) {
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, e, record);
        }
    }

    private void removeRecord(Record record) {
        Object object2;
        this.referenceToRecordMap.remove(record);
        InMemoryFrameDb.removeRecord(this.frameToRecordsMap, record.getFrame(), record);
        InMemoryFrameDb.removeRecord(this.slotToRecordsMap, record.getSlot(), record);
        InMemoryFrameDb.removeRecord(this.facetToRecordsMap, record.getFacet(), record);
        for (Object object2 : record.getValues()) {
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, object2, record);
        }
        object2 = InMemoryFrameDb.lookupRecords(this.frameToRecordsMap, record.getFrame());
        if (object2 == null || object2.isEmpty()) {
            this.idToFrameMap.remove(record.getFrame().getFrameID());
        }
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        Record record = this.lookup(frame, slot, facet, bl);
        if (record != null) {
            record.removeValue(object);
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, object, record);
            if (record.isEmpty()) {
                this.removeRecord(record);
            }
        }
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        Record record = this.lookup(frame, slot, facet, bl);
        if (record != null) {
            record.moveValue(n, n2);
        }
    }

    private static <X, Y> Set<Y> lookupRecords(Map<X, Set<Y>> map, Object object) {
        return map.get(object);
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        Set<Record> set = InMemoryFrameDb.lookupRecords(this.valueToRecordsMap, object);
        return InMemoryFrameDb.recordsToReferences(set);
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        Set<Record> set = this.getMatchingRecords(string, n);
        return InMemoryFrameDb.recordsToReferences(set);
    }

    private Set<Record> getMatchingRecords(String string, int n) {
        if (n < 1) {
            n = Integer.MAX_VALUE;
        }
        SimpleStringMatcher simpleStringMatcher = new SimpleStringMatcher(string);
        HashSet<Record> hashSet = new HashSet<Record>();
        Iterator<Map.Entry<Object, Set<Record>>> iterator = this.valueToRecordsMap.entrySet().iterator();
        while (iterator.hasNext() && hashSet.size() < n) {
            Map.Entry<Object, Set<Record>> entry = iterator.next();
            Object object = entry.getKey();
            if (!(object instanceof String) || !simpleStringMatcher.isMatch((String)object)) continue;
            Set<Record> set = entry.getValue();
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private static Set<Reference> recordsToReferences(Set<Record> set) {
        HashSet<Reference> hashSet;
        if (set == null) {
            hashSet = Collections.EMPTY_SET;
        } else {
            hashSet = new HashSet<Reference>(set.size());
            for (Record record : set) {
                hashSet.add(InMemoryFrameDb.recordToReference(record));
            }
        }
        return hashSet;
    }

    private static Reference recordToReference(Record record) {
        Frame frame = record.getFrame();
        Slot slot = record.getSlot();
        Facet facet = record.getFacet();
        boolean bl = record.isTemplate();
        return new ReferenceImpl(frame, slot, facet, bl);
    }

    @Override
    public void executeQuery(Query query, final QueryCallback queryCallback) {
        new Thread(new Runnable(){

            public void run() {
                queryCallback.handleError(new ProtegeError("Not implemented yet"));
            }
        }, "Vacuous In MemoryDb callback thread");
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        Record record = this.lookup(frame, slot, facet, bl);
        if (record == null) {
            this.createRecord(frame, slot, facet, bl, collection);
        } else {
            this.removeRecordValues(record);
            record.setValues(collection);
            this.addRecordValues(record);
        }
    }

    private void removeRecordValues(Record record) {
        for (Object e : record.getInternalValues()) {
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, e, record);
        }
    }

    private void addRecordValues(Record record) {
        for (Object e : record.getInternalValues()) {
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, e, record);
        }
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        for (Object e : collection) {
            this.addValue(frame, slot, facet, bl, e);
        }
    }

    public void addValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        Record record = this.lookup(frame, slot, facet, bl);
        if (record == null) {
            this.createRecord(frame, slot, facet, bl, CollectionUtilities.createList(object));
        } else {
            record.addValue(object);
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, object, record);
        }
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list = Collections.EMPTY_LIST;
        Record record = this.lookup(frame, slot, facet, bl);
        if (record != null) {
            list = record.getValues();
        }
        return list;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        int n = 0;
        Record record = this.lookup(frame, slot, facet, bl);
        if (record != null) {
            n = record.getValueCount();
        }
        return n;
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.removeRecords(this.frameToRecordsMap, frame);
        this.removeRecords(this.slotToRecordsMap, frame);
        this.removeRecords(this.facetToRecordsMap, frame);
        InMemoryFrameDb.removeFrameValue(this.valueToRecordsMap, frame);
    }

    private <X> void removeRecords(Map<X, Set<Record>> map, Frame frame) {
        Collection<Record> collection = InMemoryFrameDb.lookupRecords(map, frame);
        if (collection != null) {
            collection = new ArrayList<Record>(collection);
            for (Record record : collection) {
                this.removeRecord(record);
            }
            map.remove(frame);
        }
    }

    private static <X> void removeFrameValue(Map<X, Set<Record>> map, Frame frame) {
        Set<Record> set = InMemoryFrameDb.lookupRecords(map, frame);
        if (set != null) {
            for (Record record : set) {
                record.removeValue(frame);
            }
            map.remove(frame);
        }
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    private static boolean matches(Record record, Slot slot, Facet facet, boolean bl) {
        boolean bl2 = InMemoryFrameDb.equals(slot, record.getSlot()) && InMemoryFrameDb.equals(facet, record.getFacet()) && bl == record.isTemplate();
        return bl2;
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        Set<Record> set = InMemoryFrameDb.lookupRecords(this.valueToRecordsMap, object);
        if (set != null) {
            for (Record record : set) {
                if (!InMemoryFrameDb.matches(record, slot, facet, bl)) continue;
                hashSet.add(record.getFrame());
            }
        }
        return hashSet;
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        Set<Record> set = facet != null ? InMemoryFrameDb.lookupRecords(this.facetToRecordsMap, facet) : InMemoryFrameDb.lookupRecords(this.slotToRecordsMap, slot);
        if (set != null) {
            for (Record record : set) {
                if (!InMemoryFrameDb.matches(record, slot, facet, bl)) continue;
                hashSet.add(record.getFrame());
            }
        }
        return hashSet;
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        if (n < 1) {
            n = Integer.MAX_VALUE;
        }
        HashSet<Frame> hashSet = new HashSet<Frame>();
        Iterator<Record> iterator = this.getMatchingRecords(string, -1).iterator();
        while (iterator.hasNext() && hashSet.size() < n) {
            Record record = iterator.next();
            if (!InMemoryFrameDb.matches(record, slot, facet, bl)) continue;
            hashSet.add(record.getFrame());
        }
        return hashSet;
    }

    @Override
    public boolean beginTransaction(String string) {
        return false;
    }

    @Override
    public boolean commitTransaction() {
        return true;
    }

    @Override
    public boolean rollbackTransaction() {
        return false;
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return null;
    }

    private static <X> void replaceFrameKey(Map<X, Set<Record>> map, Frame frame) {
        Set<Record> set = map.remove(frame);
        if (set != null) {
            map.put(frame, set);
            for (Record record : set) {
                record.replaceFrameReference(frame);
            }
        }
    }

    private void replaceFrameValues(Frame frame) {
        Set<Record> set = this.valueToRecordsMap.remove(frame);
        if (set != null) {
            this.valueToRecordsMap.put(frame, set);
            for (Record record : set) {
                record.replaceFrameValue(frame);
            }
        }
    }

    @Override
    public void replaceFrame(Frame frame) {
        InMemoryFrameDb.replaceFrameKey(this.frameToRecordsMap, frame);
        InMemoryFrameDb.replaceFrameKey(this.slotToRecordsMap, frame);
        InMemoryFrameDb.replaceFrameKey(this.facetToRecordsMap, frame);
        InMemoryFrameDb.replaceFrameKey(this.valueToRecordsMap, frame);
        this.replaceFrameValues(frame);
    }

    @Override
    public int getClsCount() {
        return this.countFrames(Cls.class);
    }

    @Override
    public int getSlotCount() {
        return this.countFrames(Slot.class);
    }

    @Override
    public int getFacetCount() {
        return this.countFrames(Facet.class);
    }

    @Override
    public int getFrameCount() {
        Collection collection;
        int n = 0;
        Slot slot = this.getNameSlot();
        if (slot != null && (collection = (Collection)this.slotToRecordsMap.get(slot)) != null) {
            n = collection.size();
        }
        return n;
    }

    @Override
    public Set<Frame> getFrames() {
        return new HashSet<Frame>(this.frameToRecordsMap.keySet());
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.countFrames(SimpleInstance.class);
    }

    private Slot getNameSlot() {
        Iterator<Record> iterator;
        if (this.cachedNameSlot == null && (iterator = this.referenceToRecordMap.keySet().iterator()).hasNext()) {
            Record record = iterator.next();
            Frame frame = record.getFrame();
            KnowledgeBase knowledgeBase = frame.getKnowledgeBase();
            this.cachedNameSlot = knowledgeBase.getSlot(":NAME");
        }
        return this.cachedNameSlot;
    }

    private int countFrames(Class clazz) {
        int n = 0;
        Slot slot = this.getNameSlot();
        if (slot != null) {
            Collection collection = this.slotToRecordsMap.get(slot);
            for (Record record : collection) {
                if (!clazz.isInstance(record.getFrame())) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        return this.idToFrameMap.get(frameID);
    }

    public String toString() {
        return StringUtilities.getClassName(this) + "(" + this.frameDBName + ")";
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        return ClosureUtils.calculateClosure(this, frame, slot, facet, bl);
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return null;
    }

    @Override
    public void reinitialize() {
    }
}

