/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore_Test;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import edu.stanford.smi.protege.util.AbstractEvent;
import java.util.EventObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventGeneratorFrameStore_Test
extends FrameStore_Test {
    private KnowledgeBase _kb;

    @Override
    protected FrameStore createFrameStore(DefaultKnowledgeBase kb) {
        this._kb = kb;
        EventGeneratorFrameStore fs = new EventGeneratorFrameStore(kb);
        fs.setDelegate(new InMemoryFrameStore(kb));
        return fs;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this._kb = null;
    }

    private boolean containsSimilarEvent(List<EventObject> events, AbstractEvent event) {
        for (EventObject ev : events) {
            if (ev instanceof AbstractEvent) {
                event.setTimeStamp(((AbstractEvent)ev).getTimeStamp());
            }
            if (!ev.equals(event)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimilarEvent(EventObject event1, AbstractEvent event2) {
        if (event1 instanceof AbstractEvent) {
            event2.setTimeStamp(((AbstractEvent)event1).getTimeStamp());
        }
        return event1.equals(event2);
    }

    public void testCreateClsEvent() {
        Cls rootCls = this._kb.getRootCls();
        Cls stdCls = this._kb.getCls(":STANDARD-CLASS");
        Slot subclassesSlot = this._kb.getSlot(":DIRECT-SUBCLASSES");
        Slot instancesSlot = this._kb.getSlot(":DIRECT-INSTANCES");
        Cls cls = this.createCls();
        List<EventObject> events = this.getTestFrameStore().getEvents();
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(events, new KnowledgeBaseEvent(this._kb, 601, cls)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(events, new ClsEvent(rootCls, 303, (Object)cls)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(events, new FrameEvent(rootCls, 110, (Object)subclassesSlot)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(events, new ClsEvent(stdCls, 305, (Object)cls)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(events, new FrameEvent(stdCls, 110, (Object)instancesSlot, null)));
    }

    public void testAddSuperclassEvent() {
        Cls cls = this.createCls();
        Cls superclass = this.createCls();
        this.getTestFrameStore().getEvents();
        this.getTestFrameStore().addDirectSuperclass(cls, superclass);
        List<AbstractEvent> events = this.getTestFrameStore().getEvents();
        ClsEvent testEvent1 = new ClsEvent(cls, 301, (Object)superclass);
        ClsEvent testEvent2 = new ClsEvent(superclass, 303, (Object)cls);
        EventGeneratorFrameStore_Test.assertTrue((String)"kb event", (boolean)this.isSimilarEvent(events.get(0), testEvent1));
        EventGeneratorFrameStore_Test.assertTrue((String)"kb event", (boolean)this.isSimilarEvent(events.get(1), testEvent2));
    }

    public void testDeleteClsEvents() {
        Cls cls = this.createCls();
        KnowledgeBaseEvent testEvent1 = new KnowledgeBaseEvent(this._kb, 602, cls, (Object)cls.getName());
        this.getTestFrameStore().getEvents();
        this.getTestFrameStore().deleteCls(cls);
        List<EventObject> events = this.getTestFrameStore().getEvents();
        EventGeneratorFrameStore_Test.assertTrue((boolean)this.containsSimilarEvent(events, testEvent1));
    }
}

