/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.test.APITestCase;
import java.awt.Rectangle;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Project_Test
extends APITestCase {
    private static boolean disableMissingWebPageTests = true;
    private static final String SUBDIR = "project_subdir";
    private static final String NewspaperJarFileProperty = "junit.project.file.jar.newspaper";
    private static final String IncludingFileProperty = "junit.project.file.including";
    private static final String IncludedFileProperty = "junit.project.file.including";
    private static final String MAP_NAME = "Project_Test.test_map";
    private static final String HTTP_BASE = "http://protege.stanford.edu/";
    private static final String DIR = "applet_demo/Newspaper/";
    private static final String FILE_BASE = "file:/u:/protege_web/";
    private static final String JAR_PROJECT = "newspaper.jar!/samples/examples/newspaper/newspaper.pprj";
    private static final String HTTP_PROJECT_STRING = "http://protege.stanford.edu/applet_demo/Newspaper/newspaper.pprj";
    private static final String HTTP_JAR_PROJECT_STRING = "jar:http://protege.stanford.edu/applet_demo/Newspaper/newspaper.jar!/samples/examples/newspaper/newspaper.pprj";
    private static final String INCLUDED_PROJECT_NAME = "included";
    private static final String MAIN_PROJECT_NAME = "main";

    public void testPropertyMapLoading() {
        Frame frame = this.createFrame();
        String frameName = frame.getName();
        Map testMap = new HashMap<Object, Object>();
        this.setClientInformation(MAP_NAME, testMap);
        Rectangle savedRect = new Rectangle(1, 2, 3, 4);
        testMap.put(frame, savedRect);
        testMap.put("foo", "bar");
        Project_Test.saveAndReload();
        frame = this.getFrame(frameName);
        testMap = (Map)this.getClientInformation(MAP_NAME);
        Project_Test.assertNotNull((String)"map exists", testMap);
        Project_Test.assertEquals((String)"string", (Object)"bar", testMap.get("foo"));
        Project_Test.assertEquals((String)"rectangle", (Object)savedRect, testMap.get(frame));
    }

    public void testProjectURISaveLoad() {
        Project p = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        Project_Test.assertNotNull((Object)p);
    }

    private static File getTempSubdirectory() {
        return Project_Test.getTempSubdirectory(SUBDIR);
    }

    private static void deleteTempSubdirectory() {
        Project_Test.deleteTempSubdirectory(SUBDIR);
    }

    private static Project createProjectOnDisk(File directory, String name) {
        ArrayList errors = new ArrayList();
        Project project = Project.createNewProject(null, errors);
        Project_Test.checkErrors(errors);
        URI projectURI = new File(directory, name + ".pprj").toURI();
        project.setProjectURI(projectURI);
        KnowledgeBase kb = project.getKnowledgeBase();
        Cls cls = kb.createCls(null, kb.getRootClses());
        Slot slot = kb.createSlot(null);
        cls.addDirectTemplateSlot(slot);
        kb.createInstance(null, cls);
        int frameCount = kb.getFrameCount();
        project.save(errors);
        Project_Test.checkErrors(errors);
        project.dispose();
        project = Project.loadProjectFromURI(projectURI, errors);
        Project_Test.checkErrors(errors);
        kb = project.getKnowledgeBase();
        Project_Test.assertEquals((int)frameCount, (int)kb.getFrameCount());
        return project;
    }

    public void testProjectLoadFromFile() {
        Project p = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        int count = p.getKnowledgeBase().getFrameCount();
        URI uri = p.getProjectURI();
        ArrayList errors = new ArrayList();
        p = Project.loadProjectFromFile(new File(uri).getPath(), errors);
        Project_Test.checkErrors(errors);
        int count2 = p.getKnowledgeBase().getFrameCount();
        Project_Test.assertEquals((int)count, (int)count2);
    }

    public void testProjectLoadFromHttpJar() {
        if (!disableMissingWebPageTests) {
            this.loadProjectFromURI(HTTP_JAR_PROJECT_STRING);
        }
    }

    private Project loadProjectFromURI(String uriString) {
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            Project_Test.fail();
        }
        Project p = Project_Test.loadProjectFromURI(uri);
        Cls cls = p.getKnowledgeBase().getCls("Editor");
        Project_Test.assertNotNull((Object)cls);
        return p;
    }

    private static Project loadProjectFromURI(URI uri) {
        ArrayList errors = new ArrayList();
        Project p = Project.loadProjectFromURI(uri, errors);
        Project_Test.checkErrors(errors);
        return p;
    }

    public void testProjectLoadFromHttp() {
        if (!disableMissingWebPageTests) {
            this.loadProjectFromURI(HTTP_PROJECT_STRING);
        }
    }

    public void testProjectLoadFromFileJar() {
        Properties jup = Project_Test.getJunitProperties();
        String uri = jup.getProperty(NewspaperJarFileProperty);
        if (uri == null) {
            return;
        }
        try {
            this.loadProjectFromURI(uri);
        }
        catch (Exception e) {
            Project_Test.fail((String)"Exception caught loading jar file");
        }
    }

    public void testIncludeFromSameDirectory() {
        Project p1 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        Project p2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), INCLUDED_PROJECT_NAME);
        this.checkInclusion(p1, p2);
    }

    private void checkInclusion(Project includingProject, Project includedProject) {
        URI projectURI = includingProject.getProjectURI();
        ArrayList errors = new ArrayList();
        includingProject.includeProject(includedProject.getProjectURI(), errors);
        Project_Test.checkErrors(errors);
        int startFrameCount = includingProject.getKnowledgeBase().getFrameCount();
        includingProject.save(errors);
        Project_Test.checkErrors(errors);
        Project p = Project_Test.loadProjectFromURI(projectURI);
        int endFrameCount = p.getKnowledgeBase().getFrameCount();
        Project_Test.assertEquals((int)startFrameCount, (int)endFrameCount);
    }

    public void testIncludeFromSubdirectory() {
        Project p1 = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), INCLUDED_PROJECT_NAME);
        Project p2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(p2, p1);
    }

    public void testIncludeFromSuperdirectory() {
        Project p1 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), INCLUDED_PROJECT_NAME);
        Project p2 = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(p2, p1);
    }

    public void testIncludeWithSaveToSubdirectory() {
        Project p = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), MAIN_PROJECT_NAME);
        URI targetURI = p.getProjectURI();
        Project_Test.deleteTempSubdirectory();
        Project p1 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), INCLUDED_PROJECT_NAME);
        Project p2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(p2, p1);
        Project_Test.getTempSubdirectory();
        p2.setProjectURI(targetURI);
        Project_Test.saveAndReload(p);
    }

    private static Project saveAndReload(Project p) {
        ArrayList errors = new ArrayList();
        int frameCount = p.getKnowledgeBase().getFrameCount();
        URI uri = p.getProjectURI();
        p.save(errors);
        Project_Test.checkErrors(errors);
        p = Project.loadProjectFromURI(uri, errors);
        Project_Test.checkErrors(errors);
        int frameCount2 = p.getKnowledgeBase().getFrameCount();
        Project_Test.assertEquals((int)frameCount, (int)frameCount2);
        return p;
    }

    public void testIncludeWithSaveToSuperdirectory() {
        Project p = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        URI targetURI = p.getProjectURI();
        Project_Test.deleteTempSubdirectory();
        Project p1 = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), INCLUDED_PROJECT_NAME);
        Project p2 = Project_Test.createProjectOnDisk(Project_Test.getTempSubdirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(p2, p1);
        p2.setProjectURI(targetURI);
        Project_Test.saveAndReload(p);
    }

    public void testIncludeFromHttp() {
        if (disableMissingWebPageTests) {
            return;
        }
        Project p1 = this.loadProjectFromURI(HTTP_PROJECT_STRING);
        Project p2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(p2, p1);
    }

    public void testIncludeFromFileJar() {
        Properties jup = Project_Test.getJunitProperties();
        String including = jup.getProperty("junit.project.file.including");
        String included = jup.getProperty("junit.project.file.including");
        if (including == null && included == null) {
            return;
        }
        Project p1 = this.loadProjectFromURI(included);
        Project p2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), including);
        this.checkInclusion(p2, p1);
    }

    public void testIncludeFromHttpJar() {
        if (disableMissingWebPageTests) {
            return;
        }
        Project p1 = this.loadProjectFromURI(HTTP_JAR_PROJECT_STRING);
        Project p2 = Project_Test.createProjectOnDisk(Project_Test.getTempDirectory(), MAIN_PROJECT_NAME);
        this.checkInclusion(p2, p1);
    }

    public void testIsDirtyOnCreateInstance() {
        Project p = this.getProject();
        p.clearIsDirty();
        KnowledgeBase kb = p.getKnowledgeBase();
        p.getKnowledgeBase().createInstance(null, kb.getRootCls());
        Project_Test.assertTrue((boolean)p.isDirty());
    }
}

