/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserSlotPattern {
    private List elements;

    public BrowserSlotPattern(Slot slot) {
        this.elements = new ArrayList();
        this.elements.add(slot);
    }

    public BrowserSlotPattern(List list) {
        this.elements = new ArrayList(list);
    }

    public boolean isSimple() {
        return this.elements.size() == 1 && this.getFirstSlot() != null;
    }

    public Slot getFirstSlot() {
        Slot slot = null;
        for (Object e : this.elements) {
            if (!(e instanceof Slot)) continue;
            slot = (Slot)e;
            break;
        }
        return slot;
    }

    public String getSerialization() {
        Object var1_1 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : this.elements) {
            if (e instanceof String) {
                stringBuffer.append("{" + BrowserSlotPattern.toSafeText((String)e) + "}");
            }
            if (e instanceof Slot) {
                if (var1_1 instanceof Slot) {
                    stringBuffer.append("{}");
                }
                Slot slot = (Slot)e;
                stringBuffer.append(BrowserSlotPattern.toSafeText(slot.getName()));
            }
            var1_1 = e;
        }
        return stringBuffer.toString();
    }

    private static String toSafeText(String string) {
        return FileUtilities.urlEncode(string);
    }

    private static String fromSafeText(String string) {
        return FileUtilities.urlDecode(string);
    }

    public static BrowserSlotPattern createFromSerialization(KnowledgeBase knowledgeBase, String string) {
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("{")) {
                    bl = true;
                    continue;
                }
                if (string3.equals("}")) {
                    bl = false;
                    continue;
                }
                if (bl) {
                    string2 = BrowserSlotPattern.fromSafeText(string3);
                    arrayList.add(string2);
                    continue;
                }
                string2 = BrowserSlotPattern.fromSafeText(string3);
                Slot slot = knowledgeBase.getSlot(string2);
                if (slot == null) continue;
                arrayList.add(slot);
            }
        }
        return arrayList.isEmpty() ? null : new BrowserSlotPattern(arrayList);
    }

    public boolean contains(Slot slot) {
        return this.elements.contains(slot);
    }

    public List getElements() {
        return new ArrayList(this.elements);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof BrowserSlotPattern) {
            BrowserSlotPattern browserSlotPattern = (BrowserSlotPattern)object;
            bl = CollectionUtilities.equalsList(this.elements, browserSlotPattern.elements);
        }
        return bl;
    }

    public int hashCode() {
        return this.elements.get(0).hashCode();
    }

    public List<Slot> getSlots() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (Object e : this.elements) {
            if (!(e instanceof Slot)) continue;
            arrayList.add((Slot)e);
        }
        return arrayList;
    }

    public String getBrowserText(Instance instance) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : this.elements) {
            if (e instanceof Slot) {
                stringBuffer.append(BrowserSlotPattern.getText((Slot)e, instance));
                continue;
            }
            stringBuffer.append(e);
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    private static String getText(Slot slot, Instance instance) {
        String string;
        List list = instance.getDirectOwnSlotValues(slot);
        if (list.size() > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            boolean bl = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                Object e = iterator.next();
                stringBuffer.append(BrowserSlotPattern.getText(e, instance));
            }
            stringBuffer.append("}");
            string = stringBuffer.toString();
        } else {
            Object object = CollectionUtilities.getFirstItem(list);
            string = BrowserSlotPattern.getText(object, instance);
        }
        return string;
    }

    private static String getText(Object object, Instance instance) {
        String string = object == null ? "" : (object instanceof Frame ? (object.equals(instance) ? "<recursive call>" : ((Frame)object).getBrowserText()) : object.toString());
        return string;
    }

    public String toString() {
        return "BrowserSlotPattern(" + this.getSerialization() + ")";
    }
}

