/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory2;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;

public abstract class AbstractKnowledgeBaseFactory
implements KnowledgeBaseFactory2 {
    protected BufferedReader createReader(KnowledgeBase knowledgeBase, String string, Collection collection) {
        URI uRI;
        URI uRI2 = knowledgeBase.getProject().getLoadingURI();
        if (uRI2 == null) {
            uRI = new File(string).toURI();
        } else {
            string = AbstractKnowledgeBaseFactory.encode(string);
            uRI = URIUtilities.resolve(uRI2, string);
        }
        BufferedReader bufferedReader = URIUtilities.createBufferedReader(uRI);
        if (bufferedReader == null) {
            String string2 = "Unable to open " + uRI + " for " + string;
            collection.add(new MessageError(string2));
            Log.getLogger().severe(string2);
        }
        return bufferedReader;
    }

    private static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        string = FileUtilities.urlEncode(string);
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(43, n)) != -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append("%20");
            n = n2 + 1;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public String getProjectFilePath() {
        return null;
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        this.loadKnowledgeBase(knowledgeBase, propertyList, false, collection);
    }

    public NarrowFrameStore createNarrowFrameStore(String string) {
        return new InMemoryFrameDb(string);
    }

    public void includeKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        this.loadKnowledgeBase(knowledgeBase, propertyList, true, collection);
    }

    protected abstract void loadKnowledgeBase(KnowledgeBase var1, PropertyList var2, boolean var3, Collection var4);

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    protected File createTempFile(KnowledgeBase knowledgeBase, String string) throws IOException {
        File file = null;
        if (string != null) {
            File file2;
            Project project = knowledgeBase.getProject();
            if (project == null) {
                file2 = new File(string);
            } else {
                URI uRI = knowledgeBase.getProject().getProjectURI();
                File file3 = new File(uRI);
                String string2 = FileUtilities.replaceFileName(file3.getPath(), string);
                file2 = new File(string2);
            }
            file = FileUtilities.createTempFile(file2);
        }
        return file;
    }

    protected void makeTempFilePermanent(File file) throws IOException {
        FileUtilities.makeTempFilePermanent(file);
    }

    protected BufferedWriter createWriter(File file) {
        return FileUtilities.createBufferedWriter(file);
    }

    protected void close(Writer writer) {
        FileUtilities.close(writer);
    }

    protected void close(Reader reader) {
        FileUtilities.close(reader);
    }

    protected URI getSourceUri(String string, PropertyList propertyList, KnowledgeBase knowledgeBase) {
        return null;
    }

    public void prepareToSaveInFormat(KnowledgeBase knowledgeBase, KnowledgeBaseFactory knowledgeBaseFactory, Collection collection) {
    }
}

