/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.event;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.test.APITestCase;

public class FrameListener_Test
extends APITestCase {
    public void testFrameNameChangedEvent() {
        this.clearEvents();
        FrameAdapter listener = new FrameAdapter(){

            public void nameChanged(FrameEvent event) {
                FrameListener_Test.this.recordEventFired(event);
            }

            public void ownSlotValueChanged(FrameEvent event) {
                FrameListener_Test.this.recordEventFired(event);
            }

            public void browserTextChanged(FrameEvent event) {
                FrameListener_Test.this.recordEventFired(event);
            }
        };
        Cls frame = this.createCls();
        frame.addFrameListener(listener);
        frame.setName("foo");
        this.assertEventFired(101);
        this.assertEventFired(110);
        this.assertEventFired(105);
    }

    public void testOwnSlotValueChangedEvent() {
        this.clearEvents();
        FrameAdapter listener = new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent event) {
                FrameListener_Test.this.recordEventFired(event);
            }
        };
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        Instance instance = this.createInstance(cls);
        instance.addFrameListener(listener);
        instance.setOwnSlotValue(slot, "foo");
        this.assertEventFired(110);
        this.clearEvents();
        instance.setOwnSlotValues(slot, FrameListener_Test.makeList("a", "b"));
        FrameEvent event = (FrameEvent)this.getEventFired(110);
        FrameListener_Test.assertEqualsList(event.getOldValues(), FrameListener_Test.makeList("foo"));
    }
}

