/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class TutorialTabWidget
extends AbstractTabWidget {
    private JList list;

    public void initialize() {
        this.setLabel("Tutorial-Tab");
        this.setShortDescription("A simple demo tab that displays the recently added classes");
        this.list = new JList();
        this.list.setCellRenderer(new FrameRenderer());
        LabeledComponent labeledComponent = new LabeledComponent("Added Classes", new JScrollPane(this.list));
        labeledComponent.addHeaderButton((Action)new AbstractAction("View selected class", Icons.getViewIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                TutorialTabWidget.this.viewSelectedCls();
            }
        });
        this.add("Center", (Component)labeledComponent);
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        oWLModel.addModelListener(new ModelAdapter(){

            public void classCreated(RDFSClass rDFSClass) {
                TutorialTabWidget.this.addListEntry(rDFSClass);
            }
        });
    }

    private void addListEntry(RDFSClass rDFSClass) {
        if (rDFSClass instanceof RDFSNamedClass) {
            Vector vector = new Vector();
            for (int i = 0; i < this.list.getModel().getSize(); ++i) {
                vector.add(this.list.getModel().getElementAt(i));
            }
            vector.add(rDFSClass);
            this.list.setListData(vector);
        }
    }

    private void viewSelectedCls() {
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.list.getSelectedValue();
        if (rDFSNamedClass != null) {
            this.getProject().show((Instance)rDFSNamedClass);
        }
    }
}

