/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFAxiomRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class OWLModelOrderedContentWriter
implements RDFXMLContentWriter {
    private OWLModel model;
    private TripleStore tripleStore;
    private Comparator comparator;

    public OWLModelOrderedContentWriter(OWLModel oWLModel, TripleStore tripleStore, Comparator comparator) {
        this.model = oWLModel;
        this.tripleStore = tripleStore;
        this.comparator = comparator;
    }

    protected Collection getResources() {
        TreeSet<RDFResource> treeSet = new TreeSet<RDFResource>(this.comparator);
        Iterator<RDFResource> iterator = this.tripleStore.listHomeResources();
        while (iterator.hasNext()) {
            RDFResource rDFResource = iterator.next();
            if (rDFResource.isSystem() || rDFResource.isAnonymous()) continue;
            treeSet.add(rDFResource);
        }
        for (RDFResource rDFResource : this.model.getRDFProperties()) {
            Iterator<RDFResource> iterator2 = this.tripleStore.listSubjects((RDFProperty)rDFResource);
            while (iterator2.hasNext()) {
                RDFResource rDFResource2;
                RDFResource rDFResource3 = iterator2.next();
                if (!(rDFResource3 instanceof RDFResource) || (rDFResource2 = rDFResource3).isAnonymous() || rDFResource2.isSystem() || treeSet.contains(rDFResource2)) continue;
                treeSet.add(rDFResource2);
            }
        }
        return treeSet;
    }

    public void writeContent(XMLWriter xMLWriter) throws IOException {
        OWLModelVisitorAdapter oWLModelVisitorAdapter;
        HashSet<OWLOntology> hashSet = new HashSet<OWLOntology>();
        for (RDFResource rDFResource : this.model.getOWLOntologies()) {
            if (!rDFResource.getOWLModel().getTripleStoreModel().getHomeTripleStore(rDFResource).equals(this.tripleStore)) continue;
            oWLModelVisitorAdapter = new RDFResourceRenderer(rDFResource, this.tripleStore, xMLWriter);
            ((RDFResourceRenderer)oWLModelVisitorAdapter).write();
            hashSet.add((OWLOntology)rDFResource);
        }
        for (RDFResource rDFResource : this.model.getOWLAllDifferents()) {
            if (!this.model.getTripleStoreModel().getHomeTripleStore(rDFResource).equals(this.tripleStore)) continue;
            oWLModelVisitorAdapter = new RDFResourceRenderer(rDFResource, this.tripleStore, xMLWriter);
            ((RDFResourceRenderer)oWLModelVisitorAdapter).write();
            hashSet.add((OWLOntology)rDFResource);
        }
        for (RDFResource rDFResource : this.getResources()) {
            oWLModelVisitorAdapter = new RDFAxiomRenderer(rDFResource, this.tripleStore, xMLWriter);
            ((RDFAxiomRenderer)oWLModelVisitorAdapter).write();
            hashSet.add((OWLOntology)rDFResource);
        }
    }
}

