/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFAxiomRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public class OWLModelContentWriter
implements RDFXMLContentWriter {
    private OWLModel model;
    private TripleStore tripleStore;

    public OWLModelContentWriter(OWLModel oWLModel, TripleStore tripleStore) {
        this.model = oWLModel;
        this.tripleStore = tripleStore;
    }

    public void writeContent(XMLWriter xMLWriter) throws IOException {
        RDFResourceRenderer rDFResourceRenderer;
        Object object;
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        for (RDFResource rDFResource : this.model.getOWLOntologies()) {
            object = rDFResource.getOWLModel().getTripleStoreModel().getHomeTripleStore(rDFResource);
            if (object == null || !object.equals(this.tripleStore)) continue;
            rDFResourceRenderer = new RDFResourceRenderer(rDFResource, this.tripleStore, xMLWriter);
            rDFResourceRenderer.write();
            hashSet.add(rDFResource);
        }
        for (RDFResource rDFResource : this.model.getOWLAllDifferents()) {
            if (!this.model.getTripleStoreModel().getHomeTripleStore(rDFResource).equals(this.tripleStore)) continue;
            object = new RDFResourceRenderer(rDFResource, this.tripleStore, xMLWriter);
            ((RDFResourceRenderer)object).write();
            hashSet.add(rDFResource);
        }
        Iterator<Object> iterator = this.tripleStore.listHomeResources();
        while (iterator.hasNext()) {
            RDFResource rDFResource;
            rDFResource = (RDFResource)iterator.next();
            if (rDFResource.isSystem() || rDFResource.isAnonymous()) continue;
            object = new RDFAxiomRenderer(rDFResource, this.tripleStore, xMLWriter);
            ((RDFAxiomRenderer)object).write();
            hashSet.add(rDFResource);
        }
        for (RDFResource rDFResource : this.model.getRDFProperties()) {
            object = this.tripleStore.listSubjects((RDFProperty)rDFResource);
            while (object.hasNext()) {
                RDFResource rDFResource2;
                rDFResourceRenderer = object.next();
                if (!(rDFResourceRenderer instanceof RDFResource) || (rDFResource2 = (RDFResource)((Object)rDFResourceRenderer)).isAnonymous() || rDFResource2.isSystem() || hashSet.contains(rDFResource2)) continue;
                RDFAxiomRenderer rDFAxiomRenderer = new RDFAxiomRenderer(rDFResource2, this.tripleStore, xMLWriter);
                rDFAxiomRenderer.write();
                hashSet.add(rDFResource2);
            }
        }
    }
}

