/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.util.Collection;

public class OWLWidgetUtil {
    public static boolean isDatatypeProperty(RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty) {
        RDFResource rDFResource;
        if (rDFProperty instanceof OWLObjectProperty) {
            return false;
        }
        if (rDFProperty instanceof OWLDatatypeProperty) {
            return true;
        }
        if (rDFSNamedClass instanceof OWLNamedClass && (rDFResource = ((OWLNamedClass)rDFSNamedClass).getAllValuesFrom(rDFProperty)) instanceof RDFSDatatype) {
            return true;
        }
        return rDFProperty.getRange() instanceof RDFSDatatype;
    }

    public static boolean isDatatypeProperty(RDFSDatatype rDFSDatatype, RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty) {
        OWLNamedClass oWLNamedClass;
        if (rDFSNamedClass instanceof OWLNamedClass && rDFSDatatype.equals((oWLNamedClass = (OWLNamedClass)rDFSNamedClass).getAllValuesFrom(rDFProperty))) {
            return true;
        }
        return rDFSDatatype.equals(rDFProperty.getRange());
    }

    public static boolean isFunctionalProperty(RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty) {
        if (rDFSNamedClass instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
            int n = oWLNamedClass.getMaxCardinality(rDFProperty);
            return n == 0 || n == 1;
        }
        return rDFProperty.isFunctional();
    }

    public static boolean isRangelessDatatypeProperty(RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty) {
        if (rDFProperty instanceof OWLObjectProperty) {
            return false;
        }
        if (rDFSNamedClass instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
            RDFResource rDFResource = oWLNamedClass.getAllValuesFrom(rDFProperty);
            return rDFResource == null;
        }
        return rDFProperty.getRange() == null;
    }

    public static boolean isRangelessObjectProperty(RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty) {
        if (rDFProperty instanceof OWLDatatypeProperty) {
            return false;
        }
        if (rDFSNamedClass instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
            RDFResource rDFResource = oWLNamedClass.getAllValuesFrom(rDFProperty);
            return rDFResource == null;
        }
        return rDFProperty.getRange() == null && rDFProperty instanceof OWLObjectProperty;
    }

    public static boolean isRestrictedProperty(RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty) {
        if (rDFSNamedClass instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSNamedClass;
            Collection collection = oWLNamedClass.getRestrictions(rDFProperty, true);
            if (!collection.isEmpty()) {
                return true;
            }
            for (RDFProperty rDFProperty2 : rDFProperty.getSuperproperties(false)) {
                if (!OWLWidgetUtil.isRestrictedProperty(rDFSNamedClass, rDFProperty2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSingleDatatypeProperty(RDFSDatatype rDFSDatatype, RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty) {
        return OWLWidgetUtil.isDatatypeProperty(rDFSDatatype, rDFSNamedClass, rDFProperty) && OWLWidgetUtil.isFunctionalProperty(rDFSNamedClass, rDFProperty);
    }
}

