/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.action.Copy;
import edu.stanford.smi.protege.action.Cut;
import edu.stanford.smi.protege.action.InsertUnicodeCharacterAction;
import edu.stanford.smi.protege.action.Paste;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.Finder;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.ClsesTab;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protege.widget.InstancesTab;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.SlotsTab;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLToolTipGenerator;
import edu.stanford.smi.protegex.owl.util.OWLBrowserSlotPattern;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class OWLUI {
    public static String CODE_MENU = "Code";
    public static final String CONSTRAINT_CHECKING = "OWL-CONSTRAINT-CHECKING";
    private static final String DRAG_AND_DROP = "OWL-DRAG-AND-DROP-DISABLED";
    private static final String EXTERNAL_RESOURCES = "OWL-EXTERNAL-RESOURCES-ENABLED";
    public static String OWL_MENU = "OWL";
    public static final String TOOLS_MENU = "Tools";
    private static OWLToolTipGenerator toolTipGenerator;
    public static final int WIZARD_HELP_HEIGHT = 160;
    private static long lastConnectFailureTime;
    private static long CONNECT_NOTIFICATION_TIMEOUT;
    private static Set unsuitableTabs;

    public static void selectResource(RDFResource rDFResource, HostResourceDisplay hostResourceDisplay) {
        ProjectView projectView = ProtegeUI.getProjectView(rDFResource.getProject());
        if (hostResourceDisplay == null) {
            for (Object e : projectView.getTabs()) {
                if (!(e instanceof HostResourceDisplay) || !((HostResourceDisplay)e).displayHostResource(rDFResource)) continue;
                projectView.setSelectedTab((TabWidget)e);
                ((JComponent)e).requestFocusInWindow();
                return;
            }
        } else if (hostResourceDisplay.displayHostResource(rDFResource) && hostResourceDisplay instanceof TabWidget) {
            projectView.setSelectedTab((TabWidget)hostResourceDisplay);
            ((JComponent)((Object)hostResourceDisplay)).requestFocusInWindow();
        }
    }

    public static void addCopyPastePopup(JTextComponent jTextComponent) {
        jTextComponent.addMouseListener((MouseListener)new PopupMenuMouseListener(jTextComponent){

            protected JPopupMenu getPopupMenu() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add((Action)new Cut(false));
                jPopupMenu.add((Action)new Copy(false));
                jPopupMenu.add((Action)new Paste(false));
                jPopupMenu.add((Action)new InsertUnicodeCharacterAction());
                return jPopupMenu;
            }

            protected void setSelection(JComponent jComponent, int n, int n2) {
                jComponent.requestFocus();
            }
        });
    }

    public static JButton addFrameTreeFinderButton(Finder finder, Action action) {
        JToolBar jToolBar = (JToolBar)finder.getComponent(1);
        if (jToolBar.getComponentCount() == 1) {
            jToolBar.addSeparator();
        }
        return ComponentFactory.addToolBarButton((JToolBar)jToolBar, (Action)action);
    }

    public static JFileChooser createJFileChooser(String string, String string2) {
        JFileChooser jFileChooser = ComponentFactory.createFileChooser((String)string, (String)string2);
        jFileChooser.setFileFilter((FileFilter)new ExtensionFilter(string2, string));
        return jFileChooser;
    }

    public static JComponent createHelpPanel(String string, String string2) {
        return OWLUI.createHelpPanel(string, string2, -1);
    }

    public static JComponent createHelpPanel(String string, String string2, int n) {
        ImageIcon imageIcon = OWLIcons.getImageIcon("OWLHelp.png");
        return OWLUI.createHelpPanel(string, string2, n, imageIcon);
    }

    public static JComponent createHelpPanel(String string, String string2, int n, Icon icon) {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string3 = "<HTML><BODY>";
        if (string2 != null) {
            string3 = string3 + "<h4>" + string2 + "</h4>";
        }
        JLabel jLabel = new JLabel(string3 + string, icon, 2);
        jLabel.setIconTextGap(16);
        jLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel.setBackground(new Color(255, 255, 180));
        jPanel.add("Center", jLabel);
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        int n2 = jLabel.getPreferredSize().width;
        int n3 = jLabel.getPreferredSize().height + 30;
        if (n > 0) {
            n3 = n;
        }
        jPanel.setPreferredSize(new Dimension(n2, n3));
        jPanel.setMaximumSize(new Dimension(n2, n3));
        return jPanel;
    }

    public static JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.setRollover(true);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setBorder(null);
        return jToolBar;
    }

    public static Component findComponent(Container container, Class clazz) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component;
            Component component2 = container.getComponent(i);
            if (clazz.isAssignableFrom(component2.getClass())) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = OWLUI.findComponent((Container)component2, clazz)) == null) continue;
            return component;
        }
        return null;
    }

    public static int getConfirmationThreshold(OWLModel oWLModel) {
        return 200;
    }

    private static OWLModel getOWLModel(Collection collection) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)collection);
        return (OWLModel)cls.getKnowledgeBase();
    }

    public static String getOWLToolTipText(RDFSClass rDFSClass) {
        return OWLUI.getOWLToolTipText((RDFResource)rDFSClass);
    }

    public static String getOWLToolTipText(RDFResource rDFResource) {
        if (toolTipGenerator != null) {
            return toolTipGenerator.getToolTipText(rDFResource);
        }
        System.out.println("LOST GENERATOR");
        return null;
    }

    public static OWLToolTipGenerator getOWLToolTipGenerator() {
        return toolTipGenerator;
    }

    public static SlotWidget getSiblingSlotWidget(Component component, Slot slot) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof FormWidget); container = container.getParent()) {
        }
        if (container instanceof FormWidget) {
            FormWidget formWidget = (FormWidget)container;
            return formWidget.getSlotWidget(slot);
        }
        return null;
    }

    public static String getWidgetLabel(Slot slot) {
        if (slot instanceof RDFProperty) {
            String string = slot.getBrowserText();
            return string;
        }
        return StringUtilities.symbolToLabel((String)slot.getBrowserText());
    }

    public static void handleError(Throwable throwable) {
        OWLUI.handleError(null, throwable);
    }

    public static void handleError(OWLModel oWLModel, Throwable throwable) {
        if (!OWLUI.handleSQLException(oWLModel, throwable) && !OWLUI.handleConnectionLostException(oWLModel, throwable)) {
            OWLUI.handleDefaultException(oWLModel, throwable);
        }
    }

    private static void handleDefaultException(OWLModel oWLModel, Throwable throwable) {
        Log.getLogger().log(Level.SEVERE, "Exception caught", throwable);
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Internal Error: " + throwable + "\nPlease see Java console for details, and possibly report" + "\nthis on our OWL mailing lists." + "\nhttp://protege.stanford.edu/community/lists.html" + "\nYour ontology may now no longer be in a consistent state, and" + "\nyou may want to save this version under a different name.", "Internal Protege-OWL Error");
    }

    private static boolean handleSQLException(OWLModel oWLModel, Throwable throwable) {
        boolean bl = false;
        for (Throwable throwable2 = throwable; !bl && throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof SQLException)) continue;
            if (throwable2.getMessage() != null && throwable2.getMessage().contains("Lock")) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Database table is currently locked by a different user.\nPlease retry the operation later.", "Locked ontology");
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "A database error has occured: " + throwable2 + "\nPlease see Java console for details, and possibly report" + "\nthis on our OWL mailing lists." + "\nhttp://protege.stanford.edu/community/lists.html", "Database Error");
            }
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean handleConnectionLostException(OWLModel oWLModel, Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof ConnectException || throwable instanceof java.rmi.ConnectException || throwable instanceof NoRouteToHostException) {
                if (lastConnectFailureTime == -1L || lastConnectFailureTime - System.currentTimeMillis() < CONNECT_NOTIFICATION_TIMEOUT) {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Connection Problem - could be that the server is down or a problem with the network.\nSee the console for details", "Connection failure");
                    Log.getLogger().log(Level.WARNING, "Connection failure", throwable);
                } else {
                    Log.getLogger().warning("Recurring connection problem" + throwable);
                }
                lastConnectFailureTime = System.currentTimeMillis();
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean isConfirmationNeeded(OWLModel oWLModel) {
        return oWLModel instanceof OWLDatabaseModel || oWLModel.getProject().isMultiUserClient();
    }

    public static boolean isConfirmed(Project project, boolean bl) {
        return OWLUI.isConfirmed((OWLModel)project.getKnowledgeBase(), bl);
    }

    public static boolean isConfirmed(OWLModel oWLModel, boolean bl) {
        if (bl) {
            return ProtegeUI.getModalDialogFactory().showConfirmDialog(oWLModel, "Warning: This operation could potentially take very long.\nAre you sure you want to perform it?", "Confirm Action");
        }
        return true;
    }

    public static boolean isConstraintChecking(OWLModel oWLModel) {
        return !Boolean.FALSE.equals(oWLModel.getOWLProject().getSettingsMap().getBoolean(CONSTRAINT_CHECKING));
    }

    public static boolean isDragAndDropSupported(OWLModel oWLModel) {
        OWLProject oWLProject = oWLModel.getOWLProject();
        return !Boolean.FALSE.equals(oWLProject.getSettingsMap().getBoolean(DRAG_AND_DROP));
    }

    public static boolean isExternalResourcesSupported(OWLModel oWLModel) {
        OWLProject oWLProject = oWLModel.getOWLProject();
        return Boolean.TRUE.equals(oWLProject.getSettingsMap().getBoolean(EXTERNAL_RESOURCES));
    }

    public static RDFSClass pickConcreteClass(OWLModel oWLModel, String string) {
        return ProtegeUI.getSelectionDialogFactory().selectClass(null, oWLModel, string);
    }

    public static RDFSClass pickConcreteClass(OWLModel oWLModel, Collection collection) {
        return ProtegeUI.getSelectionDialogFactory().selectClass(null, oWLModel, collection);
    }

    public static RDFSClass pickConcreteClass(OWLModel oWLModel, Collection collection, String string) {
        return ProtegeUI.getSelectionDialogFactory().selectClass(null, oWLModel, collection, string);
    }

    public static Collection pickRDFProperties(Collection collection, String string) {
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        OWLModel oWLModel = ((RDFResource)collection.iterator().next()).getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection(null, oWLModel, collection, string);
    }

    public static RDFProperty pickRDFProperty(Collection collection, String string) {
        if (collection.isEmpty()) {
            return null;
        }
        OWLModel oWLModel = ((RDFResource)collection.iterator().next()).getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectProperty(null, oWLModel, collection, string);
    }

    public static RDFResource pickRDFResource(Collection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        OWLModel oWLModel = ((RDFResource)collection.iterator().next()).getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectResourceByType(null, oWLModel, collection);
    }

    public static Collection pickRDFResources(Collection collection) {
        return OWLUI.pickRDFResources(collection, true);
    }

    public static Collection pickRDFResources(Collection collection, boolean bl) {
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        OWLModel oWLModel = ((RDFResource)collection.iterator().next()).getOWLModel();
        if (bl) {
            return ProtegeUI.getSelectionDialogFactory().selectResourcesByType(null, oWLModel, collection);
        }
        RDFResource rDFResource = ProtegeUI.getSelectionDialogFactory().selectResourceByType(null, oWLModel, collection);
        if (rDFResource == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singleton(rDFResource);
    }

    public static RDFResource pickRDFResourceFromCollection(Collection collection, String string) {
        if (collection.isEmpty()) {
            return null;
        }
        OWLModel oWLModel = ((RDFResource)collection.iterator().next()).getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(null, oWLModel, collection, string);
    }

    public static RDFSNamedClass pickRDFSNamedClass(OWLModel oWLModel, String string) {
        return ProtegeUI.getSelectionDialogFactory().selectClass(null, oWLModel, string);
    }

    public static RDFSNamedClass pickRDFSNamedClass(OWLModel oWLModel, Collection collection, String string) {
        return ProtegeUI.getSelectionDialogFactory().selectClass(null, oWLModel, collection, string);
    }

    public static Collection pickRDFSNamedClasses(OWLModel oWLModel, String string) {
        return ProtegeUI.getSelectionDialogFactory().selectClasses(null, oWLModel, string);
    }

    public static OWLNamedClass pickOWLNamedClass(OWLModel oWLModel, Collection collection, String string) {
        RDFSNamedClass rDFSNamedClass = ProtegeUI.getSelectionDialogFactory().selectClass(null, oWLModel, collection, string);
        if (rDFSNamedClass instanceof OWLNamedClass) {
            return (OWLNamedClass)rDFSNamedClass;
        }
        return null;
    }

    public static Component searchComponentOfType(Container container, Class clazz) {
        if (clazz.isAssignableFrom(container.getClass())) {
            return container;
        }
        if (container.getComponents().length > 0) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = OWLUI.searchComponentOfType((Container)componentArray[i], clazz);
                if (component == null) continue;
                return component;
            }
        }
        return null;
    }

    public static void setConstraintChecking(OWLModel oWLModel, boolean bl) {
        oWLModel.getOWLProject().getSettingsMap().setBoolean(CONSTRAINT_CHECKING, bl);
    }

    public static void setDragAndDropSupported(OWLModel oWLModel, boolean bl) {
        if (bl) {
            oWLModel.getOWLProject().getSettingsMap().remove(DRAG_AND_DROP);
        } else {
            oWLModel.getOWLProject().getSettingsMap().setBoolean(DRAG_AND_DROP, Boolean.FALSE);
        }
    }

    public static void setExternalResourcesSupported(OWLModel oWLModel, boolean bl) {
        if (bl) {
            oWLModel.getOWLProject().getSettingsMap().setBoolean(EXTERNAL_RESOURCES, Boolean.TRUE);
        } else {
            oWLModel.getOWLProject().getSettingsMap().remove(EXTERNAL_RESOURCES);
        }
    }

    public static void setOWLToolTipGenerator(OWLToolTipGenerator oWLToolTipGenerator) {
        toolTipGenerator = oWLToolTipGenerator;
    }

    public static void showErrorMessageDialog(String string) {
        OWLUI.showErrorMessageDialog((Project)null, string);
    }

    public static void showErrorMessageDialog(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, "Error", 0);
    }

    public static void showErrorMessageDialog(Project project, String string) {
        ProtegeUI.getModalDialogFactory().showMessageDialog((OWLModel)project.getKnowledgeBase(), string);
    }

    public static void showErrorMessageDialog(OWLModel oWLModel, String string) {
        ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, string);
    }

    public static void showErrorMessageDialog(String string, String string2) {
        ProtegeUI.getModalDialogFactory().showMessageDialog((OWLModel)null, string, string2);
    }

    public static void showErrorMessageDialog(Project project, String string, String string2) {
        ProtegeUI.getModalDialogFactory().showMessageDialog((OWLModel)project.getKnowledgeBase(), string, string2);
    }

    public static void showMessageDialog(String string) {
        ProtegeUI.getModalDialogFactory().showMessageDialog((OWLModel)null, string);
    }

    public static void showMessageDialog(Component component, String string) {
        ProtegeUI.getModalDialogFactory().showMessageDialog(component, string);
    }

    public static void showMessageDialog(OWLModel oWLModel, String string) {
        ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, string);
    }

    public static void showMessageDialog(Project project, String string) {
        OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
        ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, string);
    }

    public static void showMessageDialog(String string, String string2, int n) {
        ProtegeUI.getModalDialogFactory().showMessageDialog((OWLModel)null, string, string2);
    }

    public static void showMessageDialog(OWLModel oWLModel, String string, String string2, int n) {
        ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, string, string2);
    }

    public static void showMessageDialog(Project project, String string, String string2, int n) {
        ProtegeUI.getModalDialogFactory().showMessageDialog((OWLModel)project.getKnowledgeBase(), string, string2);
    }

    public static boolean showConfirmDialog(String string, String string2) {
        return ProtegeUI.getModalDialogFactory().showConfirmDialog((OWLModel)null, string, string2);
    }

    public static boolean showConfirmDialog(Project project, String string, String string2) {
        OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
        return ProtegeUI.getModalDialogFactory().showConfirmDialog(oWLModel, string, string2);
    }

    public static boolean isUnsuitableTab(String string) {
        return unsuitableTabs.contains(string);
    }

    public static Collection getPathsToRoot(RDFResource rDFResource) {
        return OWLUI.getPathsToRoot(rDFResource, null);
    }

    public static Collection getPathsToRoot(RDFResource rDFResource, Slot slot) {
        return OWLUI.getPathsToRoot(rDFResource, slot, null);
    }

    public static Collection getPathsToRoot(RDFResource rDFResource, Slot slot, Class clazz) {
        if (slot == null) {
            slot = rDFResource.getOWLModel().getSlot(":DIRECT-SUPERCLASSES");
        }
        if (clazz == null) {
            clazz = RDFResource.class;
        }
        ArrayList arrayList = new ArrayList();
        OWLUI.getPathsToRoot(rDFResource, slot, clazz, new LinkedList(), arrayList);
        return arrayList;
    }

    private static void getPathsToRoot(RDFResource rDFResource, Slot slot, Class clazz, List list, Collection collection) {
        list.add(0, rDFResource);
        OWLNamedClass oWLNamedClass = rDFResource.getOWLModel().getOWLThingClass();
        List list2 = rDFResource.getDirectOwnSlotValues(slot);
        for (Frame frame : list2) {
            ArrayList<Frame> arrayList;
            if (frame.equals(oWLNamedClass)) {
                arrayList = new ArrayList<Frame>(list);
                arrayList.add(0, frame);
                collection.add(arrayList);
                continue;
            }
            if (list.contains(frame) || !ModelUtilities.isVisibleInGUI((Frame)frame) || !clazz.isInstance(frame)) continue;
            arrayList = new ArrayList(list);
            OWLUI.getPathsToRoot((RDFResource)frame, slot, clazz, arrayList, collection);
        }
    }

    public static boolean setSelectedNodeInTree(SelectableTree selectableTree, RDFResource rDFResource) {
        return OWLUI.setSelectedNodeInTree(selectableTree, rDFResource, null);
    }

    public static boolean setSelectedNodeInTree(SelectableTree selectableTree, RDFResource rDFResource, Slot slot) {
        return OWLUI.setSelectedNodeInTree(selectableTree, rDFResource, slot, null);
    }

    public static boolean setSelectedNodeInTree(SelectableTree selectableTree, RDFResource rDFResource, Slot slot, Class clazz) {
        boolean bl = false;
        if (clazz == null) {
            clazz = RDFResource.class;
        }
        if (!selectableTree.getSelection().contains(rDFResource)) {
            if (clazz.isInstance(rDFResource)) {
                Collection collection = OWLUI.getPathsToRoot(rDFResource);
                TreePath[] treePathArray = new TreePath[collection.size()];
                int n = 0;
                for (List list : collection) {
                    TreePath treePath = OWLUI.getTreePath((JTree)selectableTree, list);
                    if (treePath != null) {
                        treePathArray[n] = treePath;
                    }
                    ++n;
                }
                if (treePathArray.length > 0) {
                    selectableTree.scrollPathToVisible(treePathArray[0]);
                    selectableTree.updateUI();
                    bl = true;
                }
                selectableTree.setSelectionPaths(treePathArray);
            } else {
                List list = ModelUtilities.getPathToRoot((Cls)((Cls)rDFResource));
                if (list.size() > 0) {
                    bl = true;
                }
                ComponentUtilities.setSelectedObjectPath((JTree)selectableTree, (Collection)list);
            }
        }
        return bl;
    }

    public static TreePath getTreePath(JTree jTree, Collection collection) {
        LinkedList<LazyTreeNode> linkedList = new LinkedList<LazyTreeNode>();
        LazyTreeNode lazyTreeNode = (LazyTreeNode)jTree.getModel().getRoot();
        linkedList.add(lazyTreeNode);
        for (Object e : collection) {
            if ((lazyTreeNode = ComponentUtilities.getChildNode((LazyTreeNode)lazyTreeNode, e)) == null) {
                return null;
            }
            linkedList.add(lazyTreeNode);
        }
        return new TreePath(linkedList.toArray());
    }

    public static void fixBrowserSlotPatterns(Project project) {
        Collection collection = project.getClsesWithDirectBrowserSlots();
        for (Cls cls : collection) {
            OWLUI.fixBrowserSlotPattern(project, cls);
        }
    }

    public static OWLBrowserSlotPattern fixBrowserSlotPattern(Project project, Cls cls) {
        if (cls == null) {
            return null;
        }
        BrowserSlotPattern browserSlotPattern = project.getBrowserSlotPattern(cls);
        if (browserSlotPattern == null) {
            return null;
        }
        OWLBrowserSlotPattern oWLBrowserSlotPattern = null;
        if (browserSlotPattern instanceof OWLBrowserSlotPattern) {
            oWLBrowserSlotPattern = (OWLBrowserSlotPattern)browserSlotPattern;
        } else {
            oWLBrowserSlotPattern = new OWLBrowserSlotPattern(browserSlotPattern);
            cls.setDirectBrowserSlotPattern((BrowserSlotPattern)oWLBrowserSlotPattern);
        }
        return oWLBrowserSlotPattern;
    }

    static {
        lastConnectFailureTime = -1L;
        CONNECT_NOTIFICATION_TIMEOUT = 30000L;
        unsuitableTabs = new HashSet();
        unsuitableTabs.add(ClsesTab.class.getName());
        unsuitableTabs.add(SlotsTab.class.getName());
        unsuitableTabs.add(InstancesTab.class.getName());
    }
}

