/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.URLWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.net.URI;
import java.util.Collection;

public class ExternalResourceURLWidget
extends URLWidget {
    public void commitChanges() {
        if (this.getInvalidTextDescription(this.getText()) == null) {
            super.commitChanges();
        }
    }

    protected String getInvalidTextDescription(String string) {
        try {
            if (string.startsWith("http://") || string.startsWith("file:") || string.startsWith("mailto:") || string.startsWith("urn:")) {
                new URI(string);
                if (this.isDuplicateURL(string)) {
                    return "This URL is already used elsewhere.\nPlease reuse the existing untyped resource.";
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Not a valid URI, such as http://protege.stanford.edu";
    }

    public Collection getValues() {
        String string = this.getText();
        if (this.getInvalidTextDescription(string) == null) {
            return super.getValues();
        }
        return this.getInstance().getDirectOwnSlotValues(this.getSlot());
    }

    private boolean isDuplicateURL(String string) {
        Frame frame = this.getKnowledgeBase().getFrame(string);
        return frame != null && !this.getInstance().equals(frame);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        if (cls.getKnowledgeBase() instanceof OWLModel) {
            return URLWidget.isSuitable((Cls)cls, (Slot)slot, (Facet)facet);
        }
        return false;
    }
}

