/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestLibrary;
import edu.stanford.smi.protegex.owl.testing.OWLTestManager;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestSettingsTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class OWLTestSettingsPanel
extends JPanel {
    private JCheckBox automaticTestCheckBox;
    private JTable table;
    private OWLTestSettingsTableModel tableModel;

    public OWLTestSettingsPanel(final OWLTestManager oWLTestManager) {
        this.tableModel = new OWLTestSettingsTableModel(oWLTestManager);
        this.table = new JTable(this.tableModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                return OWLTestSettingsPanel.this.getDocumentationOfTestAt(mouseEvent.getY());
            }
        };
        this.table.setToolTipText("");
        LabeledComponent labeledComponent = new LabeledComponent("Available Tests", new JScrollPane(this.table));
        labeledComponent.setPreferredSize(new Dimension(600, 400));
        this.table.getColumnModel().getColumn(0).setMaxWidth(80);
        this.automaticTestCheckBox = new JCheckBox("Repair continuously", oWLTestManager.isAutoRepairEnabled());
        this.automaticTestCheckBox.setToolTipText("<HTML>If activated, then all repairable tests will be executed after each relevant change (until now: Only for changes in property characteristics).</HTML>");
        this.automaticTestCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                oWLTestManager.setAutoRepairEnabled(OWLTestSettingsPanel.this.automaticTestCheckBox.isSelected());
            }
        });
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)labeledComponent);
        this.add("South", this.automaticTestCheckBox);
    }

    private String getDocumentationOfTestAt(int n) {
        int n2 = n / this.table.getRowHeight();
        if (n2 >= 0 && n2 < this.tableModel.getRowCount() && !this.tableModel.isSeparator(n2)) {
            Class clazz = this.tableModel.getOWLTestClass(n2);
            OWLTest oWLTest = OWLTestLibrary.getOWLTest(clazz);
            String string = oWLTest.getDocumentation();
            return string;
        }
        return null;
    }

    public static void showOWLTestSettingsDialog(OWLModel oWLModel) {
        OWLTestSettingsPanel oWLTestSettingsPanel = new OWLTestSettingsPanel(oWLModel);
        ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(oWLModel.getProject()), oWLTestSettingsPanel, "Test Settings", 14);
    }
}

