/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.AbstractTask;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.testing.OWLModelTest;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestManager;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class AbstractOWLTestAction
extends AbstractAction {
    protected OWLModel owlModel;
    protected OWLTestManager testManager;

    public AbstractOWLTestAction() {
    }

    public AbstractOWLTestAction(OWLModel oWLModel, OWLTestManager oWLTestManager, String string, Icon icon) {
        super(string, icon);
        this.owlModel = oWLModel;
        this.testManager = oWLTestManager;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLTest[] oWLTestArray = this.getOWLTests();
        if (oWLTestArray.length == 0) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "There are no tests activated.");
        } else if (!OWLUI.isConfirmationNeeded(this.owlModel) || OWLUI.isConfirmed(this.owlModel, this.owlModel.getRDFResourceCount() > OWLUI.getConfirmationThreshold(this.owlModel))) {
            this.performAction(oWLTestArray);
        }
    }

    private void performAction(final OWLTest[] oWLTestArray) {
        AbstractTask abstractTask = new AbstractTask("Running Tests", true, this.owlModel.getTaskManager()){

            public void runTask() throws Exception {
                List list = AbstractOWLTestAction.this.run(oWLTestArray, this);
                if (list.isEmpty()) {
                    AbstractOWLTestAction.this.showAllTestsPassedMessage(oWLTestArray.length);
                }
                AbstractOWLTestAction.this.showResults(list, AbstractOWLTestAction.this.owlModel);
            }
        };
        try {
            this.owlModel.getTaskManager().run(abstractTask);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }

    protected OWLTest[] getOWLTests() {
        return this.testManager.getOWLTests();
    }

    protected OWLTestResultsPanel getTestResultsPanel(OWLModel oWLModel, List list) {
        return new OWLTestResultsPanel(oWLModel, list, null, true);
    }

    protected abstract List run(OWLTest[] var1, Task var2);

    protected void runOWLClsTest(List list, RDFSClassTest rDFSClassTest) {
        Collection collection = ((AbstractOWLModel)this.owlModel).getOWLSystemResources();
        for (RDFSClass rDFSClass : this.owlModel.getRDFSClasses()) {
            if (collection.contains(rDFSClass)) continue;
            list.addAll(rDFSClassTest.test(rDFSClass));
        }
    }

    protected void runOWLInstanceTest(List list, RDFResourceTest rDFResourceTest) {
        Collection collection = ((AbstractOWLModel)this.owlModel).getOWLSystemResources();
        for (RDFResource rDFResource : this.owlModel.getRDFSClasses()) {
            if (collection.contains(rDFResource)) continue;
            list.addAll(rDFResourceTest.test(rDFResource));
        }
        for (RDFResource rDFResource : this.owlModel.getUserDefinedOWLProperties()) {
            list.addAll(rDFResourceTest.test(rDFResource));
        }
        for (RDFResource rDFResource : this.owlModel.getOWLIndividuals()) {
            list.addAll(rDFResourceTest.test(rDFResource));
        }
    }

    protected void runOWLModelTest(List list, OWLModelTest oWLModelTest) {
        list.addAll(oWLModelTest.test(this.owlModel));
    }

    protected void runOWLPropertyTest(List list, RDFPropertyTest rDFPropertyTest) {
        for (OWLProperty oWLProperty : this.owlModel.getUserDefinedOWLProperties()) {
            list.addAll(rDFPropertyTest.test(oWLProperty));
        }
    }

    protected void showAllTestsPassedMessage(int n) {
    }

    public void showResults(List list, OWLModel oWLModel) {
        OWLTestResultsPanel oWLTestResultsPanel = this.getTestResultsPanel(oWLModel, list);
        ResultsPanelManager.addResultsPanel(oWLModel, oWLTestResultsPanel, true);
    }
}

