/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindResultsView;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.RetainFindResultsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindResultsPanel
extends JComponent {
    private static final String SEARCH_AS_YOU_TYPE_LABEL = "Search as you type";
    private static final String SEARCH_PATTERN_LABEL = "Search Pattern";
    private static final String SAVE_RESULTS_LABEL = "Save Results";
    private Find find;
    private JButton saveResultButton;
    private JComboBox searchTypeCombo;
    private JTextField textField;
    private JCheckBox searchAsYouTypeCheckbox;
    private JPanel mainPanel;
    private AbstractFindResultsView view;
    private static boolean searchAsYouType = true;
    private DocumentListener searchAsYouTypeListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent documentEvent) {
            FindResultsPanel.this.refresh();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FindResultsPanel.this.refresh();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            FindResultsPanel.this.refresh();
        }
    };
    private Action saveResultsAction = new AbstractAction("Save Results", Icons.getDownIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            FindResultsPanel.this.view.requestDispose();
            FindResultsPanel.this.setSaveResultsEnabled(false);
            RetainFindResultsPanel retainFindResultsPanel = new RetainFindResultsPanel(FindResultsPanel.this.find.getModel(), FindResultsPanel.this);
            ResultsPanelManager.addResultsPanel(FindResultsPanel.this.find.getModel(), retainFindResultsPanel, true);
        }
    };

    public FindResultsPanel(Find find, AbstractFindResultsView abstractFindResultsView) {
        this.setLayout(new BorderLayout());
        this.find = find;
        this.view = abstractFindResultsView;
        this.textField = this.createTextField();
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                FindResultsPanel.this.requestFocus();
            }
        });
        abstractFindResultsView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    FindResultsPanel.this.selectResource();
                }
            }
        });
        abstractFindResultsView.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        keyEvent.consume();
                    }
                    case 32: {
                        FindResultsPanel.this.selectResource();
                        break;
                    }
                    default: {
                        if (keyEvent.isActionKey()) break;
                        FindResultsPanel.this.requestFocus();
                    }
                }
            }
        });
        this.searchTypeCombo = this.createTypeCombo();
        this.searchAsYouTypeCheckbox = this.createSearchAsYouType();
        this.refreshSearchAsYouType();
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(SEARCH_PATTERN_LABEL));
        jPanel.add(this.searchTypeCombo);
        jPanel.add(this.textField);
        jPanel.add(this.searchAsYouTypeCheckbox);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)abstractFindResultsView, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    public void setSearcher(Find find) {
        this.find = find;
    }

    public void setSaveResultsEnabled(boolean bl) {
        if (bl) {
            if (this.saveResultButton == null) {
                this.saveResultButton = new JButton(this.saveResultsAction);
                this.mainPanel.add((Component)this.saveResultButton, "South");
            }
        } else if (this.saveResultButton != null) {
            this.mainPanel.remove(this.saveResultButton);
            this.saveResultButton = null;
        }
    }

    public void refresh() {
        this.refresh(this.find.getSearchType());
    }

    public void refresh(int n) {
        String string = this.textField.getText();
        this.find.cancelSearch();
        this.find.startSearch(string, n);
    }

    public void selectResource() {
        this.view.selectResource();
        this.find.cancelSearch();
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    private JTextField createTextField() {
        JTextField jTextField = new JTextField();
        FontMetrics fontMetrics = this.getFontMetrics(jTextField.getFont());
        int n = fontMetrics.getHeight() + fontMetrics.getDescent();
        jTextField.setPreferredSize(new Dimension(120, n));
        jTextField.setText(this.find.getLastSearch());
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        if (!searchAsYouType) {
                            FindResultsPanel.this.refresh();
                        }
                    }
                    case 40: {
                        FindResultsPanel.this.view.requestFocus();
                    }
                }
            }
        });
        return jTextField;
    }

    private JComboBox createTypeCombo() {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                object = Find.searchTypeString[(Integer)object];
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        jComboBox.addItem(new Integer(1));
        jComboBox.addItem(new Integer(0));
        jComboBox.addItem(new Integer(2));
        jComboBox.addItem(new Integer(3));
        jComboBox.setSelectedItem(new Integer(this.find.getSearchType()));
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = (Integer)itemEvent.getItem();
                int n2 = FindResultsPanel.this.find.getSearchType();
                if (n2 != n) {
                    FindResultsPanel.this.refresh(n);
                }
            }
        });
        return jComboBox;
    }

    private JCheckBox createSearchAsYouType() {
        JCheckBox jCheckBox = new JCheckBox(new AbstractAction(SEARCH_AS_YOU_TYPE_LABEL){

            public void actionPerformed(ActionEvent actionEvent) {
                FindResultsPanel.this.refreshSearchAsYouType();
            }
        });
        jCheckBox.setSelected(searchAsYouType);
        return jCheckBox;
    }

    private void refreshSearchAsYouType() {
        searchAsYouType = this.searchAsYouTypeCheckbox.isSelected();
        if (searchAsYouType) {
            this.textField.getDocument().addDocumentListener(this.searchAsYouTypeListener);
        } else {
            this.textField.getDocument().removeDocumentListener(this.searchAsYouTypeListener);
        }
    }
}

