/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.results;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.StatusBar;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.results.TripleDisplay;
import edu.stanford.smi.protegex.owl.ui.results.TripleDisplayUtil;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class ResultsPanelManager {
    public static void addResultsPanel(ResultsPanel resultsPanel, boolean bl) {
        ResultsPanelManager.addResultsPanel(null, resultsPanel, bl);
    }

    public static void addResultsPanel(OWLModel oWLModel, ResultsPanel resultsPanel, boolean bl) {
        JTabbedPane jTabbedPane;
        if (bl && (jTabbedPane = ResultsPanelManager.getTabbedPane(oWLModel)) != null) {
            for (int i = jTabbedPane.getTabCount() - 1; i >= 0; --i) {
                ResultsPanel resultsPanel2 = (ResultsPanel)jTabbedPane.getComponentAt(i);
                if (resultsPanel == resultsPanel2) {
                    jTabbedPane.setSelectedIndex(i);
                    return;
                }
                if (!resultsPanel2.isReplaceableBy(resultsPanel)) continue;
                jTabbedPane.remove(i);
                jTabbedPane.insertTab(resultsPanel.getTabName(), resultsPanel.getIcon(), resultsPanel, null, i);
                jTabbedPane.setSelectedIndex(i);
                return;
            }
        }
        ResultsPanelManager.addResultsPanelToEnd(oWLModel, resultsPanel);
    }

    private static void addResultsPanelToEnd(OWLModel oWLModel, ResultsPanel resultsPanel) {
        JSplitPane jSplitPane = ResultsPanelManager.getSplitPane(oWLModel);
        if (jSplitPane == null) {
            ProjectView projectView = ProtegeUI.getProjectView(oWLModel.getProject());
            Component component = projectView.getComponent(0);
            if (component instanceof StatusBar) {
                component = projectView.getComponent(1);
            }
            JTabbedPane jTabbedPane = new JTabbedPane(3);
            jTabbedPane.addTab(resultsPanel.getTabName(), resultsPanel.getIcon(), resultsPanel);
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
            jSplitPane = new JSplitPane(0, component, jTabbedPane);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(component.getHeight() - 180);
            projectView.add("Center", (Component)jSplitPane);
            ResultsPanelManager.revalidate(projectView);
        } else {
            JTabbedPane jTabbedPane = ResultsPanelManager.getTabbedPane(oWLModel);
            jTabbedPane.addTab(resultsPanel.getTabName(), resultsPanel.getIcon(), resultsPanel);
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        }
    }

    public static void closeResultsPanel(ResultsPanel resultsPanel) {
        ResultsPanelManager.closeResultsPanel(null, resultsPanel);
    }

    public static void closeResultsPanel(OWLModel oWLModel, ResultsPanel resultsPanel) {
        Container container = resultsPanel;
        while (!(container instanceof JTabbedPane)) {
            container = container.getParent();
        }
        JTabbedPane jTabbedPane = (JTabbedPane)container;
        jTabbedPane.remove(resultsPanel);
        resultsPanel.dispose();
        if (jTabbedPane.getTabCount() == 0) {
            JSplitPane jSplitPane = ResultsPanelManager.getSplitPane(oWLModel);
            Component component = jSplitPane.getLeftComponent();
            ProjectView projectView = ProtegeUI.getProjectView(jTabbedPane);
            projectView.remove((Component)jSplitPane);
            projectView.add("Center", component);
            ResultsPanelManager.revalidate(projectView);
        }
    }

    public static ResultsPanel getResultsPanelByName(String string) {
        return ResultsPanelManager.getResultsPanelByName(null, string);
    }

    public static ResultsPanel getResultsPanelByName(OWLModel oWLModel, String string) {
        JTabbedPane jTabbedPane = ResultsPanelManager.getTabbedPane(oWLModel);
        if (jTabbedPane != null) {
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                ResultsPanel resultsPanel = (ResultsPanel)jTabbedPane.getComponentAt(i);
                if (!string.equals(resultsPanel.getTabName())) continue;
                return resultsPanel;
            }
        }
        return null;
    }

    public static JSplitPane getSplitPane(OWLModel oWLModel) {
        ProjectView projectView = ProtegeUI.getProjectView(oWLModel != null ? oWLModel.getProject() : null);
        for (int i = 0; i < projectView.getComponentCount(); ++i) {
            Component component = projectView.getComponent(i);
            if (!(component instanceof JSplitPane)) continue;
            return (JSplitPane)component;
        }
        return null;
    }

    public static JTabbedPane getTabbedPane(OWLModel oWLModel) {
        JSplitPane jSplitPane = ResultsPanelManager.getSplitPane(oWLModel);
        if (jSplitPane != null && jSplitPane.getComponentCount() > 1) {
            return (JTabbedPane)jSplitPane.getComponent(1);
        }
        return null;
    }

    private static void revalidate(ProjectView projectView) {
        projectView.getParent().invalidate();
        projectView.getParent().validate();
    }

    public static void setSelectedResultsPanel(OWLModel oWLModel, ResultsPanel resultsPanel) {
        ResultsPanelManager.getTabbedPane(oWLModel).setSelectedComponent(resultsPanel);
    }

    public static void showHostInstance(Instance instance) {
        if (instance instanceof RDFResource) {
            ResultsPanelManager.showHostResource((RDFResource)instance);
        }
    }

    public static void showHostResource(RDFResource rDFResource) {
        JSplitPane jSplitPane = ResultsPanelManager.getSplitPane(rDFResource.getOWLModel());
        JTabbedPane jTabbedPane = null;
        if (jSplitPane != null) {
            jTabbedPane = (JTabbedPane)jSplitPane.getLeftComponent();
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                Component component = jTabbedPane.getComponentAt(i);
                if (!(component instanceof HostResourceDisplay) || !((HostResourceDisplay)((Object)component)).displayHostResource(rDFResource)) continue;
                jTabbedPane.setSelectedComponent(component);
                ((JComponent)component).requestFocusInWindow();
                return;
            }
        }
        rDFResource.getProject().show((Instance)rDFResource);
    }

    public static TripleDisplay showTriple(Triple triple) {
        RDFResource rDFResource = triple.getSubject();
        JSplitPane jSplitPane = ResultsPanelManager.getSplitPane(rDFResource.getOWLModel());
        JTabbedPane jTabbedPane = null;
        if (jSplitPane != null) {
            jTabbedPane = (JTabbedPane)jSplitPane.getLeftComponent();
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                Component component = jTabbedPane.getComponentAt(i);
                TripleDisplay tripleDisplay = TripleDisplayUtil.displayTriple(component, triple);
                if (tripleDisplay == null) continue;
                jTabbedPane.setSelectedComponent(component);
                ((JComponent)component).requestFocusInWindow();
                return tripleDisplay;
            }
        }
        ResultsPanelManager.showHostResource(rDFResource);
        return null;
    }
}

