/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourceselection;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextField;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class ResourceFilterListModel
extends AbstractListModel
implements ComboBoxModel {
    private Frame[] frames;
    private String prefix = "";
    private Frame selectedFrame;
    private int validStart = 0;
    private int validCount;

    public ResourceFilterListModel(Collection collection) {
        this.frames = collection.toArray(new Frame[0]);
        Arrays.sort(this.frames, new ResourceIgnoreCaseComparator());
        this.validCount = this.frames.length;
        if (collection.size() > 0) {
            this.selectedFrame = this.frames[0];
        }
    }

    public void addChar(char c) {
        if (OWLTextField.isIdChar(c)) {
            this.prefix = this.prefix + Character.toLowerCase(c);
            this.updateList();
        }
    }

    public void backspace() {
        int n = this.prefix.length();
        if (n > 0) {
            this.prefix = this.prefix.substring(0, n - 1);
            this.updateList();
        }
    }

    protected int findFirstMatchingFrame() {
        for (int i = 0; i < this.frames.length; ++i) {
            Frame frame = this.frames[i];
            String string = frame.getBrowserText();
            if (!string.toLowerCase().startsWith(this.prefix)) continue;
            return i;
        }
        return 0;
    }

    private int findMatchingFrameCount(int n) {
        for (int i = n; i < this.frames.length; ++i) {
            Frame frame = this.frames[i];
            String string = frame.getBrowserText();
            if (string.toLowerCase().startsWith(this.prefix)) continue;
            return i - n;
        }
        return this.frames.length - n;
    }

    public Object getElementAt(int n) {
        return this.frames[n + this.validStart];
    }

    public int getPrefixLength() {
        return this.prefix.length();
    }

    public Object getSelectedItem() {
        return this.selectedFrame;
    }

    public int getSize() {
        return this.validCount;
    }

    public void setSelectedItem(Object object) {
        if (object instanceof Frame && (this.selectedFrame != null && this.selectedFrame != object || this.selectedFrame == null && object != null)) {
            this.selectedFrame = (Frame)object;
        }
    }

    private void updateList() {
        this.validCount = 0;
        this.fireIntervalRemoved(this, 0, this.validCount);
        if (this.prefix.length() > 0) {
            this.validStart = this.findFirstMatchingFrame();
            this.validCount = this.findMatchingFrameCount(this.validStart);
        } else {
            this.validStart = 0;
            this.validCount = this.frames.length;
        }
        this.selectedFrame = this.validCount > 0 ? this.frames[this.validStart] : null;
        this.fireIntervalAdded(this, 0, this.validCount);
    }
}

