/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.widget.FormsTab;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLFormsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;

public class EditTypeFormAction
extends AbstractAction {
    private RDFResource resource;

    public EditTypeFormAction(RDFResource rDFResource) {
        super("Edit form of type...", OWLIcons.getImageIcon("EditTypeForm"));
        this.resource = rDFResource;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (EditTypeFormAction.ensureMetaClsVisible(this.resource)) {
            RDFSClass rDFSClass = this.resource.getProtegeType();
            ProjectView projectView = ProtegeUI.getProjectView(rDFSClass.getProject());
            JTabbedPane jTabbedPane = new JTabbedPane();
            Component[] componentArray = projectView.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!(component instanceof JTabbedPane)) continue;
                jTabbedPane = (JTabbedPane)component;
            }
            FormsTab formsTab = (FormsTab)projectView.getTabByClassName(OWLFormsTab.class.getName());
            if (formsTab == null) {
                formsTab = (FormsTab)projectView.getTabByClassName(FormsTab.class.getName());
            }
            if (formsTab != null) {
                jTabbedPane.setSelectedComponent((Component)formsTab);
                formsTab.setSelectedCls((Cls)rDFSClass);
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.resource.getOWLModel(), "The Forms tab is not visible.\nPlease use Project/Configure...");
            }
        }
    }

    static boolean ensureMetaClsVisible(RDFResource rDFResource) {
        RDFSClass rDFSClass = rDFResource.getProtegeType();
        RDFSNamedClass rDFSNamedClass = rDFResource.getOWLModel().getRDFPropertyClass();
        OWLModel oWLModel = rDFResource.getOWLModel();
        if (!rDFSClass.isVisible() || rDFSClass.isSubclassOf(rDFSNamedClass) && !rDFSNamedClass.isVisible()) {
            String string = "The class " + rDFSClass.getBrowserText() + " is not visible.\nShould it be made visible now?";
            if (ProtegeUI.getModalDialogFactory().showConfirmDialog(oWLModel, string, "Confirm")) {
                if (rDFSClass.getName().equals("owl:Class")) {
                    oWLModel.getRDFSNamedClassClass().setVisible(true);
                }
                if (rDFSClass.isSubclassOf(oWLModel.getRDFSNamedClass("rdf:Property"))) {
                    oWLModel.getRDFPropertyClass().setVisible(true);
                    oWLModel.getOWLObjectPropertyClass().setVisible(true);
                    oWLModel.getOWLDatatypePropertyClass().setVisible(true);
                }
                rDFSClass.setVisible(true);
                ProtegeUI.reloadUI(oWLModel.getProject());
                return true;
            }
            return false;
        }
        return true;
    }
}

