/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard.impl;

import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.RelativeFileRepository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.impl.RelativeURLSpecificationWizardPanel;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

public class RelativeFileURLSpecificationWizardPanel
extends RelativeURLSpecificationWizardPanel {
    private static final String HELP_TEXT = "<p>Please specify a relative <b>URL</b> that points to an ontology file.</p><p>The URL should be relative to the current pprj/owl file.For example if the pprj/owl file is located at /A/B/C/c.owl, the relative URL ../B/b.owl would specify the ontology file with the path /A/B/b.owl<p>Note that the path separator for URLs is the forward slash '/', and spaces must be replaced with \"%20\".</p>";

    public RelativeFileURLSpecificationWizardPanel(WizardPage wizardPage, OWLModel oWLModel) {
        super(wizardPage, oWLModel);
    }

    public Repository createRepository() {
        try {
            File file = RepositoryUtil.getRepositoryFileFromRelativePath(this.getOWLModel(), this.getRelativePath());
            if (file != null) {
                return new RelativeFileRepository(file, this.getRelativePath(), this.isForcedReadOnlySelected());
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        return null;
    }

    protected String getDocumentation() {
        return HELP_TEXT;
    }
}

