/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractLocalRepository;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.repository.AbstractRepositoriesPanel;
import edu.stanford.smi.protegex.owl.ui.repository.RepositoryEntryLabel;
import edu.stanford.smi.protegex.owl.ui.repository.action.RepositoryAction;
import edu.stanford.smi.protegex.owl.ui.repository.action.RepositoryActionManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RepositoryPanel
extends JPanel {
    private OWLModel owlModel;
    private RepositoryManager manager;
    private Repository repository;
    private AbstractRepositoriesPanel manPanel;
    private JComponent entryHolderPanel;
    private Action removeAction;
    private Action bumpUpAction;
    private Action bumpDownAction;
    private JCheckBox forceReadOnlyCheckBox;
    private LabeledComponent lc;
    private boolean collapsed = false;
    private Set importedOntologies;

    public RepositoryPanel(OWLModel oWLModel, RepositoryManager repositoryManager, Repository repository, AbstractRepositoriesPanel abstractRepositoriesPanel) {
        this.owlModel = oWLModel;
        this.manager = repositoryManager;
        this.repository = repository;
        this.manPanel = abstractRepositoriesPanel;
        this.importedOntologies = this.owlModel.getAllImports();
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
        this.entryHolderPanel = new JPanel();
        this.entryHolderPanel.setOpaque(false);
        jPanel.add(this.entryHolderPanel);
        this.lc = new LabeledComponent(repository.getRepositoryDescription(), (Component)jPanel);
        this.entryHolderPanel.setLayout(new BoxLayout(this.entryHolderPanel, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.lc);
        this.removeAction = new AbstractAction("Remove", OWLIcons.getRemoveIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryPanel.this.manager.remove(RepositoryPanel.this.repository);
                RepositoryPanel.this.manPanel.reloadUI();
            }
        };
        this.bumpUpAction = new AbstractAction("Move up", OWLIcons.getUpIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryPanel.this.manager.moveUp(RepositoryPanel.this.repository);
                RepositoryPanel.this.manPanel.reloadUI();
            }
        };
        this.bumpDownAction = new AbstractAction("Move down", OWLIcons.getDownIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryPanel.this.manager.moveDown(RepositoryPanel.this.repository);
                RepositoryPanel.this.manPanel.reloadUI();
            }
        };
        if (this.repository instanceof AbstractLocalRepository && !this.repository.isSystem()) {
            this.forceReadOnlyCheckBox = new JCheckBox("Force Read-Only");
            this.forceReadOnlyCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AbstractLocalRepository abstractLocalRepository = (AbstractLocalRepository)RepositoryPanel.this.repository;
                    abstractLocalRepository.setForceReadOnly(RepositoryPanel.this.forceReadOnlyCheckBox.isSelected());
                }
            });
            this.forceReadOnlyCheckBox.setSelected(((AbstractLocalRepository)this.repository).isForceReadOnly());
            jPanel.add((Component)this.forceReadOnlyCheckBox, "North");
        }
        this.lc.addHeaderButton(this.bumpUpAction);
        this.lc.addHeaderButton(this.bumpDownAction);
        this.lc.addHeaderButton(this.removeAction);
        this.lc.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && new Rectangle(0, 0, 20, 20).contains(mouseEvent.getPoint())) {
                    RepositoryPanel.this.collapsed = !RepositoryPanel.this.collapsed;
                    RepositoryPanel.this.refreshList();
                }
                if (mouseEvent.isPopupTrigger()) {
                    RepositoryPanel.this.showRepositoryActionMenu(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    RepositoryPanel.this.showRepositoryActionMenu(mouseEvent);
                }
            }
        });
        this.lc.setOpaque(false);
        this.removeAction.setEnabled(!this.repository.isSystem());
        this.refreshList();
        this.setNotOpaque(this);
    }

    private void showRepositoryActionMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        RepositoryActionManager repositoryActionManager = RepositoryActionManager.getInstance();
        for (final RepositoryAction repositoryAction : repositoryActionManager.getActions(this.repository, this.owlModel)) {
            jPopupMenu.add(new AbstractAction(repositoryAction.getName()){

                public void actionPerformed(ActionEvent actionEvent) {
                    repositoryAction.actionPerformed(RepositoryPanel.this.repository, RepositoryPanel.this.manPanel, RepositoryPanel.this.owlModel);
                }
            });
        }
        jPopupMenu.show((Component)this.lc, mouseEvent.getX(), mouseEvent.getY());
    }

    private void refreshList() {
        Icon icon;
        this.entryHolderPanel.removeAll();
        UIDefaults uIDefaults = UIManager.getLookAndFeel().getDefaults();
        if (this.collapsed) {
            icon = uIDefaults.getIcon("Tree.collapsedIcon");
        } else {
            icon = uIDefaults.getIcon("Tree.expandedIcon");
            TreeSet treeSet = new TreeSet(this.repository.getOntologies());
            for (URI uRI : treeSet) {
                boolean bl = false;
                if (this.importedOntologies.contains(uRI.toString())) {
                    bl = this.manager.getRepository(uRI) == this.repository;
                }
                this.entryHolderPanel.add(new RepositoryEntryLabel(this.owlModel, uRI, this.repository.getOntologyLocationDescription(uRI), bl));
            }
        }
        this.lc.setHeaderIcon(icon);
        this.setNotOpaque(this);
        this.manPanel.revalidate();
    }

    private void setNotOpaque(JComponent jComponent) {
        jComponent.setOpaque(false);
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof JComponent)) continue;
            this.setNotOpaque((JComponent)component);
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        graphics.setColor(Color.GRAY);
        graphics.drawLine(3, this.getHeight() - 1, this.getWidth() - 3, this.getHeight() - 1);
        graphics.setColor(color);
    }
}

