/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.refactoring;

import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.refactoring.RefactorResourceAction;
import edu.stanford.smi.protegex.owl.ui.refactoring.RenameAcrossFilesPanel;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class RenameAcrossFilesAction
extends RefactorResourceAction {
    private static final String PROPERTY = "RenameAcrossFiles";

    public RenameAcrossFilesAction() {
        super("Rename across files...", OWLIcons.getImageIcon(PROPERTY));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RDFResource rDFResource = this.getResource();
        String string = rDFResource.getOWLModel().getOWLProject().getSettingsMap().getString(PROPERTY);
        String[] stringArray = new String[]{};
        if (string != null) {
            stringArray = string.split(",");
        }
        RenameAcrossFilesPanel renameAcrossFilesPanel = new RenameAcrossFilesPanel(rDFResource, stringArray);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(rDFResource.getProject()), renameAcrossFilesPanel, "Rename " + rDFResource.getName() + " across files...", 11) == 1) {
            Object object;
            Object object2;
            Iterator iterator = renameAcrossFilesPanel.getSelectedFiles();
            String string2 = "";
            while (iterator.hasNext()) {
                object2 = (File)iterator.next();
                object = ((File)object2).getAbsolutePath();
                string2 = string2 + (String)object;
                if (!iterator.hasNext()) continue;
                string2 = string2 + ",";
            }
            rDFResource.getOWLModel().getOWLProject().getSettingsMap().setString(PROPERTY, string2);
            object2 = renameAcrossFilesPanel.getNewName();
            if (!((String)object2).equals(rDFResource.getName())) {
                object = rDFResource.getOWLModel();
                if (object.isValidResourceName((String)object2, rDFResource)) {
                    RenameAcrossFilesAction.performAction(rDFResource, (String)object2, renameAcrossFilesPanel.getSelectedFiles());
                } else {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog((OWLModel)object, "This is not a valid name.");
                }
            }
        }
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        if (rDFResource instanceof RDFResource) {
            return !rDFResource.isSystem() && !rDFResource.isAnonymous();
        }
        return false;
    }

    public static void performAction(RDFResource rDFResource, String string, Iterator iterator) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        String string2 = rDFResource.getURI();
        rDFResource.setName(string);
        String string3 = rDFResource.getURI();
        ModalProgressBarManager modalProgressBarManager = new ModalProgressBarManager("Renaming across files...");
        modalProgressBarManager.setProgressValue(0.0);
        Set set = Jena.set(iterator);
        int n = 0;
        modalProgressBarManager.start();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (Iterator iterator2 : set) {
            modalProgressBarManager.setProgressText(((File)((Object)iterator2)).getAbsolutePath());
            modalProgressBarManager.setProgressValue((double)n / (double)set.size());
            System.out.println("[RenameAcrossFilesAction] " + iterator2);
            try {
                RenameAcrossFilesAction.performAction(rDFResource.getProject(), iterator2, string2, string3, hashSet);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                hashSet2.add(iterator2);
            }
            ++n;
        }
        modalProgressBarManager.stop();
        Object object = "";
        if (hashSet.isEmpty()) {
            object = (String)object + "No files were changed.\n";
        } else {
            object = (String)object + "The following files were changed:\n";
            for (File file : hashSet) {
                object = (String)object + " - " + file.getAbsolutePath() + "\n";
            }
        }
        if (!hashSet2.isEmpty()) {
            object = (String)object + "The following files had an error:\n";
            for (File file : hashSet2) {
                object = (String)object + " - " + file.getAbsolutePath() + "\n";
            }
        }
        ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "The resource " + string2 + "\nwas renamed to " + string3 + "\n" + (String)object);
    }

    public static void performAction(Project project, File file, String string, String string2, Collection collection) throws IOException {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntDocumentManager ontDocumentManager = new OntDocumentManager();
        SimpleGraphMaker simpleGraphMaker = (SimpleGraphMaker)((ModelMakerImpl)ontModelSpec.getModelMaker()).getGraphMaker();
        Set set = Jena.set((Iterator)simpleGraphMaker.listGraphs());
        Object object = set.iterator();
        while (object.hasNext()) {
            simpleGraphMaker.removeGraph((String)object.next());
        }
        ontDocumentManager.clearCache();
        object = new File(Jena.getOntPolicyFilePath(project)).toURI().toString() + ";" + new File(new File("etc"), "ont-policy.rdf").toURI().toString();
        ontDocumentManager.setMetadataSearchPath((String)object, true);
        ontModelSpec.setDocumentManager(ontDocumentManager);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, null);
        ontModel.read((InputStream)new FileInputStream(file), "http://www.owl-ontologies.com/unnamed.owl#", "RDF/XML-ABBREV");
        Resource resource = ontModel.getResource(string);
        if (ontModel.contains(resource, null, (RDFNode)null) || ontModel.contains(null, null, (RDFNode)resource) || resource.canAs(Property.class) && ontModel.contains(null, (Property)resource.as(Property.class), (RDFNode)null)) {
            System.out.println("[RenameAcrossFilesAction]   References found, now renaming...");
            Jena.renameResource(ontModel, resource, string2);
            JenaOWLModel.save(file, ontModel, "RDF/XML-ABBREV", ontModel.getNsPrefixURI(""));
            collection.add(file);
        }
    }
}

