/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.query;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.ui.actions.triple.AbstractTripleAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLResultsPanel;

public class QueryTripleAction
extends AbstractTripleAction {
    public QueryTripleAction() {
        super("Copy into SPARQL query area", "SPARQL", OWLIcons.class);
    }

    public boolean isSuitable(Triple triple) {
        if (triple.getObject() instanceof String) {
            String string = (String)triple.getObject();
            return string.trim().toUpperCase().startsWith("SELECT");
        }
        return false;
    }

    public void run(Triple triple) {
        OWLModel oWLModel = triple.getSubject().getOWLModel();
        String string = (String)triple.getObject();
        SPARQLResultsPanel sPARQLResultsPanel = SPARQLOWLModelAction.show(oWLModel, true);
        sPARQLResultsPanel.setQueryText(string);
    }
}

