/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.impl.OperationImpl;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.properties.range.UnionRangeClassesTable;
import edu.stanford.smi.protegex.owl.ui.properties.range.UnionRangeClassesTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.PropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class UnionRangeClassesComponent
extends JComponent {
    private OWLModel owlModel;
    private UnionRangeClassesTable table;
    private UnionRangeClassesTableModel tableModel;
    private ResourceSelectionAction addAction = new ResourceSelectionAction("Specialise Range", OWLIcons.getAddIcon("PrimitiveClass"), true){

        public void resourceSelected(RDFResource rDFResource) {
            Collection collection;
            Object object;
            RDFSClass rDFSClass = (RDFSClass)rDFResource;
            if (rDFSClass.equals(rDFResource.getOWLModel().getOWLThingClass())) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(UnionRangeClassesComponent.this.owlModel, "The class " + rDFSClass.getBrowserText() + " cannot be added to the range.\n" + "Please set the range to empty to get this behavior.", "Invalid Class");
                return;
            }
            RDFProperty rDFProperty = UnionRangeClassesComponent.this.tableModel.getEditedProperty();
            if (!(rDFProperty instanceof OWLProperty) && !ProfilesManager.isFeatureSupported((OWLModel)(object = rDFProperty.getOWLModel()), OWLProfiles.Union_Classes) && (collection = rDFProperty.getUnionRangeClasses()).size() > 0 && rDFProperty.getRange(false) != null) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog((OWLModel)object, "In pure RDF, rdf:Properties can only have one class in their\n(union) range.  You need to select a different language profile.");
                return;
            }
            if (rDFProperty.getSuperpropertyCount() > 0 && (object = UnionRangeClassesComponent.this.getUnionRangeClassesOfSuperproperties()).size() > 0) {
                boolean bl = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    RDFSClass rDFSClass2 = (RDFSClass)iterator.next();
                    if (!rDFSClass2.equals(rDFResource) && !rDFSClass.getSuperclasses(true).contains(rDFSClass2)) continue;
                    bl = true;
                }
                if (!bl) {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(UnionRangeClassesComponent.this.owlModel, "The class " + rDFSClass.getBrowserText() + " cannot be added to the range\n" + "of " + rDFProperty.getBrowserText() + " because it does not narrow the classes\n" + "from the range of its super-properties.");
                    return;
                }
            }
            UnionRangeClassesComponent.this.tableModel.addRow(rDFSClass, UnionRangeClassesComponent.this.table.getSelectedRow());
        }

        public Collection getSelectableResources() {
            Object[] objectArray;
            RDFProperty rDFProperty = UnionRangeClassesComponent.this.tableModel.getEditedProperty();
            Collection<Cls> collection = new HashSet();
            Collection collection2 = rDFProperty.getUnionRangeClasses();
            OWLNamedClass oWLNamedClass = rDFProperty.getOWLModel().getOWLThingClass();
            if (rDFProperty.getSuperpropertyCount() > 0 && !collection2.isEmpty() && !collection2.contains(oWLNamedClass)) {
                for (Cls cls : collection2) {
                    collection.add(cls);
                    collection.addAll(cls.getSubclasses());
                }
                objectArray = rDFProperty.getOWLModel().getSlot(":SLOT-VALUE-TYPE");
                collection.removeAll(rDFProperty.getDirectOwnSlotValues((Slot)objectArray));
            } else {
                collection = OWLUtil.getSelectableNamedClses(UnionRangeClassesComponent.this.owlModel);
                objectArray = UnionRangeClassesComponent.this.tableModel.getEditedCls();
                collection.remove(objectArray);
                collection.removeAll(UnionRangeClassesComponent.this.tableModel.getValues());
            }
            collection.remove(oWLNamedClass);
            objectArray = collection.toArray();
            Arrays.sort(objectArray, new FrameComparator());
            return Arrays.asList(objectArray);
        }

        public Collection pickResources() {
            RDFSNamedClass rDFSNamedClass = UnionRangeClassesComponent.this.owlModel.getRDFSNamedClassClass();
            boolean bl = rDFSNamedClass.isVisible();
            OWLNamedClass oWLNamedClass = UnionRangeClassesComponent.this.owlModel.getOWLNamedClassClass();
            boolean bl2 = oWLNamedClass.isVisible();
            if (!bl && ProfilesManager.isFeatureSupported(UnionRangeClassesComponent.this.owlModel, OWLProfiles.OWL_Full)) {
                rDFSNamedClass.setVisible(true);
                oWLNamedClass.setVisible(true);
            }
            RDFProperty rDFProperty = UnionRangeClassesComponent.this.tableModel.getEditedProperty();
            HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
            hashSet.add(UnionRangeClassesComponent.this.owlModel.getOWLThingClass());
            if (rDFProperty.getSuperpropertyCount() > 0) {
                for (RDFProperty rDFProperty2 : rDFProperty.getSuperproperties(true)) {
                    hashSet.addAll(rDFProperty2.getRanges(false));
                }
                if (hashSet.size() > 1) {
                    hashSet.remove(UnionRangeClassesComponent.this.owlModel.getOWLThingClass());
                }
            }
            Set set = ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)UnionRangeClassesComponent.this.table), UnionRangeClassesComponent.this.owlModel, hashSet, "Select named class(es) to add");
            rDFSNamedClass.setVisible(bl);
            oWLNamedClass.setVisible(bl2);
            return set;
        }
    };
    private Action createAction = new AbstractAction("Specialise Range using OWL expression", OWLIcons.getCreateIcon("OWLAnonymousClass")){

        public void actionPerformed(ActionEvent actionEvent) {
            UnionRangeClassesComponent.this.table.createAndEditRow();
        }
    };
    private OWLTableAction deleteAction = new AbstractOWLTableAction("Remove from Range", OWLIcons.getRemoveIcon("PrimitiveClass")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTableModel oWLTableModel;
            int n = UnionRangeClassesComponent.this.table.getSelectedRow();
            if (n >= 0 && (oWLTableModel = (OWLTableModel)UnionRangeClassesComponent.this.table.getModel()).isCellEditable(n, oWLTableModel.getSymbolColumnIndex())) {
                oWLTableModel.deleteRow(n);
                UnionRangeClassesComponent.this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            RDFProperty rDFProperty = UnionRangeClassesComponent.this.tableModel.getEditedProperty();
            return rDFSClass != null && UnionRangeClassesComponent.this.tableModel.isDeleteEnabledFor(rDFSClass) && rDFProperty != null && rDFProperty.isEditable();
        }
    };
    private OWLTableAction viewAction = new AbstractOWLTableAction("View class", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            Cls cls = UnionRangeClassesComponent.this.table.getSelectedCls();
            UnionRangeClassesComponent.this.table.getOWLModel().getProject().show((Instance)cls);
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            return rDFSClass instanceof RDFSNamedClass;
        }
    };

    public UnionRangeClassesComponent(OWLModel oWLModel, PropertyWidget propertyWidget) {
        this.owlModel = oWLModel;
        this.tableModel = new UnionRangeClassesTableModel(propertyWidget);
        this.table = new UnionRangeClassesTable(this.tableModel, oWLModel);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        this.table.registerAction(this.viewAction);
        this.table.registerAction(this.deleteAction);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Range  \u2294", jScrollPane, true, false);
        WidgetUtilities.addViewButton(oWLLabeledComponent, this.viewAction);
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.OWL_Lite)) {
            oWLLabeledComponent.addHeaderButton(this.createAction);
        }
        oWLLabeledComponent.addHeaderButton(this.addAction);
        oWLLabeledComponent.addHeaderButton(this.deleteAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    private Collection getUnionRangeClassesOfSuperproperties() {
        HashSet hashSet = new HashSet();
        for (RDFProperty rDFProperty : this.tableModel.getEditedProperty().getSuperproperties(true)) {
            hashSet.addAll(rDFProperty.getUnionRangeClasses());
        }
        return hashSet;
    }

    public void dispose() {
        ((OWLTableModel)this.table.getModel()).dispose();
    }

    public JComponent getComponent() {
        return this;
    }

    public void refill() {
        this.table.hideSymbolPanel();
        this.tableModel.refill();
    }

    public void setEnabled(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.owlModel, (Operation)OperationImpl.PROPERTY_TAB_WRITE);
        RDFProperty rDFProperty = this.tableModel.getEditedProperty();
        if (rDFProperty != null) {
            bl = bl && rDFProperty.isEditable();
        }
        this.addAction.setEnabled(bl);
        this.createAction.setEnabled(bl);
        this.deleteAction.setEnabled(bl);
        super.setEnabled(bl);
    }
}

