/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.properties.range.FacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.OWLRangeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.AssigningTextField;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class StringFacetsPanel
extends FacetsPanel {
    private JTextField patternField;
    private JTextField minLengthField = new AssigningTextField(new AssigningTextField.Assign(){

        public void assign(String string) {
            StringFacetsPanel.this.assignNewType();
        }
    });
    private JTextField maxLengthField;

    public StringFacetsPanel(OWLRangeWidget oWLRangeWidget) {
        super(oWLRangeWidget);
        this.minLengthField.setHorizontalAlignment(4);
        this.maxLengthField = new AssigningTextField(new AssigningTextField.Assign(){

            public void assign(String string) {
                StringFacetsPanel.this.assignNewType();
            }
        });
        this.maxLengthField.setHorizontalAlignment(4);
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("  Min: "));
        box.add(this.minLengthField);
        box.add(new JLabel("   Max: "));
        box.add(this.maxLengthField);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("String Length", box);
        this.add("North", (Component)((Object)oWLLabeledComponent));
        this.patternField = new AssigningTextField(new AssigningTextField.Assign(){

            public void assign(String string) {
                StringFacetsPanel.this.assignNewType();
            }
        });
        OWLLabeledComponent oWLLabeledComponent2 = new OWLLabeledComponent("Regular Expression", this.patternField);
        this.add("Center", (Component)((Object)oWLLabeledComponent2));
    }

    private void assignNewType() {
        RDFResource rDFResource;
        int n = this.getInt(this.maxLengthField);
        int n2 = this.getInt(this.minLengthField);
        String string = this.patternField.getText().trim();
        if (string.length() == 0) {
            string = null;
        }
        if ((rDFResource = this.rangeWidget.getEditedProperty().getRange()) instanceof RDFSDatatype) {
            RDFSDatatype rDFSDatatype = (RDFSDatatype)rDFResource;
            RDFSDatatype rDFSDatatype2 = rDFSDatatype.getBaseDatatype();
            RDFSDatatype rDFSDatatype3 = rDFSDatatype;
            if (rDFSDatatype2 != null) {
                rDFSDatatype3 = rDFSDatatype2;
            }
            if (string == null && n2 < 0 && n < 0) {
                this.rangeWidget.setRange(rDFSDatatype3);
            } else {
                OWLModel oWLModel = this.rangeWidget.getOWLModel();
                RDFSDatatypeFactory rDFSDatatypeFactory = oWLModel.getRDFSDatatypeFactory();
                if (!rDFSDatatype3.isEditable()) {
                    rDFSDatatype3 = rDFSDatatypeFactory.createAnonymousDatatype(rDFSDatatype3);
                }
                if (string != null) {
                    rDFSDatatypeFactory.setPattern(rDFSDatatype3, string);
                }
                if (n >= 0) {
                    if (n == n2) {
                        rDFSDatatypeFactory.setLength(rDFSDatatype3, n);
                    } else {
                        rDFSDatatypeFactory.setMaxLength(rDFSDatatype3, n);
                        if (n2 >= 0) {
                            rDFSDatatypeFactory.setMinLength(rDFSDatatype3, n2);
                        }
                    }
                } else if (n2 >= 0) {
                    rDFSDatatypeFactory.setMinLength(rDFSDatatype3, n2);
                }
                this.rangeWidget.setRange(rDFSDatatype3);
            }
        }
    }

    private int getInt(JTextField jTextField) {
        String string = jTextField.getText().trim();
        if (string.length() > 0) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setEditable(boolean bl) {
        this.patternField.setEditable(bl);
    }

    public void update(RDFSDatatype rDFSDatatype) {
        String string = rDFSDatatype.getPattern();
        this.patternField.setText(string == null ? "" : string);
        int n = rDFSDatatype.getLength();
        if (n >= 0) {
            this.maxLengthField.setText("" + n);
            this.minLengthField.setText("" + n);
        } else {
            int n2 = rDFSDatatype.getMinLength();
            if (n2 >= 0) {
                this.minLengthField.setText("" + n2);
            } else {
                this.minLengthField.setText("");
            }
            int n3 = rDFSDatatype.getMaxLength();
            if (n3 >= 0) {
                this.maxLengthField.setText("" + n3);
            } else {
                this.maxLengthField.setText("");
            }
        }
    }
}

