/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainWidget;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class AddClassToDomainAction
extends ResourceSelectionAction {
    private OWLDomainWidget widget;

    public AddClassToDomainAction(OWLDomainWidget oWLDomainWidget) {
        super("Specialise Domain", OWLIcons.getAddIcon("PrimitiveClass"), true);
        this.widget = oWLDomainWidget;
    }

    public static boolean canAdd(RDFProperty rDFProperty) {
        OWLModel oWLModel;
        if (!(rDFProperty instanceof OWLProperty) && !ProfilesManager.isFeatureSupported(oWLModel = rDFProperty.getOWLModel(), OWLProfiles.Union_Classes)) {
            ArrayList arrayList = new ArrayList(rDFProperty.getUnionDomain());
            arrayList.remove(oWLModel.getOWLThingClass());
            if (arrayList.size() > 0) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "In pure RDF, rdf:Properties can only have one class in their\n(union) domain.  You need to select a different language profile.");
                return false;
            }
        }
        return true;
    }

    private String checkCls(Cls cls) {
        RDFProperty rDFProperty;
        if (cls instanceof RDFSNamedClass && (rDFProperty = (RDFProperty)this.widget.getEditedResource()).getUnionDomain().contains(cls)) {
            return "The class " + cls.getBrowserText() + " is already in the domain.";
        }
        return null;
    }

    public void resourceSelected(RDFResource rDFResource) {
        RDFSClass rDFSClass = (RDFSClass)rDFResource;
        RDFProperty rDFProperty = (RDFProperty)this.widget.getEditedResource();
        OWLModel oWLModel = rDFSClass.getOWLModel();
        if (!AddClassToDomainAction.canAdd(rDFProperty)) {
            return;
        }
        String string = this.checkCls(rDFSClass);
        if (string == null) {
            try {
                oWLModel.beginTransaction("Add " + rDFResource.getBrowserText() + " to the domain of " + rDFProperty.getBrowserText(), rDFProperty.getName());
                if (rDFProperty.getDirectOwnSlotValue(oWLModel.getSlot(":DIRECT-DOMAIN")) == null) {
                    rDFProperty.addUnionDomainClass(rDFSClass);
                    for (RDFProperty rDFProperty2 : rDFProperty.getSuperproperties(true)) {
                        for (RDFSClass rDFSClass2 : rDFProperty2.getUnionDomain()) {
                            if (rDFSClass.getSuperclasses(true).contains(rDFSClass2) || rDFProperty.getUnionDomain().contains(rDFSClass2)) continue;
                            rDFProperty.addUnionDomainClass(rDFSClass2);
                        }
                    }
                } else {
                    if (oWLModel.getOWLThingClass().getUnionDomainProperties().contains(rDFProperty)) {
                        rDFProperty.removeUnionDomainClass(oWLModel.getOWLThingClass());
                    }
                    rDFProperty.addUnionDomainClass(rDFSClass);
                }
                rDFProperty.synchronizeDomainAndRangeOfInverse();
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        } else {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, string, "Invalid domain");
        }
    }

    public Collection getSelectableResources() {
        OWLModel oWLModel = (OWLModel)this.widget.getKnowledgeBase();
        RDFProperty rDFProperty = (RDFProperty)this.widget.getEditedResource();
        HashSet<Cls> hashSet = null;
        if (rDFProperty.getSuperpropertyCount() > 0) {
            hashSet = new HashSet<Cls>();
            for (Slot slot : rDFProperty.getSuperproperties(true)) {
                for (Cls cls : slot.getDirectDomain()) {
                    if (!(cls instanceof RDFSNamedClass)) continue;
                    hashSet.add(cls);
                    for (Cls cls2 : cls.getSubclasses()) {
                        if (!(cls2 instanceof RDFSNamedClass)) continue;
                        hashSet.add(cls2);
                    }
                }
            }
            hashSet.removeAll(rDFProperty.getUnionDomain());
        } else {
            hashSet = oWLModel.getUserDefinedRDFSNamedClasses();
            hashSet.add(oWLModel.getOWLThingClass());
            hashSet.removeAll(rDFProperty.getUnionDomain());
        }
        Object[] objectArray = hashSet.toArray();
        Arrays.sort(objectArray, new FrameComparator());
        return hashSet;
    }

    public Collection pickResources() {
        OWLModel oWLModel = (OWLModel)this.widget.getKnowledgeBase();
        RDFProperty rDFProperty = (RDFProperty)this.widget.getEditedResource();
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        hashSet.add(oWLModel.getOWLThingClass());
        if (rDFProperty.getSuperpropertyCount() > 0) {
            for (RDFProperty rDFProperty2 : rDFProperty.getSuperproperties(true)) {
                hashSet.addAll(rDFProperty2.getUnionDomain());
            }
            if (hashSet.size() > 1) {
                hashSet.remove(oWLModel.getOWLThingClass());
            }
        }
        return ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)this.widget), oWLModel, hashSet, "Select named class(es) to add");
    }
}

