/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.impl.OperationImpl;
import edu.stanford.smi.protege.ui.SlotsTreeDragSourceListener;
import edu.stanford.smi.protege.ui.SlotsTreeTarget;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.DeleteAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SuperslotTraverser;
import edu.stanford.smi.protege.util.Traverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OverlayIcon;
import edu.stanford.smi.protegex.owl.ui.matrix.property.PropertyMatrixAction;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertySubpropertyRoot;
import edu.stanford.smi.protegex.owl.ui.properties.actions.CreateSubpropertyAction;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultPropertyFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import edu.stanford.smi.protegex.owl.ui.subsumption.TooltippedSelectableTree;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OWLSubpropertyPane
extends SelectableContainer
implements HostResourceDisplay {
    private Action createAnnotationOWLDatatypePropertyAction = new AbstractAction("Create annotation datatype property", OWLIcons.getCreatePropertyIcon("AnnotationOWLDatatypeProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLDatatypeProperty oWLDatatypeProperty = null;
            try {
                String string = OWLSubpropertyPane.this.owlModel.createNewResourceName("annotationProperty");
                OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString(), string);
                oWLDatatypeProperty = OWLSubpropertyPane.this.owlModel.createAnnotationOWLDatatypeProperty(string);
                OWLSubpropertyPane.this.owlModel.commitTransaction();
            }
            catch (Exception exception) {
                OWLSubpropertyPane.this.owlModel.rollbackTransaction();
                OWLUI.handleError(OWLSubpropertyPane.this.owlModel, exception);
            }
            OWLSubpropertyPane.this.displayHostResource(oWLDatatypeProperty);
        }
    };
    private Action createAnnotationOWLObjectPropertyAction = new AbstractAction("Create annotation object property", OWLIcons.getCreatePropertyIcon("AnnotationOWLObjectProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLObjectProperty oWLObjectProperty = null;
            try {
                String string = OWLSubpropertyPane.this.owlModel.createNewResourceName("annotationProperty");
                OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString(), string);
                oWLObjectProperty = OWLSubpropertyPane.this.owlModel.createAnnotationOWLObjectProperty(string);
                OWLSubpropertyPane.this.owlModel.commitTransaction();
            }
            catch (Exception exception) {
                OWLSubpropertyPane.this.owlModel.rollbackTransaction();
                OWLUI.handleError(OWLSubpropertyPane.this.owlModel, exception);
            }
            OWLSubpropertyPane.this.displayHostResource(oWLObjectProperty);
        }
    };
    private Action createAnnotationPropertyAction = new AbstractAction("Create annotation property", OWLIcons.getCreatePropertyIcon("RDFProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            RDFProperty rDFProperty = null;
            try {
                String string = OWLSubpropertyPane.this.owlModel.createNewResourceName("annotationProperty");
                OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString(), string);
                rDFProperty = OWLSubpropertyPane.this.owlModel.createAnnotationProperty(string);
                OWLSubpropertyPane.this.owlModel.commitTransaction();
            }
            catch (Exception exception) {
                OWLSubpropertyPane.this.owlModel.rollbackTransaction();
                OWLUI.handleError(OWLSubpropertyPane.this.owlModel, exception);
            }
            OWLSubpropertyPane.this.displayHostResource(rDFProperty);
        }
    };
    private Action createOWLDatatypePropertyAction = new AbstractAction("Create datatype property", OWLIcons.getCreatePropertyIcon("OWLDatatypeProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLDatatypeProperty oWLDatatypeProperty = null;
            try {
                String string = OWLSubpropertyPane.this.owlModel.createNewResourceName("datatypeProperty");
                OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString(), string);
                oWLDatatypeProperty = OWLSubpropertyPane.this.owlModel.createOWLDatatypeProperty(string);
                oWLDatatypeProperty.setDomainDefined(false);
                OWLSubpropertyPane.this.owlModel.commitTransaction();
            }
            catch (Exception exception) {
                OWLSubpropertyPane.this.owlModel.rollbackTransaction();
                OWLUI.handleError(OWLSubpropertyPane.this.owlModel, exception);
            }
            OWLSubpropertyPane.this.displayHostResource(oWLDatatypeProperty);
        }
    };
    private Action createOWLObjectPropertyAction = new AbstractAction("Create object property", OWLIcons.getCreatePropertyIcon("OWLObjectProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLObjectProperty oWLObjectProperty = null;
            try {
                String string = OWLSubpropertyPane.this.owlModel.createNewResourceName("objectProperty");
                OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString(), string);
                oWLObjectProperty = OWLSubpropertyPane.this.owlModel.createOWLObjectProperty(string);
                oWLObjectProperty.setDomainDefined(false);
                OWLSubpropertyPane.this.owlModel.commitTransaction();
            }
            catch (Exception exception) {
                OWLSubpropertyPane.this.owlModel.rollbackTransaction();
                OWLUI.handleError(OWLSubpropertyPane.this.owlModel, exception);
            }
            OWLSubpropertyPane.this.displayHostResource(oWLObjectProperty);
        }
    };
    private Action createRDFPropertyAction = new AbstractAction("Create RDF property", OWLIcons.getCreatePropertyIcon("RDFProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            RDFProperty rDFProperty = null;
            try {
                String string = OWLSubpropertyPane.this.owlModel.createNewResourceName("property");
                OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString(), string);
                rDFProperty = OWLSubpropertyPane.this.owlModel.createRDFProperty(string);
                OWLSubpropertyPane.this.owlModel.commitTransaction();
            }
            catch (Exception exception) {
                OWLSubpropertyPane.this.owlModel.rollbackTransaction();
                OWLUI.handleError(OWLSubpropertyPane.this.owlModel, exception);
            }
            OWLSubpropertyPane.this.displayHostResource(rDFProperty);
        }
    };
    private Action createSubpropertyAction = new AbstractAction("Create subproperty", OWLIcons.getCreatePropertyIcon("SubProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            Collection collection = OWLSubpropertyPane.this.getSelection();
            if (collection.size() == 1) {
                RDFProperty rDFProperty = (RDFProperty)collection.iterator().next();
                CreateSubpropertyAction.performAction(OWLSubpropertyPane.this.owlModel, rDFProperty, OWLSubpropertyPane.this);
            }
        }
    };
    private Action deletePropertyAction = new DeleteAction("Delete properties", (Selectable)this, OWLIcons.getDeleteIcon("RDFProperty")){

        public void onDelete(Collection collection) {
            OWLSubpropertyPane.this.handleDelete(collection);
        }

        public void onSelectionChange() {
            RDFProperty rDFProperty = (RDFProperty)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            if (rDFProperty != null) {
                this.setAllowed(rDFProperty.isEditable() && OWLSubpropertyPane.this.isEnabled());
            }
        }
    };
    private OWLModel owlModel;
    private OWLPropertySubpropertyRoot root;
    private Action viewPropertyAction = new ViewAction("View selected properties", (Selectable)this){

        public void onView(Object object) {
            OWLSubpropertyPane.this.owlModel.getProject().show((Instance)((RDFProperty)object));
        }
    };

    public OWLSubpropertyPane(Project project) {
        this((OWLModel)project.getKnowledgeBase());
    }

    public OWLSubpropertyPane(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.root = this.createRoot();
        TooltippedSelectableTree tooltippedSelectableTree = new TooltippedSelectableTree(this.viewPropertyAction, this.root);
        tooltippedSelectableTree.setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer()));
        tooltippedSelectableTree.setShowsRootHandles(true);
        tooltippedSelectableTree.setSelectionRow(0);
        tooltippedSelectableTree.setLargeModel(true);
        this.setSelectable((Selectable)tooltippedSelectableTree);
        this.setLayout(new BorderLayout());
        LabeledComponent labeledComponent = new LabeledComponent(this.getHeaderLabel(), ComponentFactory.createScrollPane((JComponent)((Object)tooltippedSelectableTree)));
        labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)labeledComponent, "Center");
        DefaultPropertyFind defaultPropertyFind = new DefaultPropertyFind(oWLModel, 1){

            protected boolean isValidFrameToSearch(Frame frame) {
                return super.isValidFrameToSearch(frame) && OWLSubpropertyPane.this.root.isSuitable((RDFProperty)frame);
            }
        };
        FindInDialogAction findInDialogAction = new FindInDialogAction(defaultPropertyFind, Icons.getFindSlotIcon(), this, true);
        ResourceFinder resourceFinder = new ResourceFinder(findInDialogAction);
        this.add(resourceFinder, "South");
        resourceFinder.addButton(new PropertyMatrixAction(oWLModel));
        tooltippedSelectableTree.addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)((Object)tooltippedSelectableTree)){

            public JPopupMenu getPopupMenu() {
                return OWLSubpropertyPane.this.getPopupMenu();
            }
        });
        this.setupDragAndDrop();
        this.viewPropertyAction.setEnabled(true);
        this.deletePropertyAction.setEnabled(true);
        labeledComponent.setHeaderIcon(this.getHeaderIcon());
        WidgetUtilities.addViewButton(labeledComponent, this.viewPropertyAction);
        for (Action action : this.getActions()) {
            labeledComponent.addHeaderButton(action);
        }
        JButton jButton = labeledComponent.addHeaderButton(this.deletePropertyAction);
        jButton.setDisabledIcon(((OverlayIcon)jButton.getIcon()).getGrayedIcon());
    }

    protected String getHeaderLabel() {
        return "Properties";
    }

    protected Icon getHeaderIcon() {
        return OWLIcons.getImageIcon("Properties");
    }

    protected Action getCreateAnnotationOWLDatatypePropertyAction() {
        return this.createAnnotationOWLDatatypePropertyAction;
    }

    protected Action getCreateAnnotationOWLObjectPropertyAction() {
        return this.createAnnotationOWLObjectPropertyAction;
    }

    protected Action getCreateAnnotationPropertyAction() {
        return this.createAnnotationPropertyAction;
    }

    protected Action getCreateOWLDatatypePropertyAction() {
        return this.createOWLDatatypePropertyAction;
    }

    protected Action getCreateOWLObjectPropertyAction() {
        return this.createOWLObjectPropertyAction;
    }

    protected Action getCreateRDFPropertyAction() {
        return this.createRDFPropertyAction;
    }

    protected Action getCreateSubpropertyAction() {
        return this.createSubpropertyAction;
    }

    protected Action getDeletePropertyAction() {
        return this.deletePropertyAction;
    }

    public boolean contains(RDFProperty rDFProperty) {
        TreeNode treeNode = (TreeNode)this.getTree().getModel().getRoot();
        return this.contains(treeNode, rDFProperty, new HashSet());
    }

    private boolean contains(TreeNode treeNode, RDFProperty rDFProperty, Set set) {
        if (!set.contains(treeNode)) {
            set.add(treeNode);
            if (treeNode instanceof LazyTreeNode && rDFProperty.equals(((LazyTreeNode)treeNode).getUserObject())) {
                return true;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                if (!this.contains(treeNode.getChildAt(i), rDFProperty, set)) continue;
                return true;
            }
        }
        return false;
    }

    protected Collection getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (ProfilesManager.isFeatureSupported(this.owlModel, OWLProfiles.CreateRDFProperty)) {
            arrayList.add(this.createRDFPropertyAction);
        }
        boolean bl = ProfilesManager.isFeatureSupported(this.owlModel, OWLProfiles.Create_DatatypeProperty);
        boolean bl2 = ProfilesManager.isFeatureSupported(this.owlModel, OWLProfiles.Create_ObjectProperty);
        if (bl) {
            arrayList.add(this.createOWLDatatypePropertyAction);
        }
        if (bl2) {
            arrayList.add(this.createOWLObjectPropertyAction);
        }
        arrayList.add(this.createSubpropertyAction);
        if (bl) {
            arrayList.add(this.createAnnotationOWLDatatypePropertyAction);
        }
        if (bl2) {
            arrayList.add(this.createAnnotationOWLObjectPropertyAction);
        }
        arrayList.add(this.createAnnotationPropertyAction);
        return arrayList;
    }

    protected OWLPropertySubpropertyRoot createRoot() {
        return new OWLPropertySubpropertyRoot(this.getOWLModel());
    }

    public void extendSelection(RDFProperty rDFProperty) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)rDFProperty);
    }

    public RDFProperty getDisplayParent() {
        RDFProperty rDFProperty = null;
        TreePath treePath = this.getTree().getSelectionModel().getLeadSelectionPath();
        if (treePath != null) {
            TreePath treePath2 = treePath.getParentPath();
            LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath2.getLastPathComponent();
            Object object = lazyTreeNode.getUserObject();
            rDFProperty = object instanceof RDFProperty ? (RDFProperty)object : null;
        }
        return rDFProperty;
    }

    public JComponent getDropComponent() {
        return this.getTree();
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    public List getPath(RDFProperty rDFProperty, List list) {
        list.add(0, rDFProperty);
        RDFProperty rDFProperty2 = (RDFProperty)CollectionUtilities.getFirstItem((Collection)rDFProperty.getSuperproperties(false));
        if (rDFProperty2 != null) {
            this.getPath(rDFProperty2, list);
        }
        return list;
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = null;
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            RDFProperty rDFProperty = (RDFProperty)CollectionUtilities.getFirstItem((Collection)collection);
            jPopupMenu = new JPopupMenu();
            ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)this), (RDFResource)rDFProperty);
            ResourceActionManager.setResourceActionsEnabled(jPopupMenu, this.isEnabled());
        }
        return jPopupMenu;
    }

    public JTree getTree() {
        return (JTree)this.getSelectable();
    }

    protected void handleDelete(Collection collection) {
        this.removeSelection();
        try {
            this.owlModel.beginTransaction("Delete properties " + collection);
            for (RDFProperty rDFProperty : collection) {
                rDFProperty.delete();
            }
            this.owlModel.commitTransaction();
        }
        catch (Exception exception) {
            this.owlModel.rollbackTransaction();
            Log.getLogger().warning("Error at delete properties " + collection);
        }
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setExpandedProperty(RDFProperty rDFProperty, boolean bl) {
        ComponentUtilities.setExpanded((JTree)this.getTree(), (Collection)this.getPath(rDFProperty, new LinkedList()), (boolean)bl);
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)defaultRenderer);
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTree(), 3, (DragGestureListener)new SlotsTreeDragSourceListener());
        new DropTarget(this.getTree(), 3, (DropTargetListener)new SlotsTreeTarget());
    }

    public void setDisplayParent(RDFProperty rDFProperty) {
        ComponentUtilities.setDisplayParent((JTree)this.getTree(), (Object)rDFProperty, (Traverser)new SuperslotTraverser());
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        if (!this.getSelection().contains(rDFResource)) {
            ComponentUtilities.setSelectedObjectPath((JTree)this.getTree(), (Collection)this.getPath((RDFProperty)rDFResource, new LinkedList()));
        }
        return true;
    }

    public void setEnabled(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.getOWLModel(), (Operation)OperationImpl.PROPERTY_TAB_WRITE);
        this.createAnnotationOWLDatatypePropertyAction.setEnabled(bl);
        this.createAnnotationOWLObjectPropertyAction.setEnabled(bl);
        this.createOWLDatatypePropertyAction.setEnabled(bl);
        this.createOWLObjectPropertyAction.setEnabled(bl);
        this.createRDFPropertyAction.setEnabled(bl);
        this.createSubpropertyAction.setEnabled(bl);
        this.deletePropertyAction.setEnabled(bl);
        super.setEnabled(bl);
    }
}

