/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.ui.SlotSubslotNode;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class OWLPropertySubpropertyRoot
extends LazyTreeRoot {
    private OWLModel owlModel;
    private ModelListener modelListener = new ModelAdapter(){

        public void propertyCreated(RDFProperty rDFProperty) {
            if (rDFProperty.getSuperproperties(false).isEmpty() && OWLPropertySubpropertyRoot.this.isSuitable(rDFProperty)) {
                List list = (List)OWLPropertySubpropertyRoot.this.getUserObject();
                int n = 0;
                if (n < 0) {
                    n = -(n + 1);
                }
                list.add(n, rDFProperty);
                OWLPropertySubpropertyRoot.this.childAdded(rDFProperty, n);
                if (OWLPropertySubpropertyRoot.this.getChildCount() == 1) {
                    OWLPropertySubpropertyRoot.this.notifyNodeStructureChanged((LazyTreeNode)OWLPropertySubpropertyRoot.this);
                }
            }
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            List list = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            boolean bl = list.remove(rDFProperty);
            if (bl) {
                OWLPropertySubpropertyRoot.this.childRemoved(rDFProperty);
            }
        }
    };
    public PropertyListener propertyListener = new PropertyAdapter(){

        public void superpropertyAdded(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
            if (rDFProperty.getSuperpropertyCount() == 1 && OWLPropertySubpropertyRoot.this.isSuitable(rDFProperty)) {
                this.removeChild(rDFProperty);
            }
        }

        public void superpropertyRemoved(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
            if (rDFProperty.getSuperpropertyCount() == 0 && OWLPropertySubpropertyRoot.this.isSuitable(rDFProperty)) {
                this.addChild(rDFProperty);
            }
        }

        private void removeChild(Slot slot) {
            List list = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            list.remove(slot);
            OWLPropertySubpropertyRoot.this.childRemoved(slot);
        }

        private void addChild(Slot slot) {
            List list = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            list.add(slot);
            OWLPropertySubpropertyRoot.this.childAdded(slot);
        }
    };
    public ResourceListener resourceListener = new ResourceAdapter(){

        public void typeAdded(RDFResource rDFResource, RDFSClass rDFSClass) {
            if (rDFResource instanceof RDFProperty) {
                this.addChild((RDFProperty)rDFResource);
                this.removeChild((RDFProperty)rDFResource);
            }
        }

        public void typeRemoved(RDFResource rDFResource, RDFSClass rDFSClass) {
            if (rDFResource instanceof RDFProperty) {
                this.removeChild((RDFProperty)rDFResource);
                this.addChild((RDFProperty)rDFResource);
            }
        }

        private void removeChild(RDFProperty rDFProperty) {
            List list = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            if (list.contains(rDFProperty) && !OWLPropertySubpropertyRoot.this.isSuitable(rDFProperty)) {
                list.remove(rDFProperty);
                OWLPropertySubpropertyRoot.this.childRemoved(rDFProperty);
            }
        }

        private void addChild(RDFProperty rDFProperty) {
            List list = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            if (!list.contains(rDFProperty) && rDFProperty.getSuperpropertyCount() == 0 && OWLPropertySubpropertyRoot.this.isSuitable(rDFProperty)) {
                list.add(rDFProperty);
                OWLPropertySubpropertyRoot.this.childAdded(rDFProperty);
            }
        }
    };

    public OWLPropertySubpropertyRoot(OWLModel oWLModel, Collection collection) {
        super(collection);
        this.owlModel = oWLModel;
        this.owlModel.addModelListener(this.modelListener);
        this.owlModel.addPropertyListener(this.propertyListener);
        this.owlModel.addResourceListener(this.resourceListener);
    }

    public boolean isSuitable(RDFProperty rDFProperty) {
        return true;
    }

    public OWLPropertySubpropertyRoot(OWLModel oWLModel) {
        super(OWLPropertySubpropertyRoot.getValidSlots(oWLModel));
        oWLModel.addModelListener(this.modelListener);
        oWLModel.addPropertyListener(this.propertyListener);
        oWLModel.addResourceListener(this.resourceListener);
        this.owlModel = oWLModel;
    }

    public LazyTreeNode createNode(Object object) {
        return new SlotSubslotNode((LazyTreeNode)this, (Slot)object);
    }

    public void dispose() {
        super.dispose();
        this.owlModel.removeModelListener(this.modelListener);
        this.owlModel.removePropertyListener(this.propertyListener);
    }

    public Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    private static Collection getValidSlots(OWLModel oWLModel) {
        ArrayList arrayList = new ArrayList(oWLModel.getVisibleUserDefinedRDFProperties());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (slot.getDirectSuperslotCount() <= 0) continue;
            iterator.remove();
        }
        arrayList.remove(oWLModel.getRDFProperty(":FROM"));
        arrayList.remove(oWLModel.getRDFProperty(":TO"));
        arrayList.removeAll(Arrays.asList(oWLModel.getSystemAnnotationProperties()));
        Collections.sort(arrayList, new FrameComparator());
        return arrayList;
    }
}

