/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.impl.OperationImpl;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.properties.OWLSubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLSuperpropertiesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class OWLPropertyHierarchyPanel
extends JPanel {
    private OWLSubpropertyPane subpropertyPane;
    private OWLSuperpropertiesPanel superpropertiesPanel;

    public OWLPropertyHierarchyPanel(OWLSubpropertyPane oWLSubpropertyPane, OWLSuperpropertiesPanel oWLSuperpropertiesPanel) {
        this.subpropertyPane = oWLSubpropertyPane;
        this.superpropertiesPanel = oWLSuperpropertiesPanel;
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout(7, 7));
        JSplitPane jSplitPane = new JSplitPane(0, false);
        jSplitPane.setTopComponent((Component)((Object)this.subpropertyPane));
        jSplitPane.setBottomComponent((Component)((Object)this.superpropertiesPanel));
        jSplitPane.setBorder(null);
        this.add(jSplitPane);
        jSplitPane.setDividerLocation(600);
        this.subpropertyPane.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                RDFProperty rDFProperty = (RDFProperty)CollectionUtilities.getFirstItem((Collection)OWLPropertyHierarchyPanel.this.subpropertyPane.getSelection());
                OWLPropertyHierarchyPanel.this.superpropertiesPanel.setProperty(rDFProperty, null);
            }
        });
    }

    public OWLSubpropertyPane getSubpropertyPane() {
        return this.subpropertyPane;
    }

    public OWLSuperpropertiesPanel getSuperpropertiesPanel() {
        return this.superpropertiesPanel;
    }

    public void setEnabled(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.subpropertyPane.getOWLModel(), (Operation)OperationImpl.PROPERTY_TAB_WRITE);
        this.subpropertyPane.setEnabled(bl);
        this.superpropertiesPanel.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setRenderer(FrameRenderer frameRenderer) {
        this.subpropertyPane.setRenderer((DefaultRenderer)frameRenderer);
    }
}

