/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextAreaPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.DefaultOWLTableTransferHandler;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableTransferHandler;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTable;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JComponent;

public abstract class OWLTable
extends SymbolTable {
    private OWLTableAction copyAction = new AbstractOWLTableAction("Copy", OWLIcons.getCopyIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTable.this.transferHandler.exportToClipboard((JComponent)((Object)OWLTable.this), OWLTable.this.getClipboard(), 1);
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            return OWLTable.this.getOWLTableModel().getClass(n) != null;
        }
    };
    private OWLTableAction cutAction = new AbstractOWLTableAction("Cut", OWLIcons.getCutIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTable.this.getTransferHandler().exportToClipboard((JComponent)((Object)OWLTable.this), OWLTable.this.getClipboard(), 2);
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            OWLTableModel oWLTableModel = OWLTable.this.getOWLTableModel();
            return oWLTableModel.isEditable() && oWLTableModel.getClass(n) != null && oWLTableModel.isDeleteEnabledFor(oWLTableModel.getClass(n));
        }
    };
    private OWLTableAction pasteAction = new AbstractOWLTableAction("Paste", OWLIcons.getPasteIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            Transferable transferable = OWLTable.this.getClipboard().getContents(null);
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                OWLTable.this.transferHandler.importData((JComponent)((Object)OWLTable.this), transferable);
            }
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            OWLTableModel oWLTableModel = OWLTable.this.getOWLTableModel();
            if (oWLTableModel.isEditable()) {
                try {
                    Transferable transferable = OWLTable.this.getClipboard().getContents(null);
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        return oWLTableModel.isAddEnabledAt(n);
                    }
                }
                catch (HeadlessException headlessException) {
                    return false;
                }
            }
            return false;
        }
    };
    private OWLTableAction viewClsAction = new AbstractOWLTableAction("Edit/View named class...", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTable.this.viewSelectedCls();
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            return rDFSClass instanceof RDFSNamedClass;
        }
    };
    private OWLTableTransferHandler transferHandler;

    public OWLTable(OWLTableModel oWLTableModel, OWLModel oWLModel, boolean bl) {
        super(oWLTableModel, oWLModel, bl, new OWLSymbolPanel(oWLModel, true, true));
        this.registerAction(this.editMultiLineAction);
        this.registerAction(this.viewClsAction);
        this.registerAction(this.editAnnotationsAction);
        this.registerActionSeparator();
        this.registerAction(this.copyAction);
        this.registerAction(this.cutAction);
        this.registerAction(this.pasteAction);
        this.registerActionSeparator();
        try {
            this.setDragEnabled(OWLUI.isDragAndDropSupported(oWLModel));
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        this.transferHandler = new DefaultOWLTableTransferHandler(oWLModel);
        this.setTransferHandler(this.transferHandler);
    }

    protected ResourceRenderer createOWLFrameRenderer() {
        return new ResourceRenderer();
    }

    protected String editMultiLine(RDFResource rDFResource) {
        return OWLTextAreaPanel.showEditDialog((Component)((Object)this), this.getOWLModel(), (RDFSClass)rDFResource);
    }

    public void enableActions(Collection collection) {
        OWLTableModel oWLTableModel = this.getOWLTableModel();
        for (OWLTableAction oWLTableAction : collection) {
            if (oWLTableAction == null) continue;
            if (this.isEnabled()) {
                boolean bl;
                if (this.getSelectionModel().getSelectionMode() == 0) {
                    int n = this.getSelectedRow();
                    if (n >= 0 && n < oWLTableModel.getRowCount()) {
                        RDFSClass rDFSClass = oWLTableModel.getClass(n);
                        bl = oWLTableAction.isEnabledFor(rDFSClass, n);
                        oWLTableAction.setEnabled(bl);
                        continue;
                    }
                    oWLTableAction.setEnabled(false);
                    continue;
                }
                int[] nArray = this.getSelectedRows();
                boolean bl2 = nArray.length > 0;
                bl = false;
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (n >= oWLTableModel.getRowCount()) continue;
                    bl = true;
                    RDFSClass rDFSClass = oWLTableModel.getClass(n);
                    if (oWLTableAction.isEnabledFor(rDFSClass, n)) continue;
                    bl2 = false;
                    break;
                }
                oWLTableAction.setEnabled(bl2 && bl);
                continue;
            }
            oWLTableAction.setEnabled(false);
        }
    }

    public OWLNamedClass getEditedCls() {
        return this.getOWLTableModel().getEditedCls();
    }

    protected Collection getNavigationMenuItems(RDFResource rDFResource) {
        if (OWLClassesTab.getOWLClassesTab((Component)((Object)this)) != null) {
            HashSet hashSet = new HashSet();
            RDFSClass rDFSClass = (RDFSClass)rDFResource;
            rDFSClass.getNestedNamedClasses(hashSet);
            return hashSet;
        }
        return Collections.EMPTY_LIST;
    }

    public OWLTableModel getOWLTableModel() {
        return (OWLTableModel)this.getSymbolTableModel();
    }

    public Cls getSelectedCls() {
        OWLTableModel oWLTableModel = this.getOWLTableModel();
        int n = this.getSelectedRow();
        if (n >= 0 && n < oWLTableModel.getRowCount()) {
            return oWLTableModel.getClass(n);
        }
        return null;
    }

    protected String getToolTipText(RDFResource rDFResource) {
        String string = OWLUI.getOWLToolTipText(rDFResource);
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    protected void navigateTo(RDFResource rDFResource) {
        OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        if (oWLClassesTab != null && rDFResource instanceof RDFSNamedClass) {
            oWLClassesTab.setSelectedCls((RDFSNamedClass)rDFResource);
        }
    }

    public void setCls(OWLNamedClass oWLNamedClass) {
        if (this.getSymbolCellEditor() != null) {
            this.getSymbolCellEditor().cancelCellEditing();
        }
        this.hideSymbolPanel();
        this.getOWLTableModel().setCls(oWLNamedClass);
    }

    public void setValueAt(Object object, int n, int n2) {
        OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        super.setValueAt(object, n, n2);
        if (oWLClassesTab != null) {
            oWLClassesTab.ensureClassSelected(this.getEditedCls(), -1);
        }
    }

    private void viewSelectedCls() {
        this.editAnnotations();
    }
}

