/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.ForcedURLRetrievalRepository;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AbstractImportEntry;
import java.net.URI;
import java.net.URL;

public class URLImportEntry
extends AbstractImportEntry {
    private URL url;

    public URLImportEntry(URL uRL) {
        this.url = uRL;
    }

    public boolean isPossibleToImport() {
        try {
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(this.url.openConnection().getInputStream(), this.url);
            URI uRI = ontologyNameExtractor.getOntologyName();
            if (uRI != null) {
                this.setRepository(new HTTPRepository(this.url));
            } else if (ontologyNameExtractor.isRDFRootElementPresent()) {
                uRI = new URI(this.url.toString());
                this.setRepository(new ForcedURLRetrievalRepository(this.url));
            } else {
                throw new IllegalArgumentException("The document pointed to by " + this.url + " does not " + "appear to be a valid ontology.");
            }
            this.setOntologyURI(uRI);
            return true;
        }
        catch (Exception exception) {
            this.addError(exception);
            this.setOntologyURI(null);
            this.setRepository(null);
            return false;
        }
    }

    public Repository getRepositoryToAdd() {
        return this.getRepository();
    }
}

