/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AbstractImportStartWizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportVerificationPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.RepositoryImportEntry;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RepositoryImportPage
extends AbstractImportStartWizardPage {
    private JList list;
    private Action addRepositoryAction;
    private static final String HELP_TEXT = "<p>Please select the ontology to be imported.  If the list above does not contain the ontology, press the 'Add repository...' button to specify a repository that contains the ontology.</p>";

    public RepositoryImportPage(ImportWizard importWizard) {
        super("Repository Import Page", importWizard);
        this.createUI();
    }

    private void createUI() {
        this.setHelpText("Importing an ontology from a repository", HELP_TEXT);
        this.list = new JList();
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RepositoryImportPage.this.setPageComplete(RepositoryImportPage.this.validateData());
                RepositoryImportPage.this.updateNextPage();
            }
        });
        this.refreshList();
        LabeledComponent labeledComponent = new LabeledComponent("Select an ontology to import", new JScrollPane(this.list));
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.add((Component)labeledComponent, "North");
        this.addRepositoryAction = new AbstractAction("Add repository..."){

            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryImportPage.this.addRepository();
            }
        };
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add((Component)new JButton(this.addRepositoryAction), "South");
        jPanel.add((Component)jPanel2, "South");
        this.getContentComponent().add((Component)jPanel, "North");
        this.setPageComplete(this.validateData());
    }

    public void nextPressed() {
        Object[] objectArray = this.list.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            URI uRI = (URI)objectArray[i];
            Repository repository = this.getImportWizard().getOWLModel().getRepositoryManager().getRepository(uRI);
            this.getImportWizard().getImportData().addImportEntry(new RepositoryImportEntry(uRI, repository));
        }
    }

    private boolean validateData() {
        Object e = this.list.getSelectedValue();
        if (e != null) {
            try {
                URI uRI = new URI(e.toString());
                return true;
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        return false;
    }

    private void addRepository() {
        Repository repository;
        OWLModel oWLModel;
        RepositoryWizard repositoryWizard;
        RepositoryImportPage repositoryImportPage = null;
        if (SwingUtilities.getRoot((Component)((Object)this)) instanceof JFrame) {
            repositoryImportPage = this;
        }
        if ((repositoryWizard = new RepositoryWizard((JComponent)((Object)repositoryImportPage), oWLModel = ((ImportWizard)this.getWizard()).getOWLModel())).execute() == 1 && (repository = repositoryWizard.getRepository()) != null) {
            oWLModel.getRepositoryManager().addProjectRepository(0, repository);
            this.refreshList();
        }
    }

    public WizardPage getNextPage() {
        return new ImportVerificationPage(this.getImportWizard());
    }

    private void refreshList() {
        Object object2;
        OWLModel oWLModel = ((ImportWizard)this.getWizard()).getOWLModel();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object object2 : oWLModel.getRepositoryManager().getProjectRepositories()) {
            linkedHashSet.addAll(new TreeSet(object2.getOntologies()));
        }
        for (Object object2 : oWLModel.getRepositoryManager().getGlobalRepositories()) {
            linkedHashSet.addAll(new TreeSet(object2.getOntologies()));
        }
        Set set = oWLModel.getAllImports();
        object2 = linkedHashSet.iterator();
        while (object2.hasNext()) {
            URI uRI = (URI)object2.next();
            if (!set.contains(uRI.toString())) continue;
            object2.remove();
        }
        try {
            linkedHashSet.remove(new URI(oWLModel.getDefaultOWLOntology().getURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.print(uRISyntaxException.getMessage());
        }
        this.list.setListData(linkedHashSet.toArray());
    }
}

