/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.ui.metadatatab.OntologyURIDefaultSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OntologyURIPanel
extends JPanel {
    public static final String URI_BASE_PROPERTY = "OntURIBase";
    public static final String URI_BASE_APPEND_YEAR_PROPERTY = "OntURIBaseAppendYear";
    public static final String URI_BASE_APPEND_MONTH_PROPERTY = "OntURIBaseAppendMonth";
    public static final String URI_BASE_APPEND_DAY_PROPERTY = "OntURIBaseAppendDay";
    public static final String DEFAULT_BASE = "http://www.owl-ontologies.com";
    private JTextField textField;
    private ArrayList changeListeners = new ArrayList();
    private static final String HELP_TEXT = "<p>Please specify a URI for this ontology.</p>This URI will be used by other ontologies that wish to import this ontology.<p>In general, it is recommended that a URI which corresponds to the location of the ontology on the web should be used.  The URI should therefore resemble a HTTP URL, for example http://www.mydomain.com/myontology</p>";

    public OntologyURIPanel(boolean bl, boolean bl2) {
        this.createUI(bl, bl2);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void setDefautOntologyURIBase() {
        String string = ApplicationProperties.getString((String)URI_BASE_PROPERTY);
        if (string == null) {
            string = DEFAULT_BASE;
            ApplicationProperties.setString((String)URI_BASE_PROPERTY, (String)DEFAULT_BASE);
        }
        if (string != null) {
            string = OntologyURIPanel.getOntologyURIBase(string, ApplicationProperties.getBooleanProperty((String)URI_BASE_APPEND_YEAR_PROPERTY, (boolean)false), ApplicationProperties.getBooleanProperty((String)URI_BASE_APPEND_MONTH_PROPERTY, (boolean)false), ApplicationProperties.getBooleanProperty((String)URI_BASE_APPEND_DAY_PROPERTY, (boolean)false));
            String string2 = "Ontology";
            string2 = string2 + System.currentTimeMillis() / 1000L;
            string2 = string2 + ".owl";
            this.textField.setText(string + string2);
        }
    }

    private void fireChangeEvent() {
        for (ChangeListener changeListener : new ArrayList(this.changeListeners)) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public static String getOntologyURIBase(String string, boolean bl, boolean bl2, boolean bl3) {
        if (string != null && string.trim().length() > 0) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if (bl) {
                int n = Calendar.getInstance().get(1);
                string = string + n + "/";
                if (bl2) {
                    int n2 = Calendar.getInstance().get(2) + 1;
                    string = string + n2 + "/";
                    if (bl3) {
                        int n3 = Calendar.getInstance().get(5);
                        string = string + n3 + "/";
                    }
                }
            }
        }
        return string;
    }

    public URI getOntologyURI() {
        if (this.validateName()) {
            try {
                return new URI(this.textField.getText());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return null;
    }

    private void createUI(boolean bl, boolean bl2) {
        Object object;
        this.setLayout(new BorderLayout(7, 7));
        this.textField = new JTextField();
        this.setDefautOntologyURIBase();
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                OntologyURIPanel.this.validateName();
                OntologyURIPanel.this.fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                OntologyURIPanel.this.validateName();
                OntologyURIPanel.this.fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.add((Component)this.textField, "North");
        if (bl2) {
            object = new JPanel(new FlowLayout(2));
            ((Container)object).add(new JButton(new AbstractAction("Default settings..."){

                public void actionPerformed(ActionEvent actionEvent) {
                    OntologyURIDefaultSettingsPanel.showDialog(OntologyURIPanel.this);
                    OntologyURIPanel.this.setDefautOntologyURIBase();
                }
            }));
            jPanel.add((Component)object, "South");
        }
        object = new LabeledComponent("Ontology URI (Usually a URL starting with http://)", (Component)jPanel);
        this.add((Component)object, "North");
        if (bl) {
            this.add((Component)OWLUI.createHelpPanel(HELP_TEXT, null), "South");
        }
        this.validateName();
    }

    private boolean validateName() {
        try {
            URI uRI = new URI(this.textField.getText().trim());
            if (uRI.isAbsolute()) {
                this.textField.setForeground(Color.BLACK);
                return true;
            }
            this.textField.setForeground(Color.RED);
            return false;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.textField.setForeground(Color.RED);
            return false;
        }
    }
}

