/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplayFactory;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextFormatter;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class UISettingsPanel
extends JComponent {
    private JRadioButton[] classDisplayButtons;
    private JCheckBox constraintCheckingCheckBox;
    private JCheckBox dragAndDropCheckBox;
    private JCheckBox externalResourcesCheckBox;
    private JComboBox iconsComboBox;
    private String initialStyle;
    private boolean initialDDValue;
    private OWLModel owlModel;
    private boolean owlClassDisplayModified;

    public UISettingsPanel(OWLModel oWLModel) {
        Object object;
        Serializable serializable;
        this.owlModel = oWLModel;
        Class[] classArray = OWLClassDisplayFactory.getAvailableDisplayClasses();
        this.classDisplayButtons = new JRadioButton[classArray.length];
        JPanel jPanel = new JPanel(new GridLayout(classArray.length, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Class Display Format"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < classArray.length; ++i) {
            JRadioButton jRadioButton;
            serializable = classArray[i];
            object = "";
            try {
                object = (String)((Class)serializable).getMethod("getUIDescription", new Class[0]).invoke((Object)serializable, new Object[0]);
            }
            catch (Exception exception) {
                object = ((Class)serializable).getName();
            }
            int n = ((String)object).lastIndexOf(".");
            object = ((String)object).substring(n + 1);
            this.classDisplayButtons[i] = jRadioButton = new JRadioButton((String)object);
            buttonGroup.add(jRadioButton);
            if (OWLClassDisplayFactory.getDefaultDisplay().getClass() == serializable) {
                jRadioButton.setSelected(true);
            }
            jPanel.add(jRadioButton);
            jRadioButton.addActionListener(new ActionListener((Class)serializable){
                final /* synthetic */ Class val$c;
                {
                    this.val$c = clazz;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    OWLClassDisplay oWLClassDisplay = OWLClassDisplayFactory.getDisplay(this.val$c);
                    OWLClassDisplayFactory.setDefaultDisplay(oWLClassDisplay);
                    UISettingsPanel.this.owlModel.setOWLClassDisplay(oWLClassDisplay);
                    OWLTextFormatter.updateDisplay(oWLClassDisplay);
                    UISettingsPanel.this.owlClassDisplayModified = true;
                }
            });
        }
        this.constraintCheckingCheckBox = new JCheckBox("Constraint checking (red borders) at edit time");
        this.constraintCheckingCheckBox.setSelected(OWLUI.isConstraintChecking(this.owlModel));
        this.constraintCheckingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OWLUI.setConstraintChecking(UISettingsPanel.this.owlModel, UISettingsPanel.this.constraintCheckingCheckBox.isSelected());
            }
        });
        this.dragAndDropCheckBox = new JCheckBox("Drag and Drop");
        this.dragAndDropCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UISettingsPanel.this.updateDragAndDrop();
            }
        });
        this.initialDDValue = OWLUI.isDragAndDropSupported(oWLModel);
        this.dragAndDropCheckBox.setSelected(this.initialDDValue);
        this.externalResourcesCheckBox = new JCheckBox("Allow the creation of external resources (untyped URIs)");
        this.externalResourcesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UISettingsPanel.this.updateExternalResources();
            }
        });
        this.externalResourcesCheckBox.setSelected(OWLUI.isExternalResourcesSupported(oWLModel));
        this.iconsComboBox = new JComboBox<Object>(new Object[]{"Default", "Multicolored"});
        this.initialStyle = OWLIcons.style;
        this.iconsComboBox.setSelectedItem(this.initialStyle);
        Dimension dimension = new Dimension(100, this.iconsComboBox.getPreferredSize().height);
        this.iconsComboBox.setMaximumSize(dimension);
        this.iconsComboBox.setPreferredSize(dimension);
        this.iconsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UISettingsPanel.this.updateIconsStyle();
            }
        });
        serializable = new JPanel(new GridLayout(3, 1));
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("User Interface Features"));
        ((Container)serializable).add(this.dragAndDropCheckBox);
        ((Container)serializable).add(this.constraintCheckingCheckBox);
        ((Container)serializable).add(this.externalResourcesCheckBox);
        object = Box.createHorizontalBox();
        ((Container)object).add(new JLabel("Icon Style: "));
        ((Container)object).add(this.iconsComboBox);
        ((Container)object).add(Box.createHorizontalGlue());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", jPanel);
        jPanel2.add("Center", (Component)object);
        this.setLayout(new BorderLayout(8, 0));
        this.add("Center", (Component)serializable);
        this.add("East", jPanel2);
        this.owlClassDisplayModified = false;
    }

    private void updateExternalResources() {
        boolean bl = this.externalResourcesCheckBox.isSelected();
        OWLUI.setExternalResourcesSupported(this.owlModel, bl);
    }

    public boolean getRequiresReloadUI() {
        return this.initialDDValue != this.dragAndDropCheckBox.isSelected() || !this.initialStyle.equals(this.iconsComboBox.getSelectedItem()) || this.owlClassDisplayModified;
    }

    private void updateDragAndDrop() {
        boolean bl = this.dragAndDropCheckBox.isSelected();
        OWLUI.setDragAndDropSupported(this.owlModel, bl);
    }

    private void updateIconsStyle() {
        String string = (String)this.iconsComboBox.getSelectedItem();
        OWLIcons.setStyle(string);
        ApplicationProperties.setString((String)OWLIcons.STYLE_VARIABLE, (String)string);
    }
}

