/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.LabeledComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class KazukiPanel
extends JPanel {
    private JFileChooser fileChooser = new JFileChooser(".");
    private JTextField javaCTextField;
    private JCheckBox overwriteCheckBox;
    private JTextField packageTextField = new JTextField();
    private JTextField rootFolderTextField = new JTextField("kazuki");

    public KazukiPanel() {
        this.javaCTextField = new JTextField();
        this.fileChooser.setDialogTitle("Select output folder");
        this.fileChooser.setFileSelectionMode(1);
        this.overwriteCheckBox = new JCheckBox("Overwrite all files");
        this.setLayout(new BoxLayout(this, 1));
        LabeledComponent labeledComponent = new LabeledComponent("Root output folder", (Component)this.rootFolderTextField);
        labeledComponent.addHeaderButton((Action)new AbstractAction("Select folder...", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                KazukiPanel.this.selectFolder();
            }
        });
        this.add((Component)labeledComponent);
        this.add(Box.createVerticalStrut(8));
        this.add((Component)new LabeledComponent("Base Java package", (Component)this.packageTextField));
        this.add(Box.createVerticalStrut(8));
        this.add((Component)new LabeledComponent("Java Compiler binary", (Component)this.javaCTextField));
        this.add(Box.createVerticalStrut(8));
        this.overwriteCheckBox.setPreferredSize(new Dimension(400, 24));
        this.add(this.overwriteCheckBox);
    }

    public String getJavaC() {
        return this.javaCTextField.getText();
    }

    public String getPackage() {
        return this.packageTextField.getText();
    }

    public String getRootFolder() {
        return this.rootFolderTextField.getText();
    }

    public boolean isOverwriteMode() {
        return this.overwriteCheckBox.isSelected();
    }

    private void selectFolder() {
        if (this.fileChooser.showDialog(this, "Select") == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.rootFolderTextField.setText(file.toString());
        }
    }

    public void setJavaC(String string) {
        this.javaCTextField.setText(string);
    }

    public void setOverwriteMode(boolean bl) {
        this.overwriteCheckBox.setSelected(bl);
    }

    public void setPackage(String string) {
        this.packageTextField.setText(string);
    }

    public void setRootFolder(String string) {
        this.rootFolderTextField.setText(string);
    }
}

