/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslatorFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DIGAction
extends AbstractOWLModelAction {
    public String getMenubarPath() {
        return "Code/2_Ontology_Language";
    }

    public String getName() {
        return "Show DIG code...";
    }

    public void run(OWLModel oWLModel) {
        DIGTranslator dIGTranslator = DIGTranslatorFactory.getInstance().createTranslator();
        Document document = dIGTranslator.createTellsDocument("");
        try {
            dIGTranslator.translateToDIG(oWLModel, document, (Node)document.getDocumentElement());
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndent(4);
            outputFormat.setIndenting(true);
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.serialize(document);
            JTextArea jTextArea = new JTextArea(stringWriter.getBuffer().toString());
            jTextArea.setFont(new Font("Courier New", 0, 12));
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setPreferredSize(new Dimension(600, 600));
            ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(oWLModel.getProject()), jScrollPane, "DIG Code", 14);
        }
        catch (DIGReasonerException dIGReasonerException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", dIGReasonerException);
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }
}

