/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.property;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixPanel;
import edu.stanford.smi.protegex.owl.ui.matrix.property.PropertyMatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;

public class SubpropertiesMatrixAction
extends ResourceAction {
    public SubpropertiesMatrixAction() {
        super("Show list of subproperties", OWLIcons.getImageIcon("PropertyMatrix"), "Search and View/");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLModel oWLModel = this.getOWLModel();
        final RDFProperty rDFProperty = (RDFProperty)this.getResource();
        MatrixFilter matrixFilter = new MatrixFilter(){

            public Collection getInitialValues() {
                ArrayList arrayList = new ArrayList();
                for (Object e : rDFProperty.getSubproperties(true)) {
                    if (!(e instanceof RDFProperty)) continue;
                    arrayList.add(e);
                }
                arrayList.remove(rDFProperty);
                return arrayList;
            }

            public String getName() {
                return "Subproperties of " + rDFProperty.getBrowserText();
            }

            public boolean isSuitable(RDFResource rDFResource) {
                return rDFResource instanceof RDFProperty && rDFResource.isVisible() && (rDFResource.isEditable() || rDFResource.isIncluded()) && ((RDFProperty)rDFResource).isSubpropertyOf(rDFProperty, true);
            }
        };
        MatrixPanel matrixPanel = new MatrixPanel(oWLModel, matrixFilter, new PropertyMatrixTableModel(oWLModel, matrixFilter));
        ResultsPanelManager.addResultsPanel(oWLModel, matrixPanel, true);
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return rDFResource instanceof RDFProperty;
    }
}

