/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ClassMatrixPanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;

public class ClassMatrixAction
extends AbstractAction {
    private OWLModel owlModel;

    public ClassMatrixAction(OWLModel oWLModel) {
        super("Show matrix of all classes", OWLIcons.getImageIcon("ClassMatrix"));
        this.owlModel = oWLModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!OWLUI.isConfirmationNeeded(this.owlModel) || OWLUI.isConfirmed(this.owlModel, this.owlModel.getClsCount() > OWLUI.getConfirmationThreshold(this.owlModel))) {
            this.performAction();
        }
    }

    private void performAction() {
        MatrixFilter matrixFilter = new MatrixFilter(){

            public Collection getInitialValues() {
                Collection collection = ClassMatrixAction.this.owlModel.getUserDefinedOWLNamedClasses();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)iterator.next();
                    if (this.isSuitable(rDFSNamedClass)) continue;
                    iterator.remove();
                }
                return collection;
            }

            public String getName() {
                return "All Classes";
            }

            public boolean isSuitable(RDFResource rDFResource) {
                return rDFResource instanceof RDFSNamedClass && rDFResource.isVisible() && (rDFResource.isEditable() || rDFResource.isIncluded());
            }
        };
        ClassMatrixPanel classMatrixPanel = new ClassMatrixPanel(this.owlModel, matrixFilter);
        ResultsPanelManager.addResultsPanel(this.owlModel, classMatrixPanel, true);
    }
}

