/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.matrix.AnnotationPropertyMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.DependentMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.DependentMatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.EditableMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTable;
import edu.stanford.smi.protegex.owl.ui.matrix.NameMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.PrefixMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.SortableMatrixColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MatrixTableModel
extends AbstractTableModel
implements Disposable {
    public static final int COL_NAME = 0;
    public static final int COL_PREFIX = 1;
    private List columns = new ArrayList();
    private MatrixFilter filter;
    private List instances = new ArrayList();
    private ModelListener modelListener = new ModelAdapter(){

        public void classCreated(RDFSClass rDFSClass) {
            MatrixTableModel.this.handleInstanceCreated(rDFSClass);
        }

        public void classDeleted(RDFSClass rDFSClass) {
            MatrixTableModel.this.handleInstanceDeleted(rDFSClass);
        }

        public void individualCreated(RDFResource rDFResource) {
            MatrixTableModel.this.handleInstanceCreated(rDFResource);
        }

        public void individualDeleted(RDFResource rDFResource) {
            MatrixTableModel.this.handleInstanceDeleted(rDFResource);
        }

        public void propertyCreated(RDFProperty rDFProperty) {
            MatrixTableModel.this.handleInstanceCreated(rDFProperty);
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            MatrixTableModel.this.handleInstanceDeleted(rDFProperty);
        }
    };
    private OWLModel owlModel;
    private int sortColumn = 0;
    private MatrixTable table;

    public MatrixTableModel(OWLModel oWLModel, MatrixFilter matrixFilter) {
        this.owlModel = oWLModel;
        this.filter = matrixFilter;
        this.addDefaultColumns();
        oWLModel.addModelListener(this.modelListener);
        this.addInstances();
    }

    public void addColumn(MatrixColumn matrixColumn) {
        this.columns.add(matrixColumn);
    }

    void addColumn(MatrixColumn matrixColumn, int n) {
        this.columns.add(n, matrixColumn);
    }

    protected void addDefaultColumns() {
        this.addColumn(new NameMatrixColumn());
        this.addColumn(new PrefixMatrixColumn());
    }

    private void addInstances() {
        this.instances.addAll(this.filter.getInitialValues());
        this.sortInstances();
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.modelListener);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Class getColumnClass(int n) {
        return RDFResource.class;
    }

    public String getColumnName(int n) {
        MatrixColumn matrixColumn = this.getMatrixColumn(n);
        String string = matrixColumn.getName();
        if (string != null && n == this.sortColumn) {
            string = "[" + string + "]";
        }
        return string;
    }

    private int getIndexFor(RDFResource rDFResource) {
        SortableMatrixColumn sortableMatrixColumn = this.getSortableMatrixColumn();
        Comparator comparator = sortableMatrixColumn.getSortComparator();
        int n = Collections.binarySearch(this.instances, rDFResource, comparator);
        if (n >= 0) {
            return n;
        }
        return -n - 1;
    }

    public RDFResource getInstance(int n) {
        return (RDFResource)this.instances.get(n);
    }

    public MatrixColumn getMatrixColumn(int n) {
        return (MatrixColumn)this.columns.get(n);
    }

    public int getNewColumnIndex(MatrixColumn matrixColumn) {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.instances.size();
    }

    private SortableMatrixColumn getSortableMatrixColumn() {
        return (SortableMatrixColumn)this.getMatrixColumn(this.sortColumn);
    }

    public Object getValueAt(int n, int n2) {
        return this.getInstance(n);
    }

    public Collection getVisibleAnnotationProperties() {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        for (Object e : this.columns) {
            if (!(e instanceof AnnotationPropertyMatrixColumn)) continue;
            arrayList.add(((AnnotationPropertyMatrixColumn)e).getAnnotationProperty());
        }
        return arrayList;
    }

    private void handleInstanceCreated(Instance instance) {
        RDFResource rDFResource;
        if (instance instanceof RDFResource && this.filter.isSuitable(rDFResource = (RDFResource)instance)) {
            int n = this.getIndexFor(rDFResource);
            this.instances.add(n, rDFResource);
            this.fireTableRowsInserted(n, n);
        }
    }

    private void handleInstanceDeleted(RDFResource rDFResource) {
        if (this.isDependentOn(rDFResource)) {
            this.table.close();
        } else {
            this.removeDependentColumns(rDFResource);
            int n = this.instances.indexOf(rDFResource);
            if (n >= 0) {
                this.instances.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        RDFResource rDFResource;
        MatrixColumn matrixColumn = this.getMatrixColumn(n2);
        if (matrixColumn instanceof EditableMatrixColumn && (rDFResource = this.getInstance(n)).isEditable()) {
            return ((EditableMatrixColumn)matrixColumn).isCellEditable(rDFResource);
        }
        return false;
    }

    protected boolean isDependentOn(RDFResource rDFResource) {
        if (this.filter instanceof DependentMatrixFilter) {
            return ((DependentMatrixFilter)this.filter).isDependentOn(rDFResource);
        }
        return false;
    }

    public boolean isSortableColumn(int n) {
        return this.getMatrixColumn(n) instanceof SortableMatrixColumn;
    }

    public void refill() {
        this.instances.clear();
        this.addInstances();
        this.fireTableDataChanged();
    }

    private void removeDependentColumns(RDFResource rDFResource) {
        for (MatrixColumn matrixColumn : new ArrayList(this.columns)) {
            if (!(matrixColumn instanceof DependentMatrixColumn) || !((DependentMatrixColumn)matrixColumn).isDependentOn(rDFResource)) continue;
            this.removeColumn(matrixColumn);
        }
    }

    private void removeColumn(MatrixColumn matrixColumn) {
        int n = this.columns.indexOf(matrixColumn);
        this.columns.remove(n);
        this.fireTableStructureChanged();
        this.table.initColumns();
    }

    public void setSortColumn(int n) {
        if (n != this.sortColumn) {
            this.sortColumn = n;
            this.sortInstances();
            this.fireTableStructureChanged();
        }
    }

    void setTable(MatrixTable matrixTable) {
        this.table = matrixTable;
    }

    public void setValueAt(Object object, int n, int n2) {
        MatrixColumn matrixColumn = this.getMatrixColumn(n2);
        if (matrixColumn instanceof EditableMatrixColumn) {
            RDFResource rDFResource = this.getInstance(n);
            ((EditableMatrixColumn)matrixColumn).setValueAt(rDFResource, object);
        }
    }

    private void sortInstances() {
        SortableMatrixColumn sortableMatrixColumn = this.getSortableMatrixColumn();
        Collections.sort(this.instances, sortableMatrixColumn.getSortComparator());
    }
}

