/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.AssertedInstancesListDragSourceListener;
import edu.stanford.smi.protegex.owl.ui.individuals.AssertedInstancesListPanel;
import edu.stanford.smi.protegex.owl.ui.individuals.AssertedTypesListPanel;
import edu.stanford.smi.protegex.owl.ui.individuals.IndividualsClassesTreeTarget;
import edu.stanford.smi.protegex.owl.ui.individuals.IndividualsTabClassesPanel;
import edu.stanford.smi.protegex.owl.ui.individuals.InferredInstancesListPanel;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryTabWidget;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class OWLIndividualsTab
extends AbstractTabWidget
implements NavigationHistoryTabWidget {
    private AssertedInstancesListPanel assertedInstancesListPanel;
    private IndividualsTabClassesPanel classesPanel;
    private InferredInstancesListPanel inferredInstancesListPanel;
    private ResourcePanel resourcePanel;
    private AssertedTypesListPanel typesListPanel;

    private void adjustInstancesDisplayPanel() {
        Component component = null;
        for (int i = 0; i < this.assertedInstancesListPanel.getComponentCount(); ++i) {
            if (!(this.assertedInstancesListPanel.getComponent(i) instanceof LabeledComponent)) continue;
            component = this.assertedInstancesListPanel.getComponent(i);
        }
        assert (component != null);
        Container container = component.getParent();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Asserted", component);
        jTabbedPane.addTab("Inferred", (Component)((Object)this.inferredInstancesListPanel));
        jTabbedPane.setBorder(null);
        container.add("Center", jTabbedPane);
    }

    protected AssertedInstancesListPanel createAssertedInstancesListPanel() {
        AssertedInstancesListPanel assertedInstancesListPanel = new AssertedInstancesListPanel(this.getOWLModel());
        assertedInstancesListPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Collection collection = OWLIndividualsTab.this.assertedInstancesListPanel.getSelection();
                Instance instance = collection.size() == 1 ? (Instance)CollectionUtilities.getFirstItem((Collection)collection) : null;
                if (instance == null || instance instanceof RDFResource) {
                    RDFResource rDFResource = (RDFResource)instance;
                    OWLIndividualsTab.this.resourcePanel.setResource(rDFResource);
                    OWLIndividualsTab.this.typesListPanel.setResource(rDFResource);
                } else if (OWLIndividualsTab.this.resourcePanel instanceof ResourceDisplay) {
                    ((ResourceDisplay)OWLIndividualsTab.this.resourcePanel).setInstance(instance);
                    OWLIndividualsTab.this.typesListPanel.setResource(null);
                }
            }
        });
        this.setInstanceSelectable((Selectable)assertedInstancesListPanel.getDragComponent());
        final JList jList = (JList)assertedInstancesListPanel.getDragComponent();
        jList.addMouseListener((MouseListener)new PopupMenuMouseListener(jList){

            protected JPopupMenu getPopupMenu() {
                Instance instance = (Instance)jList.getSelectedValue();
                if (instance instanceof RDFResource) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ResourceActionManager.addResourceActions(jPopupMenu, (Component)jList, (RDFResource)instance);
                    if (jPopupMenu.getComponentCount() > 0) {
                        return jPopupMenu;
                    }
                }
                return null;
            }

            protected void setSelection(JComponent jComponent, int n, int n2) {
                for (int i = 0; i < jList.getModel().getSize(); ++i) {
                    if (!jList.getCellBounds(i, i).contains(n, n2)) continue;
                    jList.setSelectedIndex(i);
                    return;
                }
                jList.setSelectedIndex(-1);
            }
        });
        return assertedInstancesListPanel;
    }

    protected InferredInstancesListPanel createInferredInstancesListPanel() {
        this.inferredInstancesListPanel = new InferredInstancesListPanel();
        this.inferredInstancesListPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Collection collection = OWLIndividualsTab.this.inferredInstancesListPanel.getSelection();
                Instance instance = collection.size() == 1 ? (Instance)CollectionUtilities.getFirstItem((Collection)collection) : null;
                if (instance == null || instance instanceof RDFResource) {
                    OWLIndividualsTab.this.resourcePanel.setResource((RDFResource)instance);
                } else if (OWLIndividualsTab.this.resourcePanel instanceof ResourceDisplay) {
                    ((ResourceDisplay)OWLIndividualsTab.this.resourcePanel).setInstance(instance);
                }
            }
        });
        return this.inferredInstancesListPanel;
    }

    private IndividualsTabClassesPanel createClassesPanel() {
        IndividualsTabClassesPanel individualsTabClassesPanel = new IndividualsTabClassesPanel(this.getOWLModel());
        individualsTabClassesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                OWLIndividualsTab.this.transmitSelection();
            }
        });
        return individualsTabClassesPanel;
    }

    private JComponent createClassSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("InstancesTab.left_right", 250);
        this.classesPanel = this.createClassesPanel();
        jSplitPane.setLeftComponent((Component)((Object)this.classesPanel));
        jSplitPane.setRightComponent(this.createInstanceSplitter());
        return jSplitPane;
    }

    protected JComponent createDirectTypesList() {
        this.typesListPanel = new AssertedTypesListPanel(this.getOWLModel());
        return this.typesListPanel;
    }

    private JComponent createInstancesPanel() {
        JSplitPane jSplitPane = ComponentFactory.createTopBottomSplitPane();
        this.assertedInstancesListPanel = this.createAssertedInstancesListPanel();
        jSplitPane.setTopComponent((Component)((Object)this.assertedInstancesListPanel));
        jSplitPane.setBottomComponent(this.createDirectTypesList());
        return jSplitPane;
    }

    private JComponent createInstanceSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("InstancesTab.right.left_right", 250);
        jSplitPane.setLeftComponent(this.createInstancesPanel());
        this.resourcePanel = ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 2);
        jSplitPane.setRightComponent((Component)((Object)this.resourcePanel));
        return jSplitPane;
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        if (rDFResource instanceof RDFIndividual && !(rDFResource instanceof OWLOntology) && !(rDFResource instanceof OWLAllDifferent)) {
            this.setSelectedResource(rDFResource);
            return true;
        }
        return false;
    }

    public Selectable getNestedSelectable() {
        return this.assertedInstancesListPanel;
    }

    public void initialize() {
        this.inferredInstancesListPanel = this.createInferredInstancesListPanel();
        this.add(this.createClassSplitter());
        this.transmitSelection();
        this.setupDragAndDrop();
        this.setClsTree(this.classesPanel.getDropComponent());
        this.setLabel("Individuals");
        this.setIcon(OWLIcons.getImageIcon("RDFIndividuals"));
        this.adjustInstancesDisplayPanel();
    }

    public static boolean isSuitable(Project project, Collection collection) {
        return OWLClassesTab.isSuitable(project, collection);
    }

    protected void transmitSelection(Collection collection) {
        if (collection.contains(this.getOWLModel().getOWLThingClass()) && this.getOWLModel() instanceof OWLDatabaseModel) {
            collection = Collections.EMPTY_LIST;
        }
        this.assertedInstancesListPanel.setClses(collection);
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            if (!(e instanceof RDFSClass)) continue;
            arrayList.add(e);
        }
        this.inferredInstancesListPanel.setTypes(arrayList);
    }

    public void setSelectedCls(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            this.setSelectedClass((RDFSNamedClass)cls);
        }
    }

    public void setSelectedClass(RDFSNamedClass rDFSNamedClass) {
        this.classesPanel.setSelectedClass(rDFSNamedClass);
    }

    public void setSelectedInstance(Instance instance) {
        if (instance instanceof RDFResource) {
            this.setSelectedResource((RDFResource)instance);
        }
    }

    public void setSelectedResource(RDFResource rDFResource) {
        this.classesPanel.setSelectedClass((RDFSNamedClass)rDFResource.getRDFType());
        this.assertedInstancesListPanel.setSelectedInstance(rDFResource);
        this.typesListPanel.setResource(rDFResource);
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.assertedInstancesListPanel.getDragComponent(), 3, (DragGestureListener)((Object)new AssertedInstancesListDragSourceListener()));
        new DropTarget(this.classesPanel.getDropComponent(), 3, (DropTargetListener)((Object)new IndividualsClassesTreeTarget()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmitSelection() {
        WaitCursor waitCursor = new WaitCursor((Component)((Object)this));
        try {
            Collection collection = this.classesPanel.getSelection();
            this.transmitSelection(collection);
        }
        finally {
            waitCursor.hide();
        }
    }
}

